/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Objects;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PrimeAmongSecondarySupertypes;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.proxy.HibernateProxy;

public final class ManagedTypeHelper {
    private static final ClassValue<TypeMeta> typeMetaCache = new ClassValue<TypeMeta>(){

        @Override
        protected TypeMeta computeValue(Class<?> type) {
            return new TypeMeta(type);
        }
    };

    public static boolean isManagedType(Class type) {
        return ManagedTypeHelper.typeMetaCache.get(type).isManagedType;
    }

    public static boolean isSelfDirtinessTrackerType(Class type) {
        return ManagedTypeHelper.typeMetaCache.get(type).isSelfDirtinessTrackerType;
    }

    public static boolean isPersistentAttributeInterceptableType(Class type) {
        return ManagedTypeHelper.typeMetaCache.get(type).isPersistentAttributeInterceptable;
    }

    public static boolean isManagedEntity(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asManagedEntity() != null;
        }
        return false;
    }

    public static boolean isHibernateProxy(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asHibernateProxy() != null;
        }
        return false;
    }

    public static boolean isPersistentAttributeInterceptable(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asPersistentAttributeInterceptable() != null;
        }
        return false;
    }

    public static boolean isSelfDirtinessTracker(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asSelfDirtinessTracker() != null;
        }
        return false;
    }

    public static boolean isCompositeOwner(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asCompositeOwner() != null;
        }
        return false;
    }

    public static boolean isCompositeTracker(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asCompositeTracker() != null;
        }
        return false;
    }

    public static <T> void processIfPersistentAttributeInterceptable(Object entity, PersistentAttributeInterceptableAction<T> action, T optionalParam) {
        PrimeAmongSecondarySupertypes t;
        PersistentAttributeInterceptable e;
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asPersistentAttributeInterceptable()) != null) {
            action.accept(e, optionalParam);
        }
    }

    public static void processIfSelfDirtinessTracker(Object entity, SelfDirtinessTrackerConsumer action) {
        PrimeAmongSecondarySupertypes t;
        SelfDirtinessTracker e;
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asSelfDirtinessTracker()) != null) {
            action.accept(e);
        }
    }

    public static <T> void processIfSelfDirtinessTracker(Object entity, SelfDirtinessTrackerAction<T> action, T optionalParam) {
        PrimeAmongSecondarySupertypes t;
        SelfDirtinessTracker e;
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asSelfDirtinessTracker()) != null) {
            action.accept(e, optionalParam);
        }
    }

    public static PersistentAttributeInterceptable asPersistentAttributeInterceptable(Object entity) {
        PrimeAmongSecondarySupertypes t;
        PersistentAttributeInterceptable e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asPersistentAttributeInterceptable()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to PersistentAttributeInterceptable");
    }

    public static PersistentAttributeInterceptable asPersistentAttributeInterceptableOrNull(Object entity) {
        if (entity instanceof PrimeAmongSecondarySupertypes) {
            PrimeAmongSecondarySupertypes t = (PrimeAmongSecondarySupertypes)entity;
            return t.asPersistentAttributeInterceptable();
        }
        return null;
    }

    public static HibernateProxy asHibernateProxy(Object entity) {
        PrimeAmongSecondarySupertypes t;
        HibernateProxy e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asHibernateProxy()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to HibernateProxy");
    }

    public static ManagedEntity asManagedEntity(Object entity) {
        PrimeAmongSecondarySupertypes t;
        ManagedEntity e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asManagedEntity()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to ManagedEntity");
    }

    public static CompositeTracker asCompositeTracker(Object entity) {
        PrimeAmongSecondarySupertypes t;
        CompositeTracker e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asCompositeTracker()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to CompositeTracker");
    }

    public static CompositeOwner asCompositeOwner(Object entity) {
        PrimeAmongSecondarySupertypes t;
        CompositeOwner e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asCompositeOwner()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to CompositeOwner");
    }

    public static SelfDirtinessTracker asSelfDirtinessTracker(Object entity) {
        PrimeAmongSecondarySupertypes t;
        SelfDirtinessTracker e;
        Objects.requireNonNull(entity);
        if (entity instanceof PrimeAmongSecondarySupertypes && (e = (t = (PrimeAmongSecondarySupertypes)entity).asSelfDirtinessTracker()) != null) {
            return e;
        }
        throw new ClassCastException("Object of type '" + entity.getClass() + "' can't be cast to SelfDirtinessTracker");
    }

    public static HibernateProxy asHibernateProxyOrNull(Object entity) {
        return entity instanceof PrimeAmongSecondarySupertypes ? ((PrimeAmongSecondarySupertypes)entity).asHibernateProxy() : null;
    }

    private static final class TypeMeta {
        final boolean isManagedType;
        final boolean isSelfDirtinessTrackerType;
        final boolean isPersistentAttributeInterceptable;

        TypeMeta(Class<?> type) {
            Objects.requireNonNull(type);
            this.isManagedType = Managed.class.isAssignableFrom(type);
            this.isSelfDirtinessTrackerType = SelfDirtinessTracker.class.isAssignableFrom(type);
            this.isPersistentAttributeInterceptable = PersistentAttributeInterceptable.class.isAssignableFrom(type);
        }
    }

    @FunctionalInterface
    public static interface SelfDirtinessTrackerAction<T> {
        public void accept(SelfDirtinessTracker var1, T var2);
    }

    @FunctionalInterface
    public static interface SelfDirtinessTrackerConsumer {
        public void accept(SelfDirtinessTracker var1);
    }

    @FunctionalInterface
    public static interface PersistentAttributeInterceptableAction<T> {
        public void accept(PersistentAttributeInterceptable var1, T var2);
    }
}

