/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.DiscriminatorValueDetailsImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class DiscriminatorConverter<O, R>
implements BasicValueConverter<O, R> {
    private final NavigableRole discriminatorRole;
    private final JavaType<O> domainJavaType;
    private final JavaType<R> relationalJavaType;
    private final Map<Object, DiscriminatorValueDetails> discriminatorValueToEntityNameMap;
    private final Map<String, DiscriminatorValueDetails> entityNameToDiscriminatorValueMap;

    public static <O, R> DiscriminatorConverter<O, R> fromValueMappings(NavigableRole role, JavaType<O> domainJavaType, BasicType<R> underlyingJdbcMapping, Map<Object, String> valueMappings, SessionFactoryImplementor sessionFactory) {
        MappingMetamodelImplementor mappingMetamodel = sessionFactory.getMappingMetamodel();
        ArrayList<DiscriminatorValueDetails> valueDetailsList = CollectionHelper.arrayList(valueMappings.size());
        valueMappings.forEach((value, entityName) -> {
            DiscriminatorValueDetailsImpl valueDetails = new DiscriminatorValueDetailsImpl(value, mappingMetamodel.getEntityDescriptor((String)entityName));
            valueDetailsList.add(valueDetails);
        });
        return new DiscriminatorConverter<O, R>(role, domainJavaType, underlyingJdbcMapping.getJavaTypeDescriptor(), valueDetailsList);
    }

    public DiscriminatorConverter(NavigableRole discriminatorRole, JavaType<O> domainJavaType, JavaType<R> relationalJavaType, List<DiscriminatorValueDetails> valueMappings) {
        this.discriminatorRole = discriminatorRole;
        this.domainJavaType = domainJavaType;
        this.relationalJavaType = relationalJavaType;
        this.discriminatorValueToEntityNameMap = CollectionHelper.concurrentMap(valueMappings.size());
        this.entityNameToDiscriminatorValueMap = CollectionHelper.concurrentMap(valueMappings.size());
        valueMappings.forEach(valueDetails -> {
            this.discriminatorValueToEntityNameMap.put(valueDetails.getValue(), (DiscriminatorValueDetails)valueDetails);
            this.entityNameToDiscriminatorValueMap.put(valueDetails.getIndicatedEntityName(), (DiscriminatorValueDetails)valueDetails);
        });
    }

    public NavigableRole getNavigableRole() {
        return this.discriminatorRole;
    }

    @Override
    public JavaType<O> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    public DiscriminatorValueDetails getDetailsForRelationalForm(R relationalForm) {
        return this.getDetailsForDiscriminatorValue(relationalForm);
    }

    @Override
    public O toDomainValue(R relationalForm) {
        assert (relationalForm == null || this.relationalJavaType.isInstance(relationalForm));
        DiscriminatorValueDetails matchingValueDetails = this.getDetailsForRelationalForm(relationalForm);
        if (matchingValueDetails == null) {
            throw new IllegalStateException("Could not resolve discriminator value");
        }
        EntityMappingType indicatedEntity = matchingValueDetails.getIndicatedEntity();
        return (O)(indicatedEntity.getRepresentationStrategy().getMode() == RepresentationMode.POJO && indicatedEntity.getEntityName().equals(indicatedEntity.getJavaType().getJavaTypeClass().getName()) ? indicatedEntity.getJavaType().getJavaTypeClass() : indicatedEntity.getEntityName());
    }

    public DiscriminatorValueDetails getDetailsForEntityName(String entityName) {
        return this.entityNameToDiscriminatorValueMap.get(entityName);
    }

    public DiscriminatorValueDetails getDetailsForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.discriminatorValueToEntityNameMap.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        DiscriminatorValueDetails valueMatch = this.discriminatorValueToEntityNameMap.get(value);
        if (valueMatch != null) {
            return valueMatch;
        }
        return this.discriminatorValueToEntityNameMap.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR);
    }

    @Override
    public R toRelationalValue(O domainForm) {
        assert (domainForm == null || domainForm instanceof String || domainForm instanceof Class);
        if (domainForm == null) {
            return null;
        }
        String entityName = domainForm instanceof Class ? ((Class)domainForm).getName() : (String)domainForm;
        DiscriminatorValueDetails discriminatorValueDetails = this.getDetailsForEntityName(entityName);
        return (R)discriminatorValueDetails.getValue();
    }

    public String toString() {
        return "DiscriminatorConverter(" + this.discriminatorRole.getFullPath() + ")";
    }

    public void forEachValueDetail(Consumer<DiscriminatorValueDetails> consumer) {
        this.discriminatorValueToEntityNameMap.forEach((value, detail) -> consumer.accept((DiscriminatorValueDetails)detail));
    }

    public <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> handler) {
        for (DiscriminatorValueDetails detail : this.discriminatorValueToEntityNameMap.values()) {
            X result = handler.apply(detail);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

