/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.spi;

import java.util.Set;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.sql.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.sql.spi.NativeQueryImplementor;

public interface NamedNativeQueryMemento
extends NamedQueryMemento {
    public String getSqlString();

    default public String getOriginalSqlString() {
        return this.getSqlString();
    }

    public Set<String> getQuerySpaces();

    public String getResultMappingName();

    public Class<?> getResultMappingClass();

    public Integer getFirstResult();

    public Integer getMaxResults();

    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor var1);

    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor var1, Class<T> var2);

    public <T> NativeQueryImplementor<T> toQuery(SharedSessionContractImplementor var1, String var2);

    @Override
    public NamedNativeQueryMemento makeCopy(String var1);

    public static class Builder
    extends AbstractNamedQueryMemento.AbstractBuilder<Builder> {
        protected String queryString;
        protected Integer firstResult;
        protected Integer maxResults;
        protected Set<String> querySpaces;
        protected String resultSetMappingName;
        protected String resultSetMappingClassName;

        public Builder(String name) {
            super(name);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setQuery(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder setFirstResult(Integer firstResult) {
            this.firstResult = firstResult;
            return this;
        }

        public Builder setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public void setQuerySpaces(Set<String> querySpaces) {
            this.querySpaces = querySpaces;
        }

        public void setResultSetMappingName(String resultSetMappingName) {
            this.resultSetMappingName = resultSetMappingName;
        }

        public void setResultSetMappingClassName(String resultSetMappingClassName) {
            this.resultSetMappingClassName = resultSetMappingClassName;
        }

        public NamedNativeQueryMemento build(SessionFactoryImplementor sessionFactory) {
            return new NamedNativeQueryMementoImpl(this.name, this.queryString, this.queryString, this.resultSetMappingName, sessionFactory.getServiceRegistry().getService(ClassLoaderService.class).classForName(this.resultSetMappingClassName), this.querySpaces, this.cacheable, this.cacheRegion, this.cacheMode, this.flushMode, this.readOnly, this.timeout, this.fetchSize, this.comment, this.firstResult, this.maxResults, this.hints);
        }
    }
}

