
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *                 @Target({TYPE}) @Retention(RUNTIME)
 *                 public @interface SecondaryTable {
 *                 String name();
 *                 String catalog() default "";
 *                 String schema() default "";
 *                 PrimaryKeyJoinColumn[] pkJoinColumns() default {};
 *                 UniqueConstraint[] uniqueConstraints() default {};
 *                 Index[] indexes() default {};
 *                 }
 * 
 *             
 * 
 * <p>Java class for secondary-table complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="secondary-table">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <sequence>
 *           <element name="primary-key-join-column" type="{http://www.hibernate.org/xsd/orm/mapping}primary-key-join-column" maxOccurs="unbounded" minOccurs="0"/>
 *           <element name="primary-key-foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/>
 *         </sequence>
 *         <group ref="{http://www.hibernate.org/xsd/orm/mapping}hbm-common-table-extensions"/>
 *         <element name="unique-constraint" type="{http://www.hibernate.org/xsd/orm/mapping}unique-constraint" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="index" type="{http://www.hibernate.org/xsd/orm/mapping}index" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="schema" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="optional" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "secondary-table", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "primaryKeyJoinColumn",
    "primaryKeyForeignKey",
    "comment",
    "check",
    "uniqueConstraint",
    "index"
})
public class JaxbSecondaryTable
    implements Serializable, SchemaAware
{

    @XmlElement(name = "primary-key-join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbPrimaryKeyJoinColumn> primaryKeyJoinColumn;
    @XmlElement(name = "primary-key-foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey primaryKeyForeignKey;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String comment;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String check;
    @XmlElement(name = "unique-constraint", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbUniqueConstraint> uniqueConstraint;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbIndex> index;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "catalog")
    protected String catalog;
    @XmlAttribute(name = "schema")
    protected String schema;
    @XmlAttribute(name = "optional")
    protected Boolean optional;

    /**
     * Gets the value of the primaryKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the primaryKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbPrimaryKeyJoinColumn }
     * 
     * 
     * @return
     *     The value of the primaryKeyJoinColumn property.
     */
    public List<JaxbPrimaryKeyJoinColumn> getPrimaryKeyJoinColumn() {
        if (primaryKeyJoinColumn == null) {
            primaryKeyJoinColumn = new ArrayList<>();
        }
        return this.primaryKeyJoinColumn;
    }

    /**
     * Gets the value of the primaryKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getPrimaryKeyForeignKey() {
        return primaryKeyForeignKey;
    }

    /**
     * Sets the value of the primaryKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setPrimaryKeyForeignKey(JaxbForeignKey value) {
        this.primaryKeyForeignKey = value;
    }

    /**
     * Gets the value of the comment property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComment() {
        return comment;
    }

    /**
     * Sets the value of the comment property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setComment(String value) {
        this.comment = value;
    }

    /**
     * Gets the value of the check property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCheck() {
        return check;
    }

    /**
     * Sets the value of the check property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheck(String value) {
        this.check = value;
    }

    /**
     * Gets the value of the uniqueConstraint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the uniqueConstraint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUniqueConstraint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbUniqueConstraint }
     * 
     * 
     * @return
     *     The value of the uniqueConstraint property.
     */
    public List<JaxbUniqueConstraint> getUniqueConstraint() {
        if (uniqueConstraint == null) {
            uniqueConstraint = new ArrayList<>();
        }
        return this.uniqueConstraint;
    }

    /**
     * Gets the value of the index property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the index property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIndex().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbIndex }
     * 
     * 
     * @return
     *     The value of the index property.
     */
    public List<JaxbIndex> getIndex() {
        if (index == null) {
            index = new ArrayList<>();
        }
        return this.index;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchema(String value) {
        this.schema = value;
    }

    /**
     * Gets the value of the optional property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOptional() {
        return optional;
    }

    /**
     * Sets the value of the optional property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptional(Boolean value) {
        this.optional = value;
    }

}
