/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoStandard;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordStandard;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.type.descriptor.java.JavaType;

public class IdClassRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final JavaType<?> idClassType;
    private final EmbeddableInstantiator instantiator;

    public IdClassRepresentationStrategy(IdClassEmbeddable idClassEmbeddable) {
        this.idClassType = idClassEmbeddable.getMappedJavaType();
        this.instantiator = ReflectHelper.isRecord(this.idClassType.getJavaTypeClass()) ? new EmbeddableInstantiatorRecordStandard(this.idClassType.getJavaTypeClass()) : new EmbeddableInstantiatorPojoStandard(this.idClassType, () -> idClassEmbeddable);
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.idClassType;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        PropertyAccessStrategy strategy = bootAttributeDescriptor.getPropertyAccessStrategy(this.idClassType.getJavaTypeClass());
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.idClassType.getTypeName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(this.idClassType.getJavaTypeClass(), bootAttributeDescriptor.getName(), false);
    }
}

