/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;

public class ImRPOAInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected int port;
    protected ImRServerInfo server;
    protected String host;
    protected String name;
    protected boolean active;
    protected long timeout;

    public ImRPOAInfo(String name, String host, int port, ImRServerInfo server, long timeout) throws IllegalPOAName {
        if (name == null || name.length() == 0) {
            throw new IllegalPOAName(name);
        }
        this.name = name;
        this.host = host;
        this.port = port;
        this.server = server;
        this.active = true;
        this.timeout = timeout;
    }

    public POAInfo toPOAInfo() {
        return new POAInfo(this.name, this.host, this.port, this.server.name, this.active);
    }

    public synchronized void reactivate(String host, int port) {
        this.host = host;
        this.port = port;
        this.active = true;
        this.server.active = true;
        this.server.restarting = false;
        this.notifyAll();
    }

    public synchronized boolean awaitActivation() {
        while (!this.active) {
            try {
                long _sleep_begin = System.currentTimeMillis();
                this.wait(this.timeout);
                if (this.active || System.currentTimeMillis() - _sleep_begin <= this.timeout) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

