/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptor;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.OutputStream;
import org.omg.ETF.Profile;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class BiDirConnectionClientInterceptor
extends DefaultClientInterceptor {
    private static final String name = "BiDirConnectionClientInterceptor";
    private final ORB orb;
    private ServiceContext bidir_ctx = null;

    public BiDirConnectionClientInterceptor(ORB orb) {
        this.orb = orb;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init_bidir_ctx() {
        if (this.bidir_ctx != null) {
            return;
        }
        BasicAdapter ba = this.orb.getBasicAdapter();
        List<Profile> endpoints = ba.getEndpointProfiles();
        Iterator<Profile> i = endpoints.iterator();
        ArrayList listenPoints = new ArrayList();
        while (i.hasNext()) {
            Profile profile = i.next();
            if (profile instanceof ProfileBase) {
                listenPoints.addAll(((ProfileBase)profile).asListenPoints());
                continue;
            }
            listenPoints.addAll(this.getListenPoints(profile));
        }
        ListenPoint[] listenPointsArray = listenPoints.toArray(new ListenPoint[listenPoints.size()]);
        BiDirIIOPServiceContext context = new BiDirIIOPServiceContext(listenPointsArray);
        Any any = this.orb.create_any();
        BiDirIIOPServiceContextHelper.insert((Any)any, (BiDirIIOPServiceContext)context);
        CDROutputStream cdr_out = new CDROutputStream((org.omg.CORBA.ORB)this.orb);
        try {
            cdr_out.beginEncapsulatedArray();
            BiDirIIOPServiceContextHelper.write((OutputStream)cdr_out, (BiDirIIOPServiceContext)context);
            this.bidir_ctx = new ServiceContext(5, cdr_out.getBufferCopy());
        }
        finally {
            cdr_out.close();
        }
    }

    @Override
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        GIOPConnection conn;
        if (!this.orb.useBiDirGIOP() || ((ClientRequestInfoImpl)ri).isLocalInterceptor() || !((ClientRequestInfoImpl)ri).getConnection().isClientInitiated()) {
            return;
        }
        if (this.bidir_ctx == null) {
            this.init_bidir_ctx();
        }
        if (!((ClientRequestInfoImpl)ri).getConnection().isListenPointListSent()) {
            ri.add_request_service_context(this.bidir_ctx, true);
        }
        if ((conn = ((ClientRequestInfoImpl)ri).getConnection().getGIOPConnection()).getRequestListener() instanceof NoBiDirClientRequestListener) {
            conn.setRequestListener(this.orb.getBasicAdapter().getRequestListener());
        }
    }

    protected Collection getListenPoints(Profile profile) {
        return Collections.EMPTY_LIST;
    }
}

