/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.diop.DIOPFactories;
import org.jacorb.orb.etf.ListenEndpoint;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;
import org.slf4j.Logger;

public class TransportManager
implements Configurable {
    private Configuration configuration = null;
    private Logger logger = null;
    private List<String> factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private final SocketFactoryManager socketFactoryManager = new SocketFactoryManager();
    private boolean useNonBlockingIIOPTransport = false;
    private Map<Integer, Factories> factoriesMap = null;
    private List<Factories> factoriesList = null;
    private HashMap<ListenEndpoint.Protocol, HashSet<ListenEndpoint>> listenEndpointList = null;
    private TransportListener listener = null;

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.orb.giop");
        this.useNonBlockingIIOPTransport = this.configuration.getAttributeAsBoolean("jacorb.connection.nonblocking", false);
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.updateListenEndpointAddresses();
        this.updateDefaultEndpointAddresses();
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public synchronized Factories getFactories(int tag) {
        if (tag == 1413566212) {
            return DIOPFactories.getDIOPFactory();
        }
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return this.factoriesMap.get(tag);
    }

    public synchronized List<Factories> getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    public HashSet<ListenEndpoint> getListenEndpoints(ListenEndpoint.Protocol p) {
        HashSet<ListenEndpoint> endpoints = this.listenEndpointList.get((Object)p);
        if (endpoints == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to find endpoints for " + (Object)((Object)p));
            }
            ListenEndpoint l = new ListenEndpoint();
            l.setProtocol(p);
            endpoints = new HashSet();
            endpoints.add(l);
            this.listenEndpointList.put(p, endpoints);
        }
        return endpoints;
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames may not be null");
        }
        this.factoriesMap = new HashMap<Integer, Factories>();
        this.factoriesList = new ArrayList<Factories>();
        for (String className : this.factoryClassNames) {
            Factories factories = this.instantiateFactories(className);
            this.factoriesMap.put(factories.profile_tag(), factories);
            this.factoriesList.add(factories);
        }
    }

    private Factories instantiateFactories(String className) {
        try {
            Class<?> clazz;
            Object instance;
            if (this.useNonBlockingIIOPTransport && "org.jacorb.orb.iiop.IIOPFactories".equals(className)) {
                className = "org.jacorb.orb.nio.NIOFactories";
            }
            if ((instance = (clazz = ObjectUtil.classForName(className)).newInstance()) instanceof Configurable) {
                Configurable configurable = (Configurable)instance;
                configurable.configure(this.configuration);
            }
            this.logger.debug("created org.omg.ETF.Factories: " + className);
            return (Factories)instance;
        }
        catch (Exception e) {
            throw new BAD_PARAM("could not instantiate Factories class " + className + ", exception: " + e);
        }
    }

    public void notifyTransportListeners(GIOPConnection giopc) {
        if (this.listener != null) {
            this.listener.transportSelected(new TransportListener.Event(giopc));
        }
    }

    public void addTransportListener(TransportListener tl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Transport listener to add: " + tl);
        }
        if (tl != null) {
            this.addTransportListenerImpl(tl);
        }
    }

    private synchronized void addTransportListenerImpl(final TransportListener tl) {
        this.listener = this.listener == null ? tl : new TransportListener(){
            private final TransportListener next_;
            {
                this.next_ = TransportManager.this.listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transportSelected(TransportListener.Event event) {
                try {
                    tl.transportSelected(event);
                }
                finally {
                    this.next_.transportSelected(event);
                }
            }
        };
    }

    private ProtocolAddressBase createProtocolAddress(String address_str) {
        IIOPAddress address = new IIOPAddress();
        int proto_delim = address_str.indexOf(58);
        ListenEndpoint.Protocol proto = ListenEndpoint.Protocol.valueOf(address_str.substring(0, proto_delim).toUpperCase(Locale.ENGLISH));
        address.setProtocol(proto);
        int addresss_start_ofs = proto_delim + 3;
        if (!address.fromString(address_str.substring(addresss_start_ofs))) {
            throw new INTERNAL("Invalid protocol address string: " + address_str);
        }
        return address;
    }

    private void updateDefaultEndpointAddresses() throws ConfigurationException {
        IIOPAddress address = null;
        IIOPAddress ssl_address = null;
        HashSet<ListenEndpoint> s = this.listenEndpointList.get((Object)ListenEndpoint.Protocol.IIOP);
        if (s != null) {
            return;
        }
        ListenEndpoint defaultEndpoint = new ListenEndpoint();
        String address_str = this.configuration.getAttribute("OAAddress", null);
        if (address_str != null) {
            String address_trim = address_str.trim();
            ProtocolAddressBase addr = this.createProtocolAddress(address_trim);
            address = (IIOPAddress)addr;
            address.configure(this.configuration);
        } else {
            int oaPort = this.configuration.getAttributeAsInteger("OAPort", 0);
            String oaHost = this.configuration.getAttribute("OAIAddr", "");
            address = new IIOPAddress(oaHost, oaPort);
            address.configure(this.configuration);
        }
        String ssl_address_str = this.configuration.getAttribute("OASSLAddress", null);
        if (ssl_address_str != null) {
            String ssl_address_trim = ssl_address_str.trim();
            ProtocolAddressBase ssl_addr = this.createProtocolAddress(ssl_address_trim);
            ssl_address = (IIOPAddress)ssl_addr;
            ssl_address.configure(this.configuration);
        } else {
            int ssl_oaPort = this.configuration.getAttributeAsInteger("OASSLPort", 0);
            String ssl_oaHost = this.configuration.getAttribute("OAIAddr", "");
            ssl_address = new IIOPAddress(ssl_oaHost, ssl_oaPort);
            ssl_address.configure(this.configuration);
        }
        if (address.getProtocol() == null) {
            address.setProtocol(ListenEndpoint.Protocol.IIOP);
        }
        defaultEndpoint.setAddress(address);
        defaultEndpoint.setSSLAddress(ssl_address);
        defaultEndpoint.setProtocol(address.getProtocol());
        s = new HashSet();
        s.add(defaultEndpoint);
        this.listenEndpointList.put(address.getProtocol(), s);
    }

    private void updateListenEndpointAddresses() throws ConfigurationException {
        this.listenEndpointList = new HashMap();
        String[] args = this.configuration.getORB().getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !args[i].equalsIgnoreCase("-ORBListenEndpoints")) continue;
                if (i + 1 >= args.length || args[i + 1] == null) {
                    throw new BAD_PARAM("Invalid ORBListenEndpoint <value> format: -ORBListenEndpoints argument without value");
                }
                String ep_args = args[i + 1];
                String ep_args_trim = ep_args.trim();
                if (ep_args_trim.charAt(0) == '\'' && ep_args_trim.charAt(ep_args_trim.length() - 1) == '\'') {
                    ep_args_trim = ep_args.trim().substring(1, ep_args.trim().length() - 1);
                }
                String[] seg_addr_list = ep_args_trim.split(";");
                for (int xx = 0; xx < seg_addr_list.length; ++xx) {
                    String seg_args = seg_addr_list[xx].trim();
                    if (seg_args.equals("")) continue;
                    String[] indiv_list = seg_args.trim().split(",");
                    for (int xxx = 0; xxx < indiv_list.length; ++xxx) {
                        ProtocolAddressBase addr1;
                        int opt_slash;
                        ListenEndpoint.Protocol protocol;
                        String address_str = null;
                        String ssl_port = null;
                        String host_str = "";
                        String[] options_args = null;
                        String addr_arg = indiv_list[xxx].trim();
                        if (addr_arg.equals("")) continue;
                        int delim = addr_arg.indexOf(":");
                        try {
                            protocol = ListenEndpoint.Protocol.valueOf(addr_arg.substring(0, delim).toUpperCase(Locale.ENGLISH));
                        }
                        catch (IllegalArgumentException e) {
                            throw new BAD_PARAM("Invalid ORBListenEndPoints protocol " + addr_arg);
                        }
                        int db_slash = addr_arg.indexOf("//", delim + 1);
                        if (db_slash == -1) {
                            throw new BAD_PARAM("Invalid ORBListenEndPoints <value;value;...> format: listen endpoint '" + addr_arg + "' is malformed!");
                        }
                        String dbs = "/";
                        if (protocol == ListenEndpoint.Protocol.UIOP) {
                            dbs = "|";
                        }
                        address_str = (opt_slash = addr_arg.indexOf(dbs, db_slash + 2)) == -1 ? addr_arg.substring(0) : addr_arg.substring(0, opt_slash);
                        if (opt_slash != -1) {
                            options_args = addr_arg.substring(opt_slash + 1).split("&");
                            for (int y = 0; y < options_args.length; ++y) {
                                String options_args_trim = options_args[xxx].trim();
                                int opt_delim = options_args_trim.indexOf(61);
                                if (opt_delim == -1) {
                                    throw new BAD_PARAM("error: listen endpoint options '" + options_args[y] + "' is malformed!");
                                }
                                String opt_str = options_args_trim.substring(0, opt_delim);
                                String opt_value = options_args_trim.substring(opt_delim + 1);
                                if (!opt_str.equalsIgnoreCase("ssl_port")) {
                                    throw new BAD_PARAM("error: listen endpoint options '" + options_args[y] + "' is not supported!");
                                }
                                ssl_port = opt_value;
                            }
                        }
                        if (address_str == null) continue;
                        String address_trim = address_str.trim();
                        IIOPAddress address = null;
                        IIOPAddress ssl_address = null;
                        if (protocol == ListenEndpoint.Protocol.IIOP) {
                            addr1 = this.createProtocolAddress(address_trim);
                            if (addr1 instanceof IIOPAddress) {
                                address = (IIOPAddress)addr1;
                                address.configure(this.configuration);
                            }
                            if (ssl_port != null) {
                                int colon_delim = address_trim.indexOf(":");
                                int port_delim = address_trim.indexOf(":", colon_delim + 2);
                                host_str = port_delim > 0 ? address_trim.substring(colon_delim + 3, port_delim) : "";
                                ssl_address = new IIOPAddress(host_str, Integer.parseInt(ssl_port));
                                ssl_address.configure(this.configuration);
                            }
                        } else if (protocol == ListenEndpoint.Protocol.SSLIOP) {
                            ProtocolAddressBase addr2 = this.createProtocolAddress(address_trim);
                            if (addr2 instanceof IIOPAddress) {
                                ssl_address = (IIOPAddress)addr2;
                                ssl_address.configure(this.configuration);
                            }
                        } else {
                            addr1 = this.createProtocolAddress(address_trim);
                            if (addr1 instanceof IIOPAddress) {
                                address = (IIOPAddress)addr1;
                                address.configure(this.configuration);
                            }
                        }
                        ListenEndpoint listen_ep = new ListenEndpoint();
                        listen_ep.setAddress(address);
                        listen_ep.setSSLAddress(ssl_address);
                        listen_ep.setProtocol(protocol);
                        HashSet<ListenEndpoint> s = this.listenEndpointList.get((Object)protocol);
                        if (s == null) {
                            s = new HashSet();
                            this.listenEndpointList.put(protocol, s);
                        }
                        s.add(listen_ep);
                    }
                }
            }
        }
    }
}

