/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.util.Map;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.typecode.TypeCodeWriter;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public abstract class ComplexTypeCodeWriter
implements TypeCodeWriter {
    @Override
    public void writeTypeCode(TypeCode typeCode, CDROutputStream out, Map recursiveTCMap, Map repeatedTCMap) {
        if (out.isIndirectionEnabled() && repeatedTCMap.containsKey(typeCode)) {
            this.writeIndirectionMarker(out, typeCode, repeatedTCMap);
        } else {
            try {
                this.tryWriteTypeCode(typeCode, out, recursiveTCMap, repeatedTCMap);
            }
            catch (BadKind e) {
                assert (false);
                throw new RuntimeException(e);
            }
            catch (Bounds e) {
                assert (false);
                throw new RuntimeException(e);
            }
        }
    }

    private void tryWriteTypeCode(TypeCode typeCode, CDROutputStream out, Map recursiveTCMap, Map repeatedTCMap) throws BadKind, Bounds {
        int kind = typeCode.kind().value();
        out.write_long(kind);
        Integer startPosition = out.get_pos();
        recursiveTCMap.put(typeCode.id(), startPosition);
        out.beginEncapsulation();
        this.doWriteTypeCodeParameters(typeCode, out, recursiveTCMap, repeatedTCMap);
        out.endEncapsulation();
        recursiveTCMap.remove(typeCode.id());
        repeatedTCMap.put(typeCode, startPosition);
    }

    protected abstract void doWriteTypeCodeParameters(TypeCode var1, CDROutputStream var2, Map var3, Map var4) throws BadKind, Bounds;

    private final void writeIndirectionMarker(CDROutputStream out, Object key, Map indirectionTCMap) {
        out.write_long(-1);
        int negative_offset = (Integer)indirectionTCMap.get(key) - out.get_pos() - 4;
        out.write_long(negative_offset);
    }
}

