/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import sun.security.jgss.spi.GSSNameSpi;

public final class GSSUPNameSpi
implements GSSNameSpi {
    private static Oid mechOid;
    private Provider provider;
    private Oid nameTypeOid;
    private InitialContextToken subject = null;

    public GSSUPNameSpi(Provider provider, Oid mechOid, byte[] name, Oid nameTypeOid) {
        this.provider = provider;
        this.nameTypeOid = nameTypeOid;
    }

    public static byte[] encode(ORB orb, Codec codec, String username, String password, byte[] target_name) {
        InitialContextToken subject = null;
        try {
            subject = new InitialContextToken(username.getBytes("UTF-8"), password.getBytes("UTF-8"), target_name);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
        byte[] out = null;
        Any any = orb.create_any();
        InitialContextTokenHelper.insert((Any)any, (InitialContextToken)subject);
        try {
            out = codec.encode_value(any);
        }
        catch (Exception e) {
            return new byte[0];
        }
        byte[] mechOidArray = null;
        try {
            mechOidArray = mechOid.getDER();
        }
        catch (GSSException e) {
            return new byte[0];
        }
        int length = out.length + mechOidArray.length;
        byte[] encodedLength = null;
        encodedLength = length >> 7 == 0 ? new byte[]{96, (byte)length} : (length >> 14 == 0 ? new byte[]{96, (byte)(length >> 7 | 0x80), (byte)(length & 0x7F)} : (length >> 21 == 0 ? new byte[]{96, (byte)(length >> 14 | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)} : (length >> 28 == 0 ? new byte[]{96, (byte)(length >> 21 | 0x80), (byte)(length >> 14 & 0x7F | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)} : new byte[]{96, (byte)(length >> 28 | 0x80), (byte)(length >> 21 & 0x7F | 0x80), (byte)(length >> 14 & 0x7F | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)})));
        byte[] completeContext = new byte[length + encodedLength.length];
        System.arraycopy(encodedLength, 0, completeContext, 0, encodedLength.length);
        System.arraycopy(mechOidArray, 0, completeContext, encodedLength.length, mechOidArray.length);
        System.arraycopy(out, 0, completeContext, encodedLength.length + mechOidArray.length, out.length);
        return completeContext;
    }

    public static byte[] encode(ORB orb, Codec codec, String username, char[] password, String target_name) {
        return GSSUPNameSpi.encode(orb, codec, username, new String(password), target_name.getBytes());
    }

    public static InitialContextToken decode(ORB orb, Codec codec, byte[] gssToken) {
        int index;
        if (gssToken[0] != 96) {
            return null;
        }
        for (index = 1; index < gssToken.length && (gssToken[index] & 0x80) == 1; ++index) {
        }
        if (index == gssToken.length) {
            return null;
        }
        byte[] mechOidArray = null;
        try {
            mechOidArray = mechOid.getDER();
        }
        catch (GSSException e) {
            return null;
        }
        if (++index + mechOidArray.length >= gssToken.length) {
            return null;
        }
        for (int i = 0; i < mechOidArray.length; ++i) {
            if (mechOidArray[i] == gssToken[index + i]) continue;
            return null;
        }
        byte[] icToken = new byte[gssToken.length - (index += mechOidArray.length)];
        System.arraycopy(gssToken, index, icToken, 0, icToken.length);
        try {
            Any any = codec.decode_value(icToken, InitialContextTokenHelper.type());
            return InitialContextTokenHelper.extract((Any)any);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public boolean equals(GSSNameSpi name) throws GSSException {
        return this.subject.equals(((GSSUPNameSpi)name).subject);
    }

    @Override
    public byte[] export() throws GSSException {
        throw new GSSException(11, 11, "Not Implemented");
    }

    @Override
    public Oid getMechanism() {
        return mechOid;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public Oid getStringNameType() {
        return this.nameTypeOid;
    }

    @Override
    public boolean isAnonymousName() {
        System.out.println("GSSUPNameSpi.isAnonymousName");
        return false;
    }

    static {
        try {
            mechOid = new Oid("2.23.130.1.1.1");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

