/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.SASComponentInterceptor;
import org.jacorb.security.sas.ATLASPolicyFactory;
import org.jacorb.security.sas.SASClientInterceptor;
import org.jacorb.security.sas.SASPolicyFactory;
import org.jacorb.security.sas.SASTargetInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    private Logger logger = null;
    public static final int SecurityAttributeService = 15;
    public static int sasPrincipalNamePIC = -1;

    public void post_init(ORBInitInfo info) {
        block16: {
            block15: {
                block14: {
                    ORB orb = ((ORBInitInfoImpl)info).getORB();
                    this.logger = orb.getConfiguration().getLogger("org.jacorb.security.sas.log.verbosity");
                    try {
                        sasPrincipalNamePIC = info.allocate_slot_id();
                        info.add_server_request_interceptor((ServerRequestInterceptor)new SASTargetInterceptor(info));
                    }
                    catch (ConfigurationException ce) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("ConfigurationException", (Throwable)ce);
                        }
                    }
                    catch (DuplicateName duplicateName) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("TSS DuplicateName", (Throwable)duplicateName);
                        }
                    }
                    catch (UnknownEncoding unknownEncoding) {
                        if (!this.logger.isErrorEnabled()) break block14;
                        this.logger.error("TSS UnknownEncoding", (Throwable)unknownEncoding);
                    }
                }
                try {
                    info.add_client_request_interceptor((ClientRequestInterceptor)new SASClientInterceptor(info));
                }
                catch (ConfigurationException ce) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("ConfigurationException", (Throwable)ce);
                    }
                }
                catch (DuplicateName duplicateName) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("CSS DuplicateName", (Throwable)duplicateName);
                    }
                }
                catch (UnknownEncoding unknownEncoding) {
                    if (!this.logger.isErrorEnabled()) break block15;
                    this.logger.error("CSS UnknownEncoding", (Throwable)unknownEncoding);
                }
            }
            try {
                info.add_ior_interceptor((IORInterceptor)new SASComponentInterceptor(info));
            }
            catch (DuplicateName duplicateName) {
                if (!this.logger.isErrorEnabled()) break block16;
                this.logger.error("IOR DuplicateName", (Throwable)duplicateName);
            }
        }
        info.register_policy_factory(102, (PolicyFactory)new SASPolicyFactory());
        info.register_policy_factory(103, (PolicyFactory)new ATLASPolicyFactory());
    }

    public void pre_init(ORBInitInfo info) {
    }
}

