/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ReplyGroup;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.orb.portableInterceptor.ClientInterceptorHandler;
import org.jacorb.util.SelectorManager;
import org.jacorb.util.SelectorRequest;
import org.jacorb.util.SelectorRequestCallback;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ServantObjectExt;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;
import org.slf4j.Logger;

public final class ReplyReceiver
extends ReplyPlaceholder
implements Configurable {
    private final Delegate delegate;
    private final ClientInterceptorHandler interceptors;
    private final ReplyHandler replyHandler;
    private final String operation;
    private final Timer timer;
    private final SelectorTimer selectorTimer;
    private final SelectorRequest timeoutRequest;
    private final SelectorManager selectorManager;
    private UtcT replyEndTime = null;
    private Logger logger;
    private ReplyGroup group;
    private boolean retry_on_failure = false;

    public ReplyReceiver(Delegate delegate, ReplyGroup group, String operation, UtcT replyEndTime, ClientInterceptorHandler interceptors, ReplyHandler replyHandler, SelectorManager selectorManager) {
        this.group = group;
        this.delegate = delegate;
        this.operation = operation;
        this.interceptors = interceptors;
        this.replyHandler = replyHandler;
        this.replyEndTime = replyEndTime;
        this.selectorManager = selectorManager;
        if (replyEndTime != null) {
            if (selectorManager == null) {
                this.selectorTimer = null;
                this.timeoutRequest = null;
                this.timer = new Timer(replyEndTime);
                this.timer.setName("ReplyReceiver Timer");
                this.timer.start();
            } else {
                this.timer = null;
                this.selectorTimer = new SelectorTimer();
                long duration = Time.millisTo(replyEndTime);
                this.timeoutRequest = new SelectorRequest(this.selectorTimer, System.nanoTime() + duration * 1000000L);
                selectorManager.add(this.timeoutRequest);
            }
        } else {
            this.timer = null;
            this.selectorTimer = null;
            this.timeoutRequest = null;
        }
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = configuration.getLogger("org.jacorb.orb.rep_recv");
        this.retry_on_failure = configuration.getAttributeAsBoolean("jacorb.connection.client.retry_on_failure", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyReceived(MessageInputStream in) {
        if (this.timeoutException) {
            return;
        }
        if (this.replyEndTime != null) {
            if (this.selectorTimer != null) {
                this.selectorManager.remove(this.timeoutRequest);
                this.selectorTimer.wakeup();
            } else {
                this.timer.wakeup();
            }
        }
        if (this.group != null) {
            Set<ReplyPlaceholder> pending;
            Set<ReplyPlaceholder> set = pending = this.group.getReplies();
            synchronized (set) {
                java.lang.Object object = this.lock;
                synchronized (object) {
                    if (this.timeoutException) {
                        return;
                    }
                    this.in = in;
                    pending.remove(this);
                    if (this.replyHandler != null) {
                        this.performCallback((ReplyInputStream)in);
                    } else {
                        this.ready = true;
                        this.lock.notifyAll();
                    }
                }
            }
        }
        java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.timeoutException) {
                return;
            }
            this.in = in;
            if (this.replyHandler != null) {
                this.performCallback((ReplyInputStream)in);
            } else {
                this.ready = true;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCallback(ReplyInputStream reply) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)this.replyHandler)._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke((Object)this.replyHandler, this.operation, InvokeHandler.class);
        try {
            switch (reply.getStatus().value()) {
                case 0: {
                    ((InvokeHandler)so.servant)._invoke(this.operation, (org.omg.CORBA.portable.InputStream)reply, (ResponseHandler)new DummyResponseHandler());
                    break;
                }
                case 1: 
                case 2: {
                    ExceptionHolderImpl holder = new ExceptionHolderImpl((ORB)this.delegate.orb(null), reply);
                    org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
                    orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", (ValueFactory)new ExceptionHolderFactory((ORB)orb));
                    CDRInputStream input = new CDRInputStream((org.omg.CORBA.ORB)orb, holder.marshal());
                    ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", (org.omg.CORBA.portable.InputStream)input, (ResponseHandler)new DummyResponseHandler());
                    break;
                }
            }
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).normalCompletion();
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception during callback", (Throwable)e);
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).exceptionalCompletion((Throwable)e);
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke((Object)this.replyHandler, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performExceptionCallback(ExceptionHolderImpl holder) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)this.replyHandler)._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke((Object)this.replyHandler, this.operation, InvokeHandler.class);
        try {
            org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
            orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", (ValueFactory)new ExceptionHolderFactory((ORB)orb));
            CDRInputStream input = new CDRInputStream((org.omg.CORBA.ORB)orb, holder.marshal());
            ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", (org.omg.CORBA.portable.InputStream)input, (ResponseHandler)new DummyResponseHandler());
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).normalCompletion();
            }
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception during callback: " + e.toString());
            }
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).exceptionalCompletion((Throwable)e);
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke((Object)this.replyHandler, so);
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream(this.replyEndTime != null);
            }
            catch (COMM_FAILURE ex) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw ex;
            }
        }
        catch (SystemException se) {
            try {
                this.interceptors.handle_receive_exception(se);
            }
            catch (ForwardRequest fwd) {
                // empty catch block
            }
            throw se;
        }
        catch (RemarshalException re) {
            this.group.waitOnBarrier();
            throw new RemarshalException();
        }
        ReplyInputStream reply = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 status = reply.getStatus();
        switch (status.value()) {
            case 0: {
                try {
                    this.interceptors.handle_receive_reply(reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                return reply;
            }
            case 1: {
                ApplicationException ae = this.getApplicationException(reply);
                try {
                    this.interceptors.handle_receive_exception(ae, reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                throw ae;
            }
            case 2: {
                SystemException se = SystemExceptionHelper.read((org.omg.CORBA.portable.InputStream)reply);
                try {
                    this.interceptors.handle_receive_exception(se, reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                throw se;
            }
            case 3: 
            case 4: {
                Object forward_reference = reply.read_Object();
                try {
                    this.interceptors.handle_location_forward(reply, forward_reference);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                this.doRebind(forward_reference);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + status.value());
    }

    private void checkTimeout() {
        if (this.replyEndTime != null && Time.hasPassed(this.replyEndTime)) {
            throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebind(Object forward_reference) {
        this.group.lockBarrier();
        try {
            this.group.retry();
            this.delegate.rebind(forward_reference);
        }
        finally {
            this.group.openBarrier();
        }
    }

    private ApplicationException getApplicationException(ReplyInputStream reply) {
        reply.mark(0);
        String id = reply.read_string();
        try {
            reply.reset();
        }
        catch (IOException ioe) {
            this.logger.error("unexpected Exception in reset()", (Throwable)ioe);
        }
        return new ApplicationException(id, (org.omg.CORBA.portable.InputStream)reply);
    }

    class SelectorTimer
    extends SelectorRequestCallback {
        private boolean awakened = false;

        SelectorTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean call(SelectorRequest request) {
            if (ReplyReceiver.this.logger.isDebugEnabled()) {
                ReplyReceiver.this.logger.debug("Request callback. Request type: " + request.type.toString() + ", request status: " + request.status.toString());
            }
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                if (request.status == SelectorRequest.Status.EXPIRED) {
                    if (!this.awakened) {
                        ReplyReceiver.this.timeoutException = true;
                        if (ReplyReceiver.this.replyHandler != null) {
                            ExceptionHolderImpl exHolder = new ExceptionHolderImpl((ORB)ReplyReceiver.this.delegate.orb(null), (SystemException)((java.lang.Object)new TIMEOUT()));
                            ReplyReceiver.this.performExceptionCallback(exHolder);
                        }
                    }
                } else {
                    ReplyReceiver.this.communicationException = true;
                }
                ReplyReceiver.this.ready = true;
                ReplyReceiver.this.lock.notifyAll();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeup() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                ReplyReceiver.this.lock.notifyAll();
            }
        }
    }

    private class Timer
    extends Thread {
        private final UtcT endTime;
        private boolean awakened;

        public Timer(UtcT endTime) {
            super("ReplyReceiverTimer");
            this.awakened = false;
            this.endTime = endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    long time = Time.millisTo(this.endTime);
                    if (time > 0L) {
                        try {
                            ReplyReceiver.this.lock.wait(time);
                        }
                        catch (InterruptedException ex) {
                            ReplyReceiver.this.logger.info("Interrupted while waiting for timeout");
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver.this.timeoutException = true;
                        if (ReplyReceiver.this.replyHandler != null) {
                            ExceptionHolderImpl exHolder = new ExceptionHolderImpl((ORB)ReplyReceiver.this.delegate.orb(null), (SystemException)((java.lang.Object)new TIMEOUT()));
                            ReplyReceiver.this.performExceptionCallback(exHolder);
                        }
                        ReplyReceiver.this.ready = true;
                        ReplyReceiver.this.lock.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                ReplyReceiver.this.lock.notifyAll();
            }
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        private final ORB orb;

        public ExceptionHolderFactory(ORB orb) {
            this.orb = orb;
        }

        public Serializable read_value(InputStream is) {
            ExceptionHolderImpl result = new ExceptionHolderImpl(this.orb);
            result._read((org.omg.CORBA.portable.InputStream)is);
            return result;
        }
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        private DummyResponseHandler() {
        }

        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }
    }
}

