/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.jacorb.orb.ORB;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.MARSHAL;

public class CodeSet {
    static final String CODESET_PREFIX = "0x00000000";
    static final CodeSet ISO8859_1_CODESET = new Iso8859_1CodeSet();
    static final CodeSet ISO8859_15_CODESET = new Iso8859_15CodeSet();
    static final CodeSet UTF8_CODESET = new Utf8CodeSet();
    static final CodeSet UTF16_CODESET = new Utf16CodeSet();
    static final CodeSet UCS2_CODESET = new Ucs2CodeSet();
    static final CodeSet MAC_ROMAN_CODESET = new MacRomanCodeSet();
    static final CodeSet[] KNOWN_ENCODINGS = new CodeSet[]{ISO8859_1_CODESET, ISO8859_15_CODESET, UTF16_CODESET, UTF8_CODESET, UCS2_CODESET, MAC_ROMAN_CODESET};
    static final String DEFAULT_PLATFORM_ENCODING;
    static final CodeSet NULL_CODE_SET;
    private int id;
    private String name;

    public static String csName(int cs) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (cs != KNOWN_ENCODINGS[i].getId()) continue;
            return KNOWN_ENCODINGS[i].getName();
        }
        return "Unknown TCS: 0x" + Integer.toHexString(cs);
    }

    public static CodeSet getCodeSet(String name) {
        String ucName = name.toUpperCase();
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeset = KNOWN_ENCODINGS[i];
            if (!codeset.getName().equals(ucName)) continue;
            return codeset;
        }
        try {
            int id = Integer.parseInt(name, 16);
            for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
                CodeSet codeset = KNOWN_ENCODINGS[i];
                if (id != codeset.getId()) continue;
                return codeset;
            }
            return NULL_CODE_SET;
        }
        catch (NumberFormatException ex) {
            return NULL_CODE_SET;
        }
    }

    public static CodeSet getCodeSet(int id) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeset = KNOWN_ENCODINGS[i];
            if (id != codeset.id) continue;
            return codeset;
        }
        return NULL_CODE_SET;
    }

    public static CodeSet getNegotiatedCodeSet(ORB orb, CodeSetComponentInfo serverCodeSetInfo, boolean wide) {
        return CodeSet.getMatchingCodeSet(CodeSet.getSelectedComponent(orb.getLocalCodeSetComponentInfo(), wide), CodeSet.getSelectedComponent(serverCodeSetInfo, wide), wide);
    }

    static CodeSetComponent createCodeSetComponent(boolean wide, CodeSet nativeCodeSet) {
        ArrayList<CodeSet> codeSets = new ArrayList<CodeSet>();
        codeSets.add(nativeCodeSet);
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (!KNOWN_ENCODINGS[i].supportsCharacterData(wide) || codeSets.contains(KNOWN_ENCODINGS[i])) continue;
            codeSets.add(KNOWN_ENCODINGS[i]);
        }
        int nativeSet = ((CodeSet)codeSets.remove(0)).getId();
        int[] conversionSets = new int[codeSets.size()];
        for (int i = 0; i < conversionSets.length; ++i) {
            conversionSets[i] = ((CodeSet)codeSets.get(i)).getId();
        }
        return new CodeSetComponent(nativeSet, conversionSets);
    }

    public static CodeSet getMatchingCodeSet(CodeSetComponent local, CodeSetComponent remote, boolean wide) {
        CodeSet codeSet = CodeSet.getCodeSetIfMatched(local.native_code_set, remote);
        if (codeSet != null) {
            return codeSet;
        }
        for (int i = 0; i < local.conversion_code_sets.length; ++i) {
            codeSet = CodeSet.getCodeSetIfMatched(local.conversion_code_sets[i], remote);
            if (codeSet == null) continue;
            return codeSet;
        }
        return CodeSet.reportNegotiationFailure(local, remote, wide);
    }

    public static CodeSet getCodeSetIfMatched(int localCodeSetId, CodeSetComponent remote) {
        if (localCodeSetId == remote.native_code_set) {
            return CodeSet.getCodeSet(localCodeSetId);
        }
        for (int i = 0; i < remote.conversion_code_sets.length; ++i) {
            if (localCodeSetId != remote.conversion_code_sets[i]) continue;
            return CodeSet.getCodeSet(localCodeSetId);
        }
        return null;
    }

    private static CodeSet reportNegotiationFailure(CodeSetComponent local, CodeSetComponent remote, boolean wide) {
        StringBuffer sb = new StringBuffer("No matching ");
        if (wide) {
            sb.append("wide ");
        }
        sb.append("code set found. Client knows {");
        CodeSet.appendCodeSetList(sb, local);
        sb.append("}. Server offered {");
        CodeSet.appendCodeSetList(sb, remote);
        sb.append('}');
        throw new CODESET_INCOMPATIBLE(sb.toString());
    }

    private static void appendCodeSetList(StringBuffer sb, CodeSetComponent remote) {
        int code_set = remote.native_code_set;
        sb.append(CodeSet.toCodeSetString(code_set));
        for (int i = 0; i < remote.conversion_code_sets.length; ++i) {
            sb.append(',').append(CodeSet.toCodeSetString(remote.conversion_code_sets[i]));
        }
    }

    private static String toCodeSetString(int code_set) {
        String rawString = Integer.toHexString(code_set);
        return CODESET_PREFIX.substring(0, CODESET_PREFIX.length() - rawString.length()) + rawString;
    }

    private static CodeSetComponent getSelectedComponent(CodeSetComponentInfo info, boolean wide) {
        return wide ? info.ForWcharData : info.ForCharData;
    }

    public CodeSet(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean supportsCharacterData(boolean wide) {
        return false;
    }

    public boolean supportsWideCharacterData() {
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean write_bom(boolean configuredForBom) {
        return false;
    }

    public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public String read_wstring(InputBuffer buffer, int lengthIndicator, int giop_minor, boolean littleEndian) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length, int giop_minor) {
        throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.getName());
    }

    public void write_string(OutputBuffer buffer, String s, boolean write_bom, boolean write_length, int giop_minor) {
        for (int i = 0; i < s.length(); ++i) {
            this.write_char(buffer, s.charAt(i), write_bom, write_length, giop_minor);
        }
    }

    public int get_wstring_size(String string, int startPos, int currentPos) {
        return 0;
    }

    final String readGiop12WString(InputBuffer buffer, int size, int giop_minor) {
        char[] buf = new char[size];
        int endPos = buffer.get_pos() + size;
        boolean wchar_litte_endian = buffer.readBOM();
        int i = 0;
        while (buffer.get_pos() < endPos) {
            buf[i++] = this.read_wchar(buffer, giop_minor, wchar_litte_endian);
        }
        return new String(buf, 0, i);
    }

    static {
        NULL_CODE_SET = new CodeSet(-1, "NO SUCH CODESET");
        OutputStreamWriter defaultStream = new OutputStreamWriter(new ByteArrayOutputStream());
        DEFAULT_PLATFORM_ENCODING = defaultStream.getEncoding();
        try {
            defaultStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class Ucs2CodeSet
    extends TwoByteCodeSet {
        private Ucs2CodeSet() {
            super(65792, "UCS2");
        }
    }

    private static class Utf16CodeSet
    extends TwoByteCodeSet {
        private Utf16CodeSet() {
            super(65801, "UTF16");
        }

        @Override
        public boolean write_bom(boolean configuredForBom) {
            return false;
        }
    }

    private static abstract class TwoByteCodeSet
    extends CodeSet {
        TwoByteCodeSet(int id, String name) {
            super(id, name);
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return wide;
        }

        @Override
        public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
            if (littleEndian) {
                return (char)(buffer.readByte() & 0xFF | buffer.readByte() << 8);
            }
            return (char)(buffer.readByte() << 8 | buffer.readByte() & 0xFF);
        }

        @Override
        public String read_wstring(InputBuffer source, int lengthIndicator, int giop_minor, boolean little_endian) {
            if (giop_minor == 2) {
                return this.readGiop12WString(source, lengthIndicator, giop_minor);
            }
            char[] buf = new char[lengthIndicator];
            int endPos = source.get_pos() + 2 * lengthIndicator;
            int i = 0;
            while (source.get_pos() < endPos) {
                buf[i++] = this.read_wchar(source, giop_minor, little_endian);
            }
            if (i != 0 && buf[i - 1] == '\u0000') {
                return new String(buf, 0, i - 1);
            }
            return new String(buf, 0, i);
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            if (giop_minor < 2) {
                buffer.write_short((short)c);
            } else {
                if (write_length_indicator) {
                    buffer.write_byte((byte)2);
                }
                if (write_bom) {
                    buffer.write_byte((byte)-2);
                    buffer.write_byte((byte)-1);
                }
                buffer.write_byte((byte)(c >> 8 & 0xFF));
                buffer.write_byte((byte)(c & 0xFF));
            }
        }

        @Override
        public int get_wstring_size(String s, int startPos, int currentPos) {
            return s.length() + 1;
        }
    }

    private static class Utf8CodeSet
    extends CodeSet {
        private Utf8CodeSet() {
            super(0x5010001, "UTF8");
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return true;
        }

        @Override
        public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
            if (giop_minor < 2) {
                throw new MARSHAL("GIOP 1." + giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
            }
            short value = (short)(0xFF & buffer.readByte());
            if ((value & 0x80) == 0) {
                return (char)value;
            }
            if ((value & 0xE0) == 192) {
                return (char)((value & 0x1F) << 6 | buffer.readByte() & 0x3F);
            }
            short b2 = (short)(0xFF & buffer.readByte());
            return (char)((value & 0xF) << 12 | (b2 & 0x3F) << 6 | buffer.readByte() & 0x3F);
        }

        @Override
        public String read_wstring(InputBuffer source, int lengthIndicator, int giop_minor, boolean little_endian) {
            if (giop_minor < 2) {
                throw new MARSHAL("Bad wide char codeSet: " + this.getName());
            }
            return this.readGiop12WString(source, lengthIndicator, giop_minor);
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            if (c <= '\u007f') {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)1);
                }
                buffer.write_byte((byte)c);
            } else if (c > '\u07ff') {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)3);
                }
                buffer.write_byte((byte)(0xE0 | c >> 12 & 0xF));
                buffer.write_byte((byte)(0x80 | c >> 6 & 0x3F));
                buffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)2);
                }
                buffer.write_byte((byte)(0xC0 | c >> 6 & 0x1F));
                buffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            }
        }

        @Override
        public void write_string(OutputBuffer buffer, String s, boolean write_bom, boolean write_length, int giop_minor) {
            try {
                byte[] bytes = s.getBytes(this.getName());
                buffer.write_octet_array(bytes, 0, bytes.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.getName());
            }
        }

        @Override
        public int get_wstring_size(String s, int startPos, int currentPos) {
            return currentPos - startPos - 4;
        }
    }

    private static class Iso8859_15CodeSet
    extends Iso8859_1CodeSet {
        private Iso8859_15CodeSet() {
            super(65551, "ISO8859_15");
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            switch (c) {
                case '\u20ac': {
                    buffer.write_byte((byte)-92);
                    break;
                }
                case '\u0160': {
                    buffer.write_byte((byte)-90);
                    break;
                }
                case '\u0161': {
                    buffer.write_byte((byte)-88);
                    break;
                }
                case '\u017d': {
                    buffer.write_byte((byte)-76);
                    break;
                }
                case '\u017e': {
                    buffer.write_byte((byte)-72);
                    break;
                }
                case '\u0152': {
                    buffer.write_byte((byte)-68);
                    break;
                }
                case '\u0153': {
                    buffer.write_byte((byte)-67);
                    break;
                }
                case '\u0178': {
                    buffer.write_byte((byte)-66);
                    break;
                }
                default: {
                    super.write_char(buffer, c, write_bom, write_length_indicator, giop_minor);
                }
            }
        }
    }

    private static class MacRomanCodeSet
    extends CodeSet {
        private MacRomanCodeSet() {
            super(65537, "MacRoman");
        }

        MacRomanCodeSet(int i, String name) {
            super(i, name);
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return !wide;
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            buffer.write_byte((byte)c);
        }
    }

    private static class Iso8859_1CodeSet
    extends CodeSet {
        private Iso8859_1CodeSet() {
            super(65537, "ISO8859_1");
        }

        Iso8859_1CodeSet(int i, String name) {
            super(i, name);
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return !wide;
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            buffer.write_byte((byte)c);
        }
    }

    public static interface OutputBuffer {
        public void write_byte(byte var1);

        public void write_short(short var1);

        public void write_octet_array(byte[] var1, int var2, int var3);
    }

    public static interface InputBuffer {
        public byte readByte();

        public int get_pos();

        public boolean readBOM();
    }
}

