package org.japura.util.date;

import java.util.Locale;

/**
 * 
 * <P>
 * Copyright (C) 2011 Carlos Eduardo Leite de Andrade
 * <P>
 * This library is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * <P>
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * <P>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <A
 * HREF="www.gnu.org/licenses/">www.gnu.org/licenses/</A>
 * <P>
 * For more information, contact: <A HREF="www.japura.org">www.japura.org</A>
 * <P>
 * 
 * @author Carlos Eduardo Leite de Andrade
 */
final class LocaleToMask{

  public static DateMask getMask(Locale locale) {
	if (locale == null) {
	  locale = Locale.getDefault();
	}
	String lang = locale.getLanguage();
	String country = locale.getCountry();
	if (lang.equals("hr")) {
	  if (country.equals("")) {
		// Croatian - croata - 2001.02.15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("HR")) {
		// Croatian (Croatia) - croata (Crocia) - 15.02.2001.
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("zh")) {
	  if (country.equals("")) {
		// Chinese - chins - 2001-2-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("TW")) {
		// Chinese (Taiwan) - chins (Taiwan) - 2001/2/15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("SG")) {
		// Chinese (Singapore) - chins (Cingapura) - 15-??-01
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CN")) {
		// Chinese (China) - chins (China) - 2001-2-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("HK")) {
		// Chinese (Hong Kong) - chins (Hong Kong, Regio Admin. Especial da
		// China) - 2001?2?15?
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("ro")) {
	  if (country.equals("")) {
		// Romanian - romeno - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("RO")) {
		// Romanian (Romania) - romeno (Romnia) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("ca")) {
	  if (country.equals("")) {
		// Catalan - catalo - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("ES")) {
		// Catalan (Spain) - catalo (Espanha) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("vi")) {
	  if (country.equals("")) {
		// Vietnamese - vietnamita - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("VN")) {
		// Vietnamese (Vietnam) - vietnamita (Vietn) - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("tr")) {
	  if (country.equals("TR")) {
		// Turkish (Turkey) - turco (Turquia) - 15.?ub.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Turkish - turco - 15.?ub.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("no")) {
	  if (country.equals("NO")) {
		// Norwegian (Norway) - noruegus (Noruega) - 15.feb.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Norwegian - noruegus - 15.feb.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("NO")) {
		// Norwegian (Norway,Nynorsk) - noruegus (Noruega,Nynorsk) -
		// 15.feb.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("hu")) {
	  if (country.equals("")) {
		// Hungarian - hngaro - 2001.02.15.
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("HU")) {
		// Hungarian (Hungary) - hngaro (Hungria) - 2001.02.15.
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("lv")) {
	  if (country.equals("")) {
		// Latvian - leto - 2001.15.2
		return DateMask.YYYYDDMM;
	  }
	  if (country.equals("LV")) {
		// Latvian (Latvia) - leto (Letnia) - 2001.15.2
		return DateMask.YYYYDDMM;
	  }
	} else if (lang.equals("hi")) {
	  if (country.equals("IN")) {
		// Hindi (India) - hindi (ndia) - ?? ??????, ????
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("lt")) {
	  if (country.equals("")) {
		// Lithuanian - lituano - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("LT")) {
		// Lithuanian (Lithuania) - lituano (Litunia) - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("ga")) {
	  if (country.equals("IE")) {
		// Irish (Ireland) - irlands (Irlanda) - 15 Feabh 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Irish - irlands - 2001 Feabh 15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("th")) {
	  if (country.equals("")) {
		// Thai - tailands - 15 ?.?. 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("TH")) {
		// Thai (Thailand) - tailands (Tailndia) - 15 ?.?. 2544
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("TH")) {
		// Thai (Thailand,TH) - tailands (Tailndia,TH) - ?? ?.?. ????
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("de")) {
	  if (country.equals("CH")) {
		// German (Switzerland) - alemo (Sua) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("AT")) {
		// German (Austria) - alemo (ustria) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("DE")) {
		// German (Germany) - alemo (Alemanha) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("LU")) {
		// German (Luxembourg) - alemo (Luxemburgo) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// German - alemo - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("fi")) {
	  if (country.equals("FI")) {
		// Finnish (Finland) - finlands (Finlndia) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Finnish - finlands - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("fr")) {
	  if (country.equals("BE")) {
		// French (Belgium) - francs (Blgica) - 15-fvr.-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CA")) {
		// French (Canada) - francs (Canad) - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("CH")) {
		// French (Switzerland) - francs (Sua) - 15 fvr. 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// French - francs - 15 fvr. 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("LU")) {
		// French (Luxembourg) - francs (Luxemburgo) - 15 fvr. 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("FR")) {
		// French (France) - francs (Frana) - 15 fvr. 2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("sv")) {
	  if (country.equals("")) {
		// Swedish - sueco - 2001-feb-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("SE")) {
		// Swedish (Sweden) - sueco (Sucia) - 2001-feb-15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("bg")) {
	  if (country.equals("")) {
		// Bulgarian - blgaro - 2001-2-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("BG")) {
		// Bulgarian (Bulgaria) - blgaro (Bulgria) - 2001-2-15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("mk")) {
	  if (country.equals("")) {
		// Macedonian - macednio - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("MK")) {
		// Macedonian (Macedonia) - macednio (Macednia) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("be")) {
	  if (country.equals("")) {
		// Belarusian - bielo-russo - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("BY")) {
		// Belarusian (Belarus) - bielo-russo (Belarus) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("sl")) {
	  if (country.equals("SI")) {
		// Slovenian (Slovenia) - eslovnio (Eslovnia) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Slovenian - eslovnio - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("sk")) {
	  if (country.equals("SK")) {
		// Slovak (Slovakia) - eslovaco (Eslovquia) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Slovak - eslovaco - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("da")) {
	  if (country.equals("")) {
		// Danish - dinamarqus - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("DK")) {
		// Danish (Denmark) - dinamarqus (Dinamarca) - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("uk")) {
	  if (country.equals("UA")) {
		// Ukrainian (Ukraine) - ucraniano (Ucrnia) - 15 ??? 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Ukrainian - ucraniano - 15 ??? 2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("is")) {
	  if (country.equals("")) {
		// Icelandic - islands - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IS")) {
		// Icelandic (Iceland) - islands (Islndia) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("it")) {
	  if (country.equals("")) {
		// Italian - italiano - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IT")) {
		// Italian (Italy) - italiano (Itlia) - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CH")) {
		// Italian (Switzerland) - italiano (Sua) - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("mt")) {
	  if (country.equals("MT")) {
		// Maltese (Malta) - malts (Malta) - 15 Fra 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Maltese - malts - 15 Fra 2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("iw")) {
	  if (country.equals("")) {
		// Hebrew - hebraico - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IL")) {
		// Hebrew (Israel) - hebraico (Israel) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("sr")) {
	  if (country.equals("BA")) {
		// Serbian (Bosnia and Herzegovina) - srvio (Bsnia-Herzegovina) -
		// 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("CS")) {
		// Serbian (Serbia and Montenegro) - srvio (Srvia e Montenegro) -
		// 15.02.2001.
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("RS")) {
		// Serbian (Serbia) - srvio (Serbia) - 15.02.2001.
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Serbian - srvio - 15.02.2001.
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("ME")) {
		// Serbian (Montenegro) - srvio (Montenegro) - 15.02.2001.
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("ms")) {
	  if (country.equals("MY")) {
		// Malay (Malaysia) - malaio (Malsia) - 15 Februari 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Malay - malaio - 2001 Feb 15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("sq")) {
	  if (country.equals("AL")) {
		// Albanian (Albania) - albans (Albnia) - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("")) {
		// Albanian - albans - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("ko")) {
	  if (country.equals("")) {
		// Korean - coreano - 2001. 2. 15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("KR")) {
		// Korean (South Korea) - coreano (Coria, Sul) - 2001. 2. 15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("ar")) {
	  if (country.equals("AE")) {
		// Arabic (United Arab Emirates) - rabe (Emirados rabes Unidos) -
		// 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IQ")) {
		// Arabic (Iraq) - rabe (Iraque) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("YE")) {
		// Arabic (Yemen) - rabe (Imen) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("QA")) {
		// Arabic (Qatar) - rabe (Catar) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("SA")) {
		// Arabic (Saudi Arabia) - rabe (Arbia Saudita) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("LB")) {
		// Arabic (Lebanon) - rabe (Lbano) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("KW")) {
		// Arabic (Kuwait) - rabe (Kuwait) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("SD")) {
		// Arabic (Sudan) - rabe (Sudo) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("SY")) {
		// Arabic (Syria) - rabe (Sria) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("BH")) {
		// Arabic (Bahrain) - rabe (Bahrain) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("TN")) {
		// Arabic (Tunisia) - rabe (Tunsia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("JO")) {
		// Arabic (Jordan) - rabe (Jordnia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("EG")) {
		// Arabic (Egypt) - rabe (Egito) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("MA")) {
		// Arabic (Morocco) - rabe (Marrocos) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("DZ")) {
		// Arabic (Algeria) - rabe (Arglia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("LY")) {
		// Arabic (Libya) - rabe (Lbia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Arabic - rabe - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("OM")) {
		// Arabic (Oman) - rabe (Om) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("in")) {
	  if (country.equals("ID")) {
		// Indonesian (Indonesia) - indonsio (Indonsia) - 15 Feb 01
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Indonesian - indonsio - 2001 Feb 15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("cs")) {
	  if (country.equals("")) {
		// Czech - tcheco - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CZ")) {
		// Czech (Czech Republic) - tcheco (Repblica Tcheca) - 15.2.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("el")) {
	  if (country.equals("CY")) {
		// Greek (Cyprus) - grego (Chipre) - 15 ??? 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("GR")) {
		// Greek (Greece) - grego (Grcia) - 15 ??? 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Greek - grego - 15 ??? 2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("pl")) {
	  if (country.equals("PL")) {
		// Polish (Poland) - polons (Polnia) - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("")) {
		// Polish - polons - 2001-02-15
		return DateMask.YYYYMMDD;
	  }
	} else if (lang.equals("pt")) {
	  if (country.equals("PT")) {
		// Portuguese (Portugal) - portugus (Portugal) - 15/Fev/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("BR")) {
		// Portuguese (Brazil) - portugus (Brasil) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Portuguese - portugus - 15/Fev/2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("en")) {
	  if (country.equals("")) {
		// English - ingls - Feb 15, 2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("US")) {
		// English (United States) - ingls (Estados Unidos) - Feb 15, 2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("MT")) {
		// English (Malta) - ingls (Malta) - 15 Feb 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("GB")) {
		// English (United Kingdom) - ingls (Reino Unido) - 15-Feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("NZ")) {
		// English (New Zealand) - ingls (Nova Zelndia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("PH")) {
		// English (Philippines) - ingls (Filipinas) - 02 15, 01
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("ZA")) {
		// English (South Africa) - ingls (frica do Sul) - 15 Feb 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IE")) {
		// English (Ireland) - ingls (Irlanda) - 15-Feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("IN")) {
		// English (India) - ingls (ndia) - 15 Feb, 2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("AU")) {
		// English (Australia) - ingls (Austrlia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CA")) {
		// English (Canada) - ingls (Canad) - 15-Feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("SG")) {
		// English (Singapore) - ingls (Cingapura) - Feb 15, 2001
		return DateMask.MMDDYYYY;
	  }
	} else if (lang.equals("ru")) {
	  if (country.equals("")) {
		// Russian - russo - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("RU")) {
		// Russian (Russia) - russo (Rssia) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("et")) {
	  if (country.equals("EE")) {
		// Estonian (Estonia) - estoniano (Estnia) - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Estonian - estoniano - 15.02.2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("es")) {
	  if (country.equals("PE")) {
		// Spanish (Peru) - espanhol (Peru) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("PA")) {
		// Spanish (Panama) - espanhol (Panam) - 02/15/2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("GT")) {
		// Spanish (Guatemala) - espanhol (Guatemala) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("NI")) {
		// Spanish (Nicaragua) - espanhol (Nicargua) - 02-15-2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("ES")) {
		// Spanish (Spain) - espanhol (Espanha) - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("US")) {
		// Spanish (United States) - espanhol (Estados Unidos) - feb 15, 2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("MX")) {
		// Spanish (Mexico) - espanhol (Mxico) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("UY")) {
		// Spanish (Uruguay) - espanhol (Uruguai) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("DO")) {
		// Spanish (Dominican Republic) - espanhol (Repblica Dominicana) -
		// 02/15/2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("VE")) {
		// Spanish (Venezuela) - espanhol (Venezuela) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("")) {
		// Spanish - espanhol - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("EC")) {
		// Spanish (Ecuador) - espanhol (Equador) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CO")) {
		// Spanish (Colombia) - espanhol (Colmbia) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CR")) {
		// Spanish (Costa Rica) - espanhol (Costa Rica) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("CL")) {
		// Spanish (Chile) - espanhol (Chile) - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("BO")) {
		// Spanish (Bolivia) - espanhol (Bolvia) - 15-02-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("SV")) {
		// Spanish (El Salvador) - espanhol (El Salvador) - 02-15-2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("PY")) {
		// Spanish (Paraguay) - espanhol (Paraguai) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("PR")) {
		// Spanish (Puerto Rico) - espanhol (Porto Rico) - 02-15-2001
		return DateMask.MMDDYYYY;
	  }
	  if (country.equals("AR")) {
		// Spanish (Argentina) - espanhol (Argentina) - 15/02/2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("HN")) {
		// Spanish (Honduras) - espanhol (Honduras) - 02-15-2001
		return DateMask.MMDDYYYY;
	  }
	} else if (lang.equals("nl")) {
	  if (country.equals("")) {
		// Dutch - holands - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("NL")) {
		// Dutch (Netherlands) - holands (Pases Baixos) - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	  if (country.equals("BE")) {
		// Dutch (Belgium) - holands (Blgica) - 15-feb-2001
		return DateMask.DDMMYYYY;
	  }
	} else if (lang.equals("ja")) {
	  if (country.equals("JP")) {
		// Japanese (Japan) - japons (Japo) - 2001/02/15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("JP")) {
		// Japanese (Japan,JP) - japons (Japo,JP) - H13.02.15
		return DateMask.YYYYMMDD;
	  }
	  if (country.equals("")) {
		// Japanese - japons - 2001/02/15
		return DateMask.YYYYMMDD;
	  }
	}
	return null;
  }

}
