/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandExecutor;

public class DoOperationActionListener
extends AbstractAction {
    private CliGuiContext cliGuiCtx;
    private JTextComponent output;
    private JTabbedPane tabs;
    private LinkedList<String> cmdHistory = new LinkedList();

    public DoOperationActionListener(CliGuiContext cliGuiCtx, JTextComponent output, JTabbedPane tabs) {
        this.cliGuiCtx = cliGuiCtx;
        this.output = output;
        this.tabs = tabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = this.cliGuiCtx.getCommandLine().getCmdText().getText();
        try {
            this.cmdHistory.push(command);
            CommandExecutor.Response response = this.cliGuiCtx.getExecutor().doCommandFullResponse(command);
            this.postOutput(response);
        }
        catch (Exception e) {
            try {
                this.postOutput(command, e.getMessage());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        finally {
            this.tabs.setSelectedIndex(1);
        }
    }

    public List getCmdHistory() {
        return Collections.unmodifiableList(this.cmdHistory);
    }

    private void postOutput(CommandExecutor.Response response) throws BadLocationException {
        boolean verbose = this.cliGuiCtx.getCommandLine().isVerbose();
        if (verbose) {
            this.postVerboseOutput(response);
        } else {
            this.postOutput(response.getCommand(), response.getDmrResponse().toString());
        }
    }

    private void postOutput(String command, String response) throws BadLocationException {
        this.processOutput(response + "\n\n", null);
        this.processBoldOutput(command + "\n");
    }

    private void postVerboseOutput(CommandExecutor.Response response) throws BadLocationException {
        this.processOutput(response.getDmrResponse().toString() + "\n\n", null);
        this.processOutput(response.getDmrRequest().toString() + "\n\n", null);
        this.processBoldOutput(response.getCommand() + "\n");
    }

    private void processBoldOutput(String text) throws BadLocationException {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setBold(attribs, true);
        this.processOutput(text, attribs);
    }

    private void processOutput(String text, AttributeSet attribs) throws BadLocationException {
        Document doc = this.output.getDocument();
        doc.insertString(0, text, attribs);
        this.output.setCaretPosition(0);
    }
}

