/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.microprofile.client.CdiConstructorInjector;
import org.jboss.resteasy.microprofile.client.CdiPropertyInjector;
import org.jboss.resteasy.microprofile.client.RestClientExtension;
import org.jboss.resteasy.microprofile.client.logging.LogMessages;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;
import org.jboss.resteasy.spi.metadata.ResourceLocator;

public class CdiInjectorFactory
implements InjectorFactory {
    private final BeanManager manager;
    private final InjectorFactory delegate = new InjectorFactoryImpl();
    private final Map<Class<?>, Type> sessionBeanInterface;

    public CdiInjectorFactory(BeanManager manager) {
        this.manager = manager;
        this.sessionBeanInterface = CdiInjectorFactory.resolveSessionInterfaceBeans(manager);
    }

    public ValueInjector createParameterExtractor(Parameter parameter, ResteasyProviderFactory providerFactory) {
        return this.delegate.createParameterExtractor(parameter, providerFactory);
    }

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return this.delegate.createMethodInjector(method, factory);
    }

    public PropertyInjector createPropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory providerFactory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, providerFactory), resourceClass.getClazz(), this.sessionBeanInterface, this.manager);
    }

    public ConstructorInjector createConstructor(ResourceConstructor constructor, ResteasyProviderFactory providerFactory) {
        Class clazz = constructor.getConstructor().getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        LogMessages.LOGGER.debugf("No CDI bean found for %s. Using default constructor %s.", clazz, constructor);
        return this.delegate.createConstructor(constructor, providerFactory);
    }

    public ConstructorInjector createConstructor(Constructor constructor, ResteasyProviderFactory factory) {
        Class clazz = constructor.getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        LogMessages.LOGGER.debugf("No CDI bean found for %s. Using default constructor %s.", clazz, constructor);
        return this.delegate.createConstructor(constructor, factory);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass, ResteasyProviderFactory factory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, factory), resourceClass, this.sessionBeanInterface, this.manager);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, defaultName, type, genericType, annotations, factory);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, String defaultName, Class type, Type genericType, Annotation[] annotations, boolean useDefault, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, defaultName, type, genericType, annotations, useDefault, factory);
    }

    private ConstructorInjector cdiConstructor(Class<?> clazz) {
        if (!this.manager.getBeans(clazz, new Annotation[0]).isEmpty()) {
            return new CdiConstructorInjector(clazz, this.manager);
        }
        if (this.sessionBeanInterface.containsKey(clazz)) {
            Type intfc = this.sessionBeanInterface.get(clazz);
            LogMessages.LOGGER.debugf("Using %s for lookup of Session Bean %s.", intfc, clazz);
            return new CdiConstructorInjector(intfc, this.manager);
        }
        return null;
    }

    private static Map<Class<?>, Type> resolveSessionInterfaceBeans(BeanManager manager) {
        Set beans = manager.getBeans(RestClientExtension.class, new Annotation[0]);
        Bean bean = manager.resolve(beans);
        if (bean == null) {
            LogMessages.LOGGER.extensionLookupFailed(RestClientExtension.class.getName());
            return Map.of();
        }
        CreationalContext context = manager.createCreationalContext((Contextual)bean);
        return ((RestClientExtension)manager.getReference(bean, RestClientExtension.class, context)).getSessionBeanInterface();
    }
}

