/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

class CdiHelper {
    private static final List<Class<?>> REST_INTERFACES = List.of(ContainerRequestFilter.class, ContainerResponseFilter.class, ContextResolver.class, DynamicFeature.class, ExceptionMapper.class, Feature.class, MessageBodyReader.class, MessageBodyWriter.class, ParamConverterProvider.class, ReaderInterceptor.class, WriterInterceptor.class);

    CdiHelper() {
    }

    static boolean isRestAnnotatedClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Provider.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isRestResource(Class<?> clazz) {
        if (CdiHelper.isRestAnnotatedClass(clazz)) {
            return true;
        }
        for (Class<?> intf : REST_INTERFACES) {
            if (!intf.isAssignableFrom(clazz)) continue;
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!CdiHelper.isRestAnnotatedClass(intf)) continue;
            return true;
        }
        return false;
    }

    static boolean isRestComponent(Class<?> clazz) {
        return clazz.isAnnotationPresent(Provider.class) || CdiHelper.isRestResource(clazz) || Application.class.isAssignableFrom(clazz);
    }
}

