/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.util.SimpleFormat;

public class FreemarkerParseFactory {
    private static final Log logger = LogFactory.getLog(FreemarkerParseFactory.class);
    private static final String ENCODE = "utf-8";
    private static final String MINI_DAO_FORMAT = "DaoFormat";
    private static final Configuration _tplConfig = new Configuration();
    private static final Configuration _sqlConfig = new Configuration();
    private static StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private static final Pattern p = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");

    public static boolean isExistTemplate(String tplName) throws Exception {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, "UTF-8");
            if (mytpl == null) {
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                logger.error((Object)e.getMessage(), e.fillInStackTrace());
                throw new Exception(e);
            }
            logger.debug((Object)("----isExistTemplate----" + e.toString()));
            return false;
        }
        return true;
    }

    public static String parseTemplate(String tplName, Map<String, Object> paras) {
        try {
            logger.debug((Object)(" minidao sql templdate : " + tplName));
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tplName, ENCODE);
            if (paras.containsKey(MINI_DAO_FORMAT)) {
                throw new RuntimeException("DaoFormat \u662f minidao \u4fdd\u7559\u5173\u952e\u5b57\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528 \uff0c\u8bf7\u66f4\u6539\u53c2\u6570\u5b9a\u4e49\uff01");
            }
            paras.put(MINI_DAO_FORMAT, new SimpleFormat());
            mytpl.process(paras, (Writer)swriter);
            String sql = FreemarkerParseFactory.getSqlText(swriter.toString());
            paras.remove(MINI_DAO_FORMAT);
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplName + " }"));
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            if (stringTemplateLoader.findTemplateSource("sql_" + tplContent.hashCode()) == null) {
                stringTemplateLoader.putTemplate("sql_" + tplContent.hashCode(), tplContent);
            }
            Template mytpl = _sqlConfig.getTemplate("sql_" + tplContent.hashCode(), ENCODE);
            if (paras.containsKey(MINI_DAO_FORMAT)) {
                throw new RuntimeException("DaoFormat \u662f minidao \u4fdd\u7559\u5173\u952e\u5b57\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528 \uff0c\u8bf7\u66f4\u6539\u53c2\u6570\u5b9a\u4e49\uff01");
            }
            paras.put(MINI_DAO_FORMAT, new SimpleFormat());
            mytpl.process(paras, (Writer)swriter);
            String sql = FreemarkerParseFactory.getSqlText(swriter.toString());
            paras.remove(MINI_DAO_FORMAT);
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplContent + " }"));
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    private static String getSqlText(String sql) {
        sql = p.matcher(sql).replaceAll("");
        if ((sql = sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim()).endsWith("where") || sql.endsWith("where ")) {
            sql = sql.substring(0, sql.lastIndexOf("where"));
        }
        int index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"where and", (int)index)) != -1) {
            sql = sql.substring(0, index + 5) + sql.substring(index + 9, sql.length());
        }
        index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)", where", (int)index)) != -1) {
            sql = sql.substring(0, index) + sql.substring(index + 1, sql.length());
        }
        if (sql.endsWith(",") || sql.endsWith(", ")) {
            sql = sql.substring(0, sql.lastIndexOf(","));
        }
        return sql;
    }

    static {
        _tplConfig.setClassForTemplateLoading(new FreemarkerParseFactory().getClass(), "/");
        _tplConfig.setNumberFormat("0.#####################");
        _sqlConfig.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        _sqlConfig.setNumberFormat("0.#####################");
        _sqlConfig.setClassicCompatible(true);
    }
}

