/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.function.Consumer;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.LagartoParserConfig;
import jodd.lagarto.dom.DOMBuilder;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMBuilderTagVisitor;
import jodd.lagarto.dom.LagartoDomBuilderConfig;

public class LagartoDOMBuilder
implements DOMBuilder {
    protected final LagartoDomBuilderConfig config;

    public LagartoDOMBuilder() {
        this(new LagartoDomBuilderConfig());
    }

    public LagartoDOMBuilder(LagartoDomBuilderConfig config) {
        this.config = config;
        this.enableHtmlMode();
    }

    public LagartoDomBuilderConfig getConfig() {
        return this.config;
    }

    public LagartoParserConfig getParserConfig() {
        return this.config.parserConfig;
    }

    public LagartoDOMBuilder configure(Consumer<LagartoDomBuilderConfig> configConsumer) {
        configConsumer.accept(this.config);
        return this;
    }

    public LagartoDOMBuilder enableDebug() {
        this.config.collectErrors = true;
        this.config.parserConfig.setCalculatePosition(true);
        return this;
    }

    public LagartoDOMBuilder disableDebug() {
        this.config.collectErrors = false;
        this.config.parserConfig.setCalculatePosition(false);
        return this;
    }

    public LagartoDOMBuilder enableHtmlPlusMode() {
        this.enableHtmlMode();
        this.config.useFosterRules = true;
        this.config.unclosedTagAsOrphanCheck = true;
        return this;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.config.ignoreWhitespacesBetweenTags = false;
        this.config.parserConfig.setCaseSensitive(false);
        this.config.parserConfig.setEnableRawTextModes(true);
        this.config.enabledVoidTags = true;
        this.config.selfCloseVoidTags = false;
        this.config.impliedEndTags = true;
        this.config.parserConfig.setEnableConditionalComments(false);
        this.config.parserConfig.setParseXmlTags(false);
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.config.ignoreWhitespacesBetweenTags = false;
        this.config.parserConfig.setCaseSensitive(true);
        this.config.parserConfig.setEnableRawTextModes(false);
        this.config.enabledVoidTags = true;
        this.config.selfCloseVoidTags = true;
        this.config.impliedEndTags = false;
        this.config.parserConfig.setEnableConditionalComments(false);
        this.config.parserConfig.setParseXmlTags(false);
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.config.ignoreWhitespacesBetweenTags = true;
        this.config.parserConfig.setCaseSensitive(true);
        this.config.parserConfig.setEnableRawTextModes(false);
        this.config.enabledVoidTags = false;
        this.config.selfCloseVoidTags = false;
        this.config.impliedEndTags = false;
        this.config.parserConfig.setEnableConditionalComments(false);
        this.config.parserConfig.setParseXmlTags(true);
        return this;
    }

    @Override
    public Document parse(char[] content) {
        LagartoParser lagartoParser = new LagartoParser(this.config.parserConfig, content);
        return this.parseWithLagarto(lagartoParser);
    }

    @Override
    public Document parse(CharSequence content) {
        LagartoParser lagartoParser = new LagartoParser(this.config.parserConfig, content);
        return this.parseWithLagarto(lagartoParser);
    }

    protected Document parseWithLagarto(LagartoParser lagartoParser) {
        LagartoDOMBuilderTagVisitor domBuilderTagVisitor = new LagartoDOMBuilderTagVisitor(this);
        lagartoParser.parse(domBuilderTagVisitor);
        return domBuilderTagVisitor.getDocument();
    }
}

