/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simplify;

import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.xml.bind.v2.model.core.ID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.simplify.Customizations;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyPlugin
extends AbstractParameterizablePlugin {
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return "Xsimplify";
    }

    public String getUsage() {
        return "This plugin allows simplifying \"complex\" properties (ex. aOrBOrC generated from repeatable choices) into several \"simple\" properties (ex. a, b, c).\n Please visit http://confluence.highsource.org/display/J2B/Simplify+Plugin for plugin documentation.";
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME, Customizations.AS_REFERENCE_PROPERTY_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.GENERATED_ELEMENT_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        for (CClassInfo classInfo : model.beans().values()) {
            this.postProcessClassInfo(model, classInfo);
        }
    }

    private void postProcessClassInfo(final Model model, final CClassInfo classInfo) {
        ArrayList properties = new ArrayList(classInfo.getProperties());
        for (CPropertyInfo property : properties) {
            property.accept((CPropertyVisitor)new CPropertyVisitor<Void>(){

                public Void onElement(CElementPropertyInfo elementProperty) {
                    SimplifyPlugin.this.postProcessElementPropertyInfo(model, classInfo, elementProperty);
                    return null;
                }

                public Void onAttribute(CAttributePropertyInfo attributeProperty) {
                    return null;
                }

                public Void onValue(CValuePropertyInfo valueProperty) {
                    return null;
                }

                public Void onReference(CReferencePropertyInfo p) {
                    SimplifyPlugin.this.postProcessReferencePropertyInfo(model, classInfo, p);
                    return null;
                }
            });
        }
    }

    private void postProcessElementPropertyInfo(Model model, CClassInfo classInfo, CElementPropertyInfo property) {
        if (property.isCollection() && property.getTypes().size() > 1 && CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME)) {
            this.simplifyElementPropertyInfoAsElementPropertyInfo(model, classInfo, property);
        }
    }

    private void postProcessReferencePropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        if (property.isCollection() && property.getElements().size() > 1) {
            if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME)) {
                this.simplifyReferencePropertyInfoAsElementPropertyInfo(model, classInfo, property);
            } else if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.AS_REFERENCE_PROPERTY_ELEMENT_NAME)) {
                this.simplifyReferencePropertyInfoAsReferencePropertyInfo(model, classInfo, property);
            }
        }
    }

    private void simplifyElementPropertyInfoAsElementPropertyInfo(Model model, CClassInfo classInfo, CElementPropertyInfo property) {
        int index = classInfo.getProperties().indexOf(property);
        for (CTypeRef typeRef : property.getTypes()) {
            CElementPropertyInfo elementPropertyInfo = this.createElementPropertyInfo(model, property, typeRef);
            classInfo.getProperties().add(index++, elementPropertyInfo);
        }
        classInfo.getProperties().remove(property);
    }

    private void simplifyReferencePropertyInfoAsReferencePropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        int index = classInfo.getProperties().indexOf(property);
        for (CElement element : property.getElements()) {
            CReferencePropertyInfo referencePropertyInfo = this.createReferencePropertyInfo(model, property, element);
            classInfo.getProperties().add(index++, referencePropertyInfo);
        }
        classInfo.getProperties().remove(property);
    }

    private void simplifyReferencePropertyInfoAsElementPropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        int index = classInfo.getProperties().indexOf(property);
        for (CElement element : property.getElements()) {
            Object elementPropertyInfo = element instanceof CElementInfo ? this.createElementPropertyInfo(model, element, (CElementInfo)element) : (element instanceof CClassInfo ? this.createElementPropertyInfo(model, element, (CClassInfo)element) : (element instanceof CClassRef ? null : null));
            if (elementPropertyInfo == null) continue;
            classInfo.getProperties().add(index++, elementPropertyInfo);
        }
        classInfo.getProperties().remove(property);
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CElement element, CElementInfo elementInfo) {
        String propertyName = this.createPropertyName(model, element);
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT, ID.NONE, null, element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), false);
        elementPropertyInfo.getTypes().add(new CTypeRef(elementInfo.getContentType(), element.getElementName(), elementInfo.getContentType().getTypeName(), false, null));
        return elementPropertyInfo;
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CElement element, CClassInfo classInfo) {
        String propertyName = this.createPropertyName(model, element);
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT, ID.NONE, null, element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), false);
        elementPropertyInfo.getTypes().add(new CTypeRef((CNonElement)classInfo, element.getElementName(), classInfo.getTypeName(), false, null));
        return elementPropertyInfo;
    }

    private CReferencePropertyInfo createReferencePropertyInfo(Model model, CReferencePropertyInfo property, CElement element) {
        String propertyName = this.createPropertyName(model, element);
        CReferencePropertyInfo referencePropertyInfo = new CReferencePropertyInfo(propertyName, true, false, property.isMixed(), element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), property.isDummy(), property.isContent(), property.isMixedExtendedCust());
        referencePropertyInfo.getElements().add(element);
        return referencePropertyInfo;
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CElementPropertyInfo property, CTypeRef typeRef) {
        String propertyName = this.createPropertyName(model, typeRef);
        boolean required = false;
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT, typeRef.getTarget().idUse(), typeRef.getTarget().getExpectedMimeType(), property.getSchemaComponent(), property.getCustomizations(), property.getLocator(), required);
        elementPropertyInfo.getTypes().add(typeRef);
        return elementPropertyInfo;
    }

    private String createPropertyName(Model model, CElement element) {
        String propertyName = model.getNameConverter().toPropertyName(element.getElementName().getLocalPart());
        return propertyName;
    }

    private String createPropertyName(Model model, CTypeRef element) {
        String propertyName = model.getNameConverter().toPropertyName(element.getTagName().getLocalPart());
        return propertyName;
    }
}

