/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.expression;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.jxls.expression.EvaluationException;
import org.jxls.expression.ExpressionEvaluator;

public class JexlExpressionEvaluatorNoThreadLocal
implements ExpressionEvaluator {
    private static final Map<String, JexlExpression> expressionMap = new HashMap<String, JexlExpression>();
    private JexlExpression jexlExpression;
    private JexlContext jexlContext;
    private JexlEngine jexl;

    public JexlExpressionEvaluatorNoThreadLocal() {
        this(true, false);
    }

    public JexlExpressionEvaluatorNoThreadLocal(boolean silent, boolean strict) {
        this.jexl = new JexlBuilder().silent(silent).strict(strict).create();
    }

    public JexlExpressionEvaluatorNoThreadLocal(String expression) {
        this();
        this.jexlExpression = this.jexl.createExpression(expression);
    }

    public JexlExpressionEvaluatorNoThreadLocal(Map<String, Object> context) {
        this();
        this.jexlContext = new MapContext(context);
    }

    public JexlExpressionEvaluatorNoThreadLocal(JexlContext jexlContext) {
        this();
        this.jexlContext = jexlContext;
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> context) {
        MapContext jexlContext = new MapContext(context);
        try {
            JexlExpression jexlExpression = expressionMap.get(expression);
            if (jexlExpression == null) {
                jexlExpression = this.jexl.createExpression(expression);
                expressionMap.put(expression, jexlExpression);
            }
            return jexlExpression.evaluate((JexlContext)jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + expression, e);
        }
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        this.jexlContext = new MapContext(context);
        try {
            return this.jexlExpression.evaluate(this.jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + this.jexlExpression.getSourceText(), e);
        }
    }

    public JexlExpression getJexlExpression() {
        return this.jexlExpression;
    }

    public void setJexlEngine(JexlEngine jexlEngine) {
        this.jexl = jexlEngine;
    }

    public JexlEngine getJexlEngine() {
        return this.jexl;
    }

    @Override
    public String getExpression() {
        return this.jexlExpression == null ? null : this.jexlExpression.getSourceText();
    }
}

