/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.jxls.area.Area;
import org.jxls.command.Command;
import org.jxls.command.EachCommand;
import org.jxls.common.CellRef;
import org.jxls.common.CellRefColPrecedenceComparator;
import org.jxls.common.CellRefRowPrecedenceComparator;
import org.jxls.common.Context;
import org.jxls.common.GroupData;
import org.jxls.common.JxlsException;
import org.jxls.expression.EvaluationException;
import org.jxls.expression.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger logger = LoggerFactory.getLogger(Util.class);
    public static final String regexJointedLookBehind = "(?<!U_\\([^)]{0,100})";
    public static final String regexSimpleCellRef = "[a-zA-Z]+[0-9]+";
    public static final String regexCellRef = "([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)";
    public static final String regexAreaRef = "([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+):[a-zA-Z]+[0-9]+";
    public static final Pattern regexAreaRefPattern = Pattern.compile("([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+):[a-zA-Z]+[0-9]+");
    public static final String regexCellRefExcludingJointed = "(?<!U_\\([^)]{0,100})([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)";
    private static final Pattern regexCellRefExcludingJointedPattern = Pattern.compile("(?<!U_\\([^)]{0,100})([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)");
    private static final Pattern regexCellRefPattern = Pattern.compile("([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)");
    public static final String regexJointedCellRef = "U_\\([^\\)]+\\)";
    private static final Pattern regexJointedCellRefPattern = Pattern.compile("U_\\([^\\)]+\\)");
    public static final String regexExcludePrefixSymbols = "(?<!\\w)";

    public static List<String> getFormulaCellRefs(String formula) {
        return Util.getStringPartsByPattern(formula, regexCellRefExcludingJointedPattern);
    }

    private static List<String> getStringPartsByPattern(String str, Pattern pattern) {
        ArrayList<String> cellRefs = new ArrayList<String>();
        if (str != null) {
            Matcher cellRefMatcher = pattern.matcher(str);
            while (cellRefMatcher.find()) {
                cellRefs.add(cellRefMatcher.group());
            }
        }
        return cellRefs;
    }

    public static List<String> getJointedCellRefs(String formula) {
        return Util.getStringPartsByPattern(formula, regexJointedCellRefPattern);
    }

    public static List<String> getCellRefsFromJointedCellRef(String jointedCellRef) {
        return Util.getStringPartsByPattern(jointedCellRef, regexCellRefPattern);
    }

    public static boolean formulaContainsJointedCellRef(String formula) {
        return regexJointedCellRefPattern.matcher(formula).find();
    }

    public static String createTargetCellRef(List<CellRef> targetCellDataList) {
        if (targetCellDataList == null) {
            return "";
        }
        int size = targetCellDataList.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return targetCellDataList.get(0).getCellName();
        }
        for (int i = 0; i < size - 1; ++i) {
            if (targetCellDataList.get(i).getSheetName().equals(targetCellDataList.get(i + 1).getSheetName())) continue;
            return Util.buildCellRefsString(targetCellDataList);
        }
        CellRef upperLeft = targetCellDataList.get(0);
        CellRef lowerRight = targetCellDataList.get(size - 1);
        int rowCount = lowerRight.getRow() - upperLeft.getRow() + 1;
        int colCount = lowerRight.getCol() - upperLeft.getCol() + 1;
        if (size != colCount * rowCount) {
            return Util.buildCellRefsString(targetCellDataList);
        }
        if (rowCount == 1 || colCount == 1) {
            return upperLeft.getCellName() + ":" + lowerRight.getCellName();
        }
        int minRow = upperLeft.getRow();
        int minCol = upperLeft.getCol();
        int maxRow = minRow;
        int maxCol = minCol;
        for (CellRef cell : targetCellDataList) {
            if (cell.getCol() < minCol) {
                minCol = cell.getCol();
            }
            if (cell.getCol() > maxCol) {
                maxCol = cell.getCol();
            }
            if (cell.getRow() < minRow) {
                minRow = cell.getRow();
            }
            if (cell.getRow() <= maxRow) continue;
            maxRow = cell.getRow();
        }
        if (maxRow != lowerRight.getRow() || minRow != upperLeft.getRow() || maxCol != lowerRight.getCol() || minCol != upperLeft.getCol()) {
            return Util.buildCellRefsString(targetCellDataList);
        }
        return upperLeft.getCellName() + ":" + lowerRight.getCellName();
    }

    private static String buildCellRefsString(List<CellRef> cellRefs) {
        String reply = "";
        for (CellRef cellRef : cellRefs) {
            reply = reply + "," + cellRef.getCellName();
        }
        return reply.substring(1);
    }

    public static String joinStrings(List<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String s : strings) {
            sb.append(sep).append(s);
            sep = separator;
        }
        return sb.toString();
    }

    public static List<List<CellRef>> groupByRanges(List<CellRef> cellRefList, int targetRangeCount) {
        List<List<CellRef>> colRanges = Util.groupByColRange(cellRefList);
        if (targetRangeCount == 0 || colRanges.size() == targetRangeCount) {
            return colRanges;
        }
        List<List<CellRef>> rowRanges = Util.groupByRowRange(cellRefList);
        if (rowRanges.size() == targetRangeCount) {
            return rowRanges;
        }
        return colRanges;
    }

    public static List<List<CellRef>> groupByColRange(List<CellRef> cellRefList) {
        ArrayList<List<CellRef>> rangeList = new ArrayList<List<CellRef>>();
        if (cellRefList == null || cellRefList.size() == 0) {
            return rangeList;
        }
        ArrayList<CellRef> cellRefListCopy = new ArrayList<CellRef>(cellRefList);
        Collections.sort(cellRefListCopy, new CellRefColPrecedenceComparator());
        String sheetName = ((CellRef)cellRefListCopy.get(0)).getSheetName();
        int row = ((CellRef)cellRefListCopy.get(0)).getRow();
        int col = ((CellRef)cellRefListCopy.get(0)).getCol();
        ArrayList currentRange = new ArrayList();
        currentRange.add(cellRefListCopy.get(0));
        boolean rangeComplete = false;
        for (int i = 1; i < cellRefListCopy.size(); ++i) {
            CellRef cellRef = (CellRef)cellRefListCopy.get(i);
            if (!cellRef.getSheetName().equals(sheetName)) {
                rangeComplete = true;
            } else {
                int rowDelta = cellRef.getRow() - row;
                int colDelta = cellRef.getCol() - col;
                if (rowDelta == 1 && colDelta == 0) {
                    currentRange.add(cellRef);
                } else {
                    rangeComplete = true;
                }
            }
            sheetName = cellRef.getSheetName();
            row = cellRef.getRow();
            col = cellRef.getCol();
            if (!rangeComplete) continue;
            rangeList.add(currentRange);
            currentRange = new ArrayList();
            currentRange.add(cellRef);
            rangeComplete = false;
        }
        rangeList.add(currentRange);
        return rangeList;
    }

    public static List<List<CellRef>> groupByRowRange(List<CellRef> cellRefList) {
        ArrayList<List<CellRef>> rangeList = new ArrayList<List<CellRef>>();
        if (cellRefList == null || cellRefList.size() == 0) {
            return rangeList;
        }
        ArrayList<CellRef> cellRefListCopy = new ArrayList<CellRef>(cellRefList);
        Collections.sort(cellRefListCopy, new CellRefRowPrecedenceComparator());
        String sheetName = ((CellRef)cellRefListCopy.get(0)).getSheetName();
        int row = ((CellRef)cellRefListCopy.get(0)).getRow();
        int col = ((CellRef)cellRefListCopy.get(0)).getCol();
        ArrayList currentRange = new ArrayList();
        currentRange.add(cellRefListCopy.get(0));
        boolean rangeComplete = false;
        for (int i = 1; i < cellRefListCopy.size(); ++i) {
            CellRef cellRef = (CellRef)cellRefListCopy.get(i);
            if (!cellRef.getSheetName().equals(sheetName)) {
                rangeComplete = true;
            } else {
                int rowDelta = cellRef.getRow() - row;
                int colDelta = cellRef.getCol() - col;
                if (colDelta == 1 && rowDelta == 0) {
                    currentRange.add(cellRef);
                } else {
                    rangeComplete = true;
                }
            }
            sheetName = cellRef.getSheetName();
            row = cellRef.getRow();
            col = cellRef.getCol();
            if (!rangeComplete) continue;
            rangeList.add(currentRange);
            currentRange = new ArrayList();
            currentRange.add(cellRef);
            rangeComplete = false;
        }
        rangeList.add(currentRange);
        return rangeList;
    }

    public static Boolean isConditionTrue(ExpressionEvaluator evaluator, String condition, Context context) {
        Object conditionResult = evaluator.evaluate(condition, context.toMap());
        if (!(conditionResult instanceof Boolean)) {
            throw new JxlsException("Condition result is not a boolean value - " + condition);
        }
        return (Boolean)conditionResult;
    }

    public static Boolean isConditionTrue(ExpressionEvaluator evaluator, Context context) {
        Object conditionResult = evaluator.evaluate(context.toMap());
        if (!(conditionResult instanceof Boolean)) {
            throw new EvaluationException("Condition result is not a boolean value - " + evaluator.getExpression());
        }
        return (Boolean)conditionResult;
    }

    public static void setObjectProperty(Object obj, String propertyName, String propertyValue, boolean ignoreNonExisting) {
        try {
            Util.setObjectProperty(obj, propertyName, propertyValue);
        }
        catch (Exception e) {
            String msg = "failed to set property '" + propertyName + "' to value '" + propertyValue + "' for object " + obj;
            if (ignoreNonExisting) {
                logger.info(msg, (Throwable)e);
            }
            logger.warn(msg);
            throw new IllegalArgumentException(e);
        }
    }

    public static void setObjectProperty(Object obj, String propertyName, String propertyValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String name = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method method = obj.getClass().getMethod(name, String.class);
        method.invoke(obj, propertyValue);
    }

    public static Object getObjectProperty(Object obj, String propertyName, boolean failSilently) {
        try {
            return Util.getObjectProperty(obj, propertyName);
        }
        catch (Exception e) {
            String msg = "failed to get property '" + propertyName + "' of object " + obj;
            if (failSilently) {
                logger.info(msg, (Throwable)e);
                return null;
            }
            logger.warn(msg);
            throw new IllegalArgumentException(e);
        }
    }

    public static Object getObjectProperty(Object obj, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (obj instanceof Map) {
            return ((Map)obj).get(propertyName);
        }
        return PropertyUtils.getProperty((Object)obj, (String)propertyName);
    }

    public static Collection<GroupData> groupCollection(Collection<?> collection, String groupProperty, String groupOrder) {
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        if (collection == null) {
            return result;
        }
        AbstractSet groupByValues = groupOrder != null ? ("desc".equalsIgnoreCase(groupOrder) ? new TreeSet(Collections.reverseOrder()) : new TreeSet()) : new LinkedHashSet();
        for (Object bean : collection) {
            groupByValues.add(Util.getGroupKey(bean, groupProperty));
        }
        for (Object groupValue : groupByValues) {
            ArrayList<Object> groupItems = new ArrayList<Object>();
            for (Object bean : collection) {
                if (!groupValue.equals(Util.getGroupKey(bean, groupProperty))) continue;
                groupItems.add(bean);
            }
            if (groupItems.isEmpty()) continue;
            result.add(new GroupData(groupItems.get(0), groupItems));
        }
        return result;
    }

    public static Collection<GroupData> groupIterable(Iterable<?> iterable, String groupProperty, String groupOrder) {
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        if (iterable == null) {
            return result;
        }
        AbstractSet groupByValues = groupOrder != null ? ("desc".equalsIgnoreCase(groupOrder) ? new TreeSet(Collections.reverseOrder()) : new TreeSet()) : new LinkedHashSet();
        for (Object bean : iterable) {
            groupByValues.add(Util.getGroupKey(bean, groupProperty));
        }
        for (Object groupValue : groupByValues) {
            ArrayList<Object> groupItems = new ArrayList<Object>();
            for (Object bean : iterable) {
                if (!groupValue.equals(Util.getGroupKey(bean, groupProperty))) continue;
                groupItems.add(bean);
            }
            if (groupItems.isEmpty()) continue;
            result.add(new GroupData(groupItems.get(0), groupItems));
        }
        return result;
    }

    private static Object getGroupKey(Object bean, String propertyName) {
        Object ret = Util.getObjectProperty(bean, propertyName, true);
        return ret == null ? "null" : ret;
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = stream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static Collection<?> transformToCollectionObject(ExpressionEvaluator expressionEvaluator, String collectionName, Context context) {
        Object collectionObject = expressionEvaluator.evaluate(collectionName, context.toMap());
        if (!(collectionObject instanceof Collection)) {
            throw new JxlsException(collectionName + " expression is not a collection");
        }
        return (Collection)collectionObject;
    }

    public static String sheetNameRegex(Map.Entry<CellRef, List<CellRef>> cellRefEntry) {
        return cellRefEntry.getKey().isIgnoreSheetNameInFormat() ? "(?<!!)" : "";
    }

    public static List<CellRef> createTargetCellRefListByColumn(CellRef targetFormulaCellRef, List<CellRef> targetCells, List<CellRef> cellRefsToExclude) {
        ArrayList<CellRef> resultCellList = new ArrayList<CellRef>();
        int col = targetFormulaCellRef.getCol();
        for (CellRef targetCell : targetCells) {
            if (targetCell.getCol() != col || targetCell.getRow() >= targetFormulaCellRef.getRow() || cellRefsToExclude.contains(targetCell)) continue;
            resultCellList.add(targetCell);
        }
        return resultCellList;
    }

    public static int countOccurences(String str, char ch) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static Iterable<Object> transformToIterableObject(ExpressionEvaluator expressionEvaluator, String collectionName, Context context) {
        List<Object> collectionObject = expressionEvaluator.evaluate(collectionName, context.toMap());
        if (collectionObject == null) {
            return Collections.emptyList();
        }
        if (collectionObject instanceof Object[]) {
            collectionObject = Arrays.asList((Object[])collectionObject);
        } else if (!(collectionObject instanceof Iterable)) {
            throw new JxlsException(collectionName + " expression is not a collection or an array");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object i : (Iterable)collectionObject) {
            ret.add(i);
        }
        return ret;
    }

    public static String getStrictCellNameRegex(String name) {
        return "(?<=[^A-Z]|^)" + name + "(?=\\D|$)";
    }

    static List<String> getSheetsNameOfMultiSheetTemplate(List<Area> areaList) {
        ArrayList<String> templateSheetsName = new ArrayList<String>();
        block0: for (Area xlsArea : areaList) {
            for (Command command : xlsArea.findCommandByName("each")) {
                boolean isAreaHasMultiSheetAttribute = ((EachCommand)command).getMultisheet() != null && !((EachCommand)command).getMultisheet().isEmpty();
                if (!isAreaHasMultiSheetAttribute) continue;
                templateSheetsName.add(xlsArea.getAreaRef().getSheetName());
                continue block0;
            }
        }
        return templateSheetsName;
    }
}

