/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;

public class DefaultAttributes
extends HashMap<String, List<String>>
implements Attributes {
    private static Logger logger = Logger.getLogger(DefaultAttributes.class);
    public static final String READ_ONLY_ATTRIBUTE_KEY = "kc.read.only";
    protected final UserProfileContext context;
    protected final KeycloakSession session;
    private final Map<String, AttributeMetadata> metadataByAttribute;
    protected final UserModel user;

    public DefaultAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata profileMetadata, KeycloakSession session) {
        this.context = context;
        this.user = user;
        this.session = session;
        this.metadataByAttribute = this.configureMetadata(profileMetadata.getAttributes());
        this.putAll(Collections.unmodifiableMap(this.normalizeAttributes(attributes)));
    }

    public boolean isReadOnly(String attributeName) {
        if ("username".equals(attributeName) && this.isServiceAccountUser()) {
            return true;
        }
        if ("email".equals(attributeName) && this.isServiceAccountUser()) {
            return false;
        }
        if (this.isReadOnlyFromMetadata(attributeName) || this.isReadOnlyInternalAttribute(attributeName)) {
            return true;
        }
        return this.getMetadata(attributeName) == null;
    }

    protected boolean isReadOnlyFromMetadata(String attributeName) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(attributeName);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isReadOnly(this.createAttributeContext(attributeMetadata));
    }

    public boolean isRequired(String name) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(name);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isRequired(this.createAttributeContext(attributeMetadata));
    }

    public boolean validate(String name, Consumer<ValidationError> ... listeners) {
        AbstractMap.SimpleImmutableEntry<String, List<String>> attribute = this.createAttribute(name);
        ArrayList metadatas = new ArrayList();
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(attribute.getKey())).map(Collections::singletonList).orElse(Collections.emptyList()));
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY)).map(Collections::singletonList).orElse(Collections.emptyList()));
        Boolean result = null;
        for (AttributeMetadata metadata : metadatas) {
            AttributeContext attributeContext = this.createAttributeContext(attribute, metadata);
            for (AttributeValidatorMetadata validator : metadata.getValidators()) {
                ValidationContext vc = validator.validate(attributeContext);
                if (vc.isValid()) continue;
                if (this.user != null && metadata.isReadOnly(attributeContext) && CollectionUtil.collectionEquals((Collection)this.user.getAttributeStream(name).collect(Collectors.toList()), (Collection)((Collection)attribute.getValue()))) {
                    logger.warnf("User '%s' attribute '%s' has previous validation errors %s but is read-only in context %s.", new Object[]{this.user.getUsername(), name, vc.getErrors(), attributeContext.getContext()});
                    continue;
                }
                if (result == null) {
                    result = false;
                }
                if (listeners == null) continue;
                for (ValidationError error : vc.getErrors()) {
                    for (Consumer<ValidationError> consumer : listeners) {
                        consumer.accept(error);
                    }
                }
            }
        }
        return result == null;
    }

    public List<String> getValues(String name) {
        return this.getOrDefault(name, EMPTY_VALUE);
    }

    public boolean contains(String name) {
        return this.containsKey(name);
    }

    public Set<String> nameSet() {
        return this.keySet();
    }

    public Map<String, List<String>> getWritable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this);
        for (String name : this.nameSet()) {
            AttributeMetadata metadata = this.getMetadata(name);
            RealmModel realm = this.session.getContext().getRealm();
            if ("username".equals(name) && realm.isRegistrationEmailAsUsername() || metadata != null && metadata.canEdit(this.createAttributeContext(metadata))) continue;
            attributes.remove(name);
        }
        return attributes;
    }

    public AttributeMetadata getMetadata(String name) {
        AttributeMetadata metadata = this.metadataByAttribute.get(name);
        if (metadata == null) {
            return null;
        }
        return metadata.clone();
    }

    public Map<String, List<String>> getReadable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this);
        for (String name : this.nameSet()) {
            AttributeMetadata metadata = this.getMetadata(name);
            if (metadata != null && metadata.canView(this.createAttributeContext(metadata))) continue;
            attributes.remove(name);
        }
        return attributes;
    }

    public Map<String, List<String>> toMap() {
        return this;
    }

    protected boolean isServiceAccountUser() {
        return this.user != null && this.user.getServiceAccountClientLink() != null;
    }

    private AttributeContext createAttributeContext(Map.Entry<String, List<String>> attribute, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, attribute, this.user, metadata, (Attributes)this);
    }

    private AttributeContext createAttributeContext(String attributeName, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, this.createAttribute(attributeName), this.user, metadata, (Attributes)this);
    }

    protected AttributeContext createAttributeContext(AttributeMetadata metadata) {
        return this.createAttributeContext(this.createAttribute(metadata.getName()), metadata);
    }

    private Map<String, AttributeMetadata> configureMetadata(List<AttributeMetadata> attributes) {
        HashMap<String, AttributeMetadata> metadatas = new HashMap<String, AttributeMetadata>();
        for (AttributeMetadata metadata : attributes) {
            if (!metadata.isSelected(this.createAttributeContext(metadata))) continue;
            metadatas.put(metadata.getName(), metadata);
        }
        return metadatas;
    }

    private AbstractMap.SimpleImmutableEntry<String, List<String>> createAttribute(final String name) {
        return new AbstractMap.SimpleImmutableEntry<String, List<String>>(name, null){

            @Override
            public List<String> getValue() {
                List values = (List)DefaultAttributes.this.get(name);
                if (values == null) {
                    return Attributes.EMPTY_VALUE;
                }
                return values;
            }
        };
    }

    private Map<String, List<String>> normalizeAttributes(Map<String, ?> attributes) {
        List email;
        List username;
        HashMap<String, List<String>> newAttributes = new HashMap<String, List<String>>();
        RealmModel realm = this.session.getContext().getRealm();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (!this.isSupportedAttribute(key)) continue;
                if (key.startsWith("user.attributes.")) {
                    key = key.substring("user.attributes.".length());
                }
                List<String> values = (value = entry.getValue()) instanceof String ? Collections.singletonList((String)value) : (List<String>)value;
                newAttributes.put(key, Collections.unmodifiableList(values));
            }
        }
        for (String string : this.metadataByAttribute.keySet()) {
            if (!this.isSupportedAttribute(string) || newAttributes.containsKey(string)) continue;
            List values = EMPTY_VALUE;
            AttributeMetadata metadata = this.metadataByAttribute.get(string);
            if (this.user != null && this.isIncludeAttributeIfNotProvided(metadata)) {
                values = this.user.getAttributes().getOrDefault(string, EMPTY_VALUE);
            }
            newAttributes.put(string, values);
        }
        if (this.user != null && (username = newAttributes.getOrDefault("username", Collections.emptyList())).isEmpty() && this.isReadOnly("username")) {
            this.setUserName(newAttributes, Collections.singletonList(this.user.getUsername()));
        }
        if (!(email = newAttributes.getOrDefault("email", Collections.emptyList())).isEmpty() && realm.isRegistrationEmailAsUsername()) {
            List<String> list = email.stream().filter(Objects::nonNull).map(String::toLowerCase).collect(Collectors.toList());
            this.setUserName(newAttributes, list);
            if (this.user != null && this.isReadOnly("email")) {
                newAttributes.put("email", Collections.singletonList(this.user.getEmail()));
                this.setUserName(newAttributes, Collections.singletonList(this.user.getEmail()));
            }
        }
        return newAttributes;
    }

    private void setUserName(Map<String, List<String>> newAttributes, List<String> lowerCaseEmailList) {
        if (this.isServiceAccountUser()) {
            return;
        }
        newAttributes.put("username", lowerCaseEmailList);
    }

    protected boolean isIncludeAttributeIfNotProvided(AttributeMetadata metadata) {
        return !metadata.canEdit(this.createAttributeContext(metadata));
    }

    protected boolean isSupportedAttribute(String name) {
        if (READ_ONLY_ATTRIBUTE_KEY.equals(name)) {
            return false;
        }
        if (this.metadataByAttribute.containsKey(name)) {
            return true;
        }
        if (this.isServiceAccountUser()) {
            return true;
        }
        if (this.isReadOnlyInternalAttribute(name)) {
            return true;
        }
        return this.isRootAttribute(name);
    }

    protected boolean isReadOnlyInternalAttribute(String attributeName) {
        AttributeMetadata readonlyMetadata = this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY);
        if (readonlyMetadata == null) {
            return false;
        }
        AttributeContext attributeContext = this.createAttributeContext(attributeName, readonlyMetadata);
        for (AttributeValidatorMetadata validator : readonlyMetadata.getValidators()) {
            ValidationContext vc = validator.validate(attributeContext);
            if (vc.isValid()) continue;
            return true;
        }
        return false;
    }
}

