/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.poloniex.PoloniexAdapters;
import org.knowm.xchange.poloniex.PoloniexException;
import org.knowm.xchange.poloniex.dto.LoanInfo;
import org.knowm.xchange.poloniex.dto.account.PoloniexBalance;
import org.knowm.xchange.poloniex.dto.account.PoloniexLoan;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDepositsWithdrawalsResponse;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class PoloniexAccountServiceRaw
extends PoloniexBaseService {
    public PoloniexAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<Balance> getExchangeWallet() throws IOException {
        try {
            HashMap<String, PoloniexBalance> response = this.poloniexAuthenticated.returnCompleteBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), null);
            return PoloniexAdapters.adaptPoloniexBalances(response);
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public List<Balance> getWallets() throws IOException {
        try {
            HashMap<String, PoloniexBalance> response = this.poloniexAuthenticated.returnCompleteBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), "all");
            return PoloniexAdapters.adaptPoloniexBalances(response);
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public LoanInfo getLoanInfo() throws IOException {
        try {
            HashMap<String, PoloniexLoan[]> response = this.poloniexAuthenticated.returnActiveLoans(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            return PoloniexAdapters.adaptPoloniexLoans(response);
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public String getDepositAddress(String currency) throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.returnDepositAddresses(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.containsKey("error")) {
            throw new ExchangeException(response.get("error"));
        }
        if (response.containsKey(currency)) {
            return response.get(currency);
        }
        throw new ExchangeException("Poloniex did not return a deposit address for " + currency);
    }

    public String withdraw(Currency currency, BigDecimal amount, String address, @Nullable String paymentId) throws IOException {
        return this.poloniexAuthenticated.withdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency.getCurrencyCode(), amount, address, paymentId).getResponse();
    }

    public PoloniexDepositsWithdrawalsResponse returnDepositsWithdrawals(Date start, Date end) throws IOException {
        return this.poloniexAuthenticated.returnDepositsWithdrawals(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), DateUtils.toUnixTimeNullSafe((Date)start), DateUtils.toUnixTimeNullSafe((Date)end));
    }
}

