/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.poloniex.PoloniexException;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexChartData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexCurrencyInfo;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexDepth;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexMarketData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexPublicTrade;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexTicker;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import org.knowm.xchange.poloniex.service.PoloniexChartDataPeriodType;

public class PoloniexMarketDataServiceRaw
extends PoloniexBaseService {
    private HashMap<String, PoloniexMarketData> TickermarketData;
    private final long cache_delay = 1000L;
    private long next_refresh = System.currentTimeMillis() + 1000L;

    public PoloniexMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, PoloniexCurrencyInfo> getPoloniexCurrencyInfo() throws IOException {
        String command = "returnCurrencies";
        try {
            HashMap<String, PoloniexCurrencyInfo> currencyInfo = this.poloniex.getCurrencyInfo(command);
            return currencyInfo;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public Map<String, PoloniexMarketData> getAllPoloniexTickers() throws IOException {
        String command = "returnTicker";
        try {
            HashMap<String, PoloniexMarketData> marketData = this.poloniex.getTicker(command);
            return marketData;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexTicker getPoloniexTicker(CurrencyPair currencyPair) throws IOException {
        PoloniexMarketData data;
        String command = "returnTicker";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        long now = System.currentTimeMillis();
        if (this.TickermarketData == null || this.next_refresh < now) {
            try {
                this.TickermarketData = this.poloniex.getTicker(command);
            }
            catch (PoloniexException e) {
                throw new ExchangeException(e.getError(), (Throwable)((Object)e));
            }
            finally {
                this.next_refresh = now + 1000L;
            }
        }
        if ((data = this.TickermarketData.get(pairString)) == null) {
            throw new ExchangeException(currencyPair + " not available");
        }
        return new PoloniexTicker(data, currencyPair);
    }

    public PoloniexDepth getPoloniexDepth(CurrencyPair currencyPair) throws IOException {
        String command = "returnOrderBook";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        try {
            PoloniexDepth depth = this.poloniex.getOrderBook(command, pairString);
            return depth;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexDepth getPoloniexDepth(CurrencyPair currencyPair, int depth) throws IOException {
        String command = "returnOrderBook";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        try {
            PoloniexDepth limitDepth = this.poloniex.getOrderBook(command, pairString, depth);
            return limitDepth;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public Map<String, PoloniexDepth> getAllPoloniexDepths() throws IOException {
        String command = "returnOrderBook";
        try {
            Map<String, PoloniexDepth> depths = this.poloniex.getAllOrderBooks(command, "all", null);
            return depths;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public Map<String, PoloniexDepth> getAllPoloniexDepths(int depth) throws IOException {
        String command = "returnOrderBook";
        try {
            Map<String, PoloniexDepth> depths = this.poloniex.getAllOrderBooks(command, "all", depth);
            return depths;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexPublicTrade[] getPoloniexPublicTrades(CurrencyPair currencyPair) throws IOException {
        String command = "returnTradeHistory";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        try {
            PoloniexPublicTrade[] trades = this.poloniex.getTrades(command, pairString, null, null);
            return trades;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexPublicTrade[] getPoloniexPublicTrades(CurrencyPair currencyPair, Long startTime, Long endTime) throws IOException {
        String command = "returnTradeHistory";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        try {
            PoloniexPublicTrade[] trades = this.poloniex.getTrades(command, pairString, startTime, endTime);
            return trades;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexChartData[] getPoloniexChartData(CurrencyPair currencyPair, Long startTime, Long endTime, PoloniexChartDataPeriodType period) throws IOException {
        String command = "returnChartData";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        try {
            PoloniexChartData[] chartData = this.poloniex.getChartData(command, pairString, startTime, endTime, period.getPeriod());
            return chartData;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }
}

