/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.poloniex.PoloniexAdapters;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.trade.PoloniexLimitOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexTradeResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.service.PoloniexTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsAll;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class PoloniexTradeService
extends PoloniexTradeServiceRaw
implements TradeService {
    public PoloniexTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, IOException {
        Map<String, PoloniexOpenOrder[]> poloniexOpenOrders;
        CurrencyPair currencyPair = null;
        if (params instanceof OpenOrdersParamCurrencyPair) {
            currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        }
        if (currencyPair == null) {
            poloniexOpenOrders = this.returnOpenOrders();
        } else {
            PoloniexOpenOrder[] cpOpenOrders = this.returnOpenOrders(currencyPair);
            poloniexOpenOrders = new HashMap<String, PoloniexOpenOrder[]>(1);
            poloniexOpenOrders.put(PoloniexUtils.toPairString(currencyPair), cpOpenOrders);
        }
        return PoloniexAdapters.adaptPoloniexOpenOrders(poloniexOpenOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        PoloniexTradeResponse response = limitOrder.getType() == Order.OrderType.BID || limitOrder.getType() == Order.OrderType.EXIT_ASK ? this.buy(limitOrder) : this.sell(limitOrder);
        if (limitOrder instanceof PoloniexLimitOrder) {
            PoloniexLimitOrder raw = (PoloniexLimitOrder)limitOrder;
            raw.setResponse(response);
        }
        return response.getOrderNumber().toString();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancel(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        CurrencyPair currencyPair = null;
        Date startTime = null;
        Date endTime = null;
        if (params instanceof TradeHistoryParamCurrencyPair) {
            currencyPair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime();
            endTime = ((TradeHistoryParamsTimeSpan)params).getEndTime();
        }
        return this.getTradeHistory(currencyPair, DateUtils.toUnixTimeNullSafe((Date)startTime), DateUtils.toUnixTimeNullSafe(endTime));
    }

    public BigDecimal getMakerFee() throws IOException {
        String value = this.getFeeInfo().get("makerFee");
        return new BigDecimal(value);
    }

    public BigDecimal getTakerFee() throws IOException {
        String value = this.getFeeInfo().get("takerFee");
        return new BigDecimal(value);
    }

    private UserTrades getTradeHistory(CurrencyPair currencyPair, Long startTime, Long endTime) throws IOException {
        ArrayList<UserTrade> trades;
        block5: {
            block4: {
                trades = new ArrayList<UserTrade>();
                if (currencyPair != null) break block4;
                HashMap<String, PoloniexUserTrade[]> poloniexUserTrades = this.returnTradeHistory(startTime, endTime);
                if (poloniexUserTrades == null) break block5;
                for (Map.Entry<String, PoloniexUserTrade[]> mapEntry : poloniexUserTrades.entrySet()) {
                    currencyPair = PoloniexUtils.toCurrencyPair(mapEntry.getKey());
                    for (PoloniexUserTrade poloniexUserTrade : mapEntry.getValue()) {
                        trades.add(PoloniexAdapters.adaptPoloniexUserTrade(poloniexUserTrade, currencyPair));
                    }
                }
                break block5;
            }
            PoloniexUserTrade[] poloniexUserTrades = this.returnTradeHistory(currencyPair, startTime, endTime);
            if (poloniexUserTrades != null) {
                for (PoloniexUserTrade poloniexUserTrade : poloniexUserTrades) {
                    trades.add(PoloniexAdapters.adaptPoloniexUserTrade(poloniexUserTrade, currencyPair));
                }
            }
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new PoloniexTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public static class PoloniexTradeHistoryParams
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamsTimeSpan {
        private final TradeHistoryParamsAll all = new TradeHistoryParamsAll();

        public void setCurrencyPair(CurrencyPair value) {
            this.all.setCurrencyPair(value);
        }

        public CurrencyPair getCurrencyPair() {
            return this.all.getCurrencyPair();
        }

        public void setStartTime(Date value) {
            this.all.setStartTime(value);
        }

        public Date getStartTime() {
            return this.all.getStartTime();
        }

        public void setEndTime(Date value) {
            this.all.setEndTime(value);
        }

        public Date getEndTime() {
            return this.all.getEndTime();
        }
    }
}

