/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.math.BigInteger;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class BigIntegerToPrimitiveConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigIntegerToPrimitiveConversion(Class<?> targetType) {
        if (!targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no primitive type.");
        }
        this.targetType = targetType;
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        return "<SOURCE>." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        String castString = "";
        if (this.targetType == Float.TYPE || this.targetType == Double.TYPE) {
            castString = "(long) ";
        }
        return "BigInteger.valueOf( " + castString + "<SOURCE> )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(BigInteger.class));
    }
}

