/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.LifecycleCallbackFactory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.source.EnumMapping;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class EnumMappingMethod
extends MappingMethod {
    private final List<EnumMapping> enumMappings;

    private EnumMappingMethod(Method method, List<EnumMapping> enumMappings, List<LifecycleCallbackMethodReference> beforeMappingMethods, List<LifecycleCallbackMethodReference> afterMappingMethods) {
        super(method, beforeMappingMethods, afterMappingMethods);
        this.enumMappings = enumMappings;
    }

    public List<EnumMapping> getEnumMappings() {
        return this.enumMappings;
    }

    public Parameter getSourceParameter() {
        return Collections.first(this.getParameters());
    }

    public static class Builder {
        private SourceMethod method;
        private MappingBuilderContext ctx;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public EnumMappingMethod build() {
            if (!this.reportErrorIfMappedEnumConstantsDontExist(this.method) || !this.reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(this.method)) {
                return null;
            }
            ArrayList<EnumMapping> enumMappings = new ArrayList<EnumMapping>();
            List<String> sourceEnumConstants = Collections.first(this.method.getSourceParameters()).getType().getEnumConstants();
            for (String enumConstant : sourceEnumConstants) {
                List<Mapping> mappedConstants = this.method.getMappingBySourcePropertyName(enumConstant);
                if (mappedConstants.isEmpty()) {
                    enumMappings.add(new EnumMapping(enumConstant, enumConstant));
                    continue;
                }
                if (mappedConstants.size() == 1) {
                    enumMappings.add(new EnumMapping(enumConstant, Collections.first(mappedConstants).getTargetName()));
                    continue;
                }
                ArrayList<String> targetConstants = new ArrayList<String>(mappedConstants.size());
                for (Mapping mapping : mappedConstants) {
                    targetConstants.add(mapping.getTargetName());
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.ENUMMAPPING_MULTIPLE_SOURCES, enumConstant, Strings.join(targetConstants, ", "));
            }
            SelectionParameters selectionParameters = Builder.getSelecionParameters(this.method);
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleCallbackFactory.beforeMappingMethods(this.method, selectionParameters, this.ctx);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleCallbackFactory.afterMappingMethods(this.method, selectionParameters, this.ctx);
            return new EnumMappingMethod(this.method, enumMappings, beforeMappingMethods, afterMappingMethods);
        }

        private static SelectionParameters getSelecionParameters(SourceMethod method) {
            BeanMappingPrism beanMappingPrism = BeanMappingPrism.getInstanceOn(method.getExecutable());
            if (beanMappingPrism != null) {
                List<TypeMirror> qualifiers = beanMappingPrism.qualifiedBy();
                List<String> qualifyingNames = beanMappingPrism.qualifiedByName();
                TypeMirror resultType = beanMappingPrism.resultType();
                return new SelectionParameters(qualifiers, qualifyingNames, resultType);
            }
            return null;
        }

        private boolean reportErrorIfMappedEnumConstantsDontExist(SourceMethod method) {
            List<String> sourceEnumConstants = Collections.first(method.getSourceParameters()).getType().getEnumConstants();
            List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
            boolean foundIncorrectMapping = false;
            for (List<Mapping> mappedConstants : method.getMappingOptions().getMappings().values()) {
                for (Mapping mappedConstant : mappedConstants) {
                    if (mappedConstant.getSourceName() == null) {
                        this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), Message.ENUMMAPPING_UNDEFINED_SOURCE, new Object[0]);
                        foundIncorrectMapping = true;
                    } else if (!sourceEnumConstants.contains(mappedConstant.getSourceName())) {
                        this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue(), Message.ENUMMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getSourceName(), Collections.first(method.getSourceParameters()).getType());
                        foundIncorrectMapping = true;
                    }
                    if (mappedConstant.getTargetName() == null) {
                        this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), Message.ENUMMAPPING_UNDEFINED_TARGET, new Object[0]);
                        foundIncorrectMapping = true;
                        continue;
                    }
                    if (targetEnumConstants.contains(mappedConstant.getTargetName())) continue;
                    this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue(), Message.ENUMMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getTargetName(), method.getReturnType());
                    foundIncorrectMapping = true;
                }
            }
            return !foundIncorrectMapping;
        }

        private boolean reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(SourceMethod method) {
            List<String> sourceEnumConstants = Collections.first(method.getSourceParameters()).getType().getEnumConstants();
            List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
            ArrayList<String> unmappedSourceEnumConstants = new ArrayList<String>();
            for (String sourceEnumConstant : sourceEnumConstants) {
                if (targetEnumConstants.contains(sourceEnumConstant) || !method.getMappingBySourcePropertyName(sourceEnumConstant).isEmpty()) continue;
                unmappedSourceEnumConstants.add(sourceEnumConstant);
            }
            if (!unmappedSourceEnumConstants.isEmpty()) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.ENUMMAPPING_UNMAPPED_SOURCES, Strings.join(unmappedSourceEnumConstants, ", "));
            }
            return unmappedSourceEnumConstants.isEmpty();
        }
    }
}

