/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Random;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.mockito.internal.util.StringUtil;
import org.mockito.mock.SerializableMode;

class SubclassBytecodeGenerator
implements BytecodeGenerator {
    private static final String CODEGEN_PACKAGE = "org.mockito.codegen.";
    private final SubclassLoader loader;
    private final ByteBuddy byteBuddy;
    private final Random random;
    private final Implementation readReplace;
    private final ElementMatcher<? super MethodDescription> matcher;
    private final Implementation dispatcher = MethodDelegation.to(MockMethodInterceptor.DispatcherDefaultingToRealMethod.class);
    private final Implementation hashCode = MethodDelegation.to(MockMethodInterceptor.ForHashCode.class);
    private final Implementation equals = MethodDelegation.to(MockMethodInterceptor.ForEquals.class);
    private final Implementation writeReplace = MethodDelegation.to(MockMethodInterceptor.ForWriteReplace.class);

    public SubclassBytecodeGenerator() {
        this(new SubclassInjectionLoader());
    }

    public SubclassBytecodeGenerator(SubclassLoader loader) {
        this(loader, null, (ElementMatcher<? super MethodDescription>)ElementMatchers.any());
    }

    public SubclassBytecodeGenerator(Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this(new SubclassInjectionLoader(), readReplace, matcher);
    }

    protected SubclassBytecodeGenerator(SubclassLoader loader, Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this.loader = loader;
        this.readReplace = readReplace;
        this.matcher = matcher;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.random = new Random();
    }

    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        ClassLoader classLoader;
        String name = this.nameFor(features.mockedType);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = this.byteBuddy.subclass(features.mockedType).name(name).ignoreAlso(SubclassBytecodeGenerator.isGroovyMethod()).annotateType(features.stripAnnotations ? new Annotation[]{} : features.mockedType.getAnnotations()).implement(new ArrayList(features.interfaces)).method(this.matcher).intercept(this.dispatcher).transform(Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN})).attribute((MethodAttributeAppender.Factory)(features.stripAnnotations ? MethodAttributeAppender.NoOp.INSTANCE : MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER)).method((ElementMatcher)ElementMatchers.isHashCode()).intercept(this.hashCode).method((ElementMatcher)ElementMatchers.isEquals()).intercept(this.equals).serialVersionUid(42L).defineField("mockitoInterceptor", MockMethodInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{MockAccess.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
        if (features.serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            builder = builder.implement(new Type[]{ByteBuddyCrossClassLoaderSerializationSupport.CrossClassLoaderSerializableMock.class}).intercept(this.writeReplace);
        }
        if (this.readReplace != null) {
            builder = builder.defineMethod("readObject", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{ObjectInputStream.class}).throwing(new Type[]{ClassNotFoundException.class, IOException.class}).intercept(this.readReplace);
        }
        if ((classLoader = new MultipleParentClassLoader.Builder().append(new Class[]{features.mockedType}).append(features.interfaces).append(new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).append(new Class[]{MockAccess.class, MockMethodInterceptor.DispatcherDefaultingToRealMethod.class}).append(new Class[]{MockMethodInterceptor.class, MockMethodInterceptor.ForHashCode.class, MockMethodInterceptor.ForEquals.class}).build(MockMethodInterceptor.class.getClassLoader())) != features.mockedType.getClassLoader()) {
            SubclassBytecodeGenerator.assertVisibility(features.mockedType);
            for (Class<?> iFace : features.interfaces) {
                SubclassBytecodeGenerator.assertVisibility(iFace);
            }
            builder = builder.ignoreAlso((ElementMatcher)ElementMatchers.isPackagePrivate().or((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.isPackagePrivate())).or((ElementMatcher)ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.whereAny((ElementMatcher)ElementMatchers.hasType((ElementMatcher)ElementMatchers.isPackagePrivate())))));
        }
        return builder.make().load(classLoader, this.loader.resolveStrategy(features.mockedType, classLoader, name.startsWith(CODEGEN_PACKAGE))).getLoaded();
    }

    private static ElementMatcher<MethodDescription> isGroovyMethod() {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.named((String)"groovy.lang.GroovyObjectSupport"));
    }

    private String nameFor(Class<?> type) {
        String typeName = type.getName();
        if (this.isComingFromJDK(type) || this.isComingFromSignedJar(type) || this.isComingFromSealedPackage(type)) {
            typeName = CODEGEN_PACKAGE + type.getSimpleName();
        }
        return String.format("%s$%s$%d", typeName, "MockitoMock", Math.abs(this.random.nextInt()));
    }

    private boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private boolean isComingFromSealedPackage(Class<?> type) {
        return type.getPackage() != null && type.getPackage().isSealed();
    }

    private boolean isComingFromSignedJar(Class<?> type) {
        return type.getSigners() != null;
    }

    private static void assertVisibility(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            throw new MockitoException(StringUtil.join("Cannot create mock for " + type, "", "The type is not public and its mock class is loaded by a different class loader.", "This can have multiple reasons:", " - You are mocking a class with additional interfaces of another class loader", " - Mockito is loaded by a different class loader than the mocked type (e.g. with OSGi)", " - The thread's context class loader is different than the mock's class loader"));
        }
    }
}

