/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.multipart.MultiPartInputStream;
import org.mule.transport.http.multipart.Part;
import org.mule.transport.http.multipart.PartDataSource;

public class HttpMultipartMuleMessageFactory
extends HttpMuleMessageFactory {
    private Collection<Part> parts;

    public HttpMultipartMuleMessageFactory(MuleContext context) {
        super(context);
    }

    @Override
    protected Object extractPayloadFromHttpRequest(HttpRequest httpRequest) throws IOException {
        Object body = null;
        if (httpRequest.getContentType().contains("multipart/form-data")) {
            MultiPartInputStream in = new MultiPartInputStream(httpRequest.getBody(), httpRequest.getContentType(), null);
            this.parts = in.getParts();
            for (Part part : this.parts) {
                if (!part.getName().equals("payload")) continue;
                body = part.getInputStream();
                break;
            }
            if (body == null) {
                throw new IllegalArgumentException("no part named \"payload\" found");
            }
        } else {
            body = super.extractPayloadFromHttpRequest(httpRequest);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAttachments(DefaultMuleMessage message, Object transportMessage) throws Exception {
        if (this.parts != null) {
            try {
                for (Part part : this.parts) {
                    if (part.getName().equals("payload")) continue;
                    message.addInboundAttachment(part.getName(), new DataHandler((DataSource)new PartDataSource(part)));
                }
            }
            finally {
                this.parts.clear();
                this.parts = null;
            }
        }
    }

    @Override
    protected void convertMultiPartHeaders(Map<String, Object> headers) {
        if (this.parts != null) {
            for (Part part : this.parts) {
                if (!part.getName().equals("payload")) continue;
                for (String name : part.getHeaderNames()) {
                    headers.put(name, part.getHeader(name));
                }
            }
        }
    }
}

