/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.ConnectException;
import org.mule.transport.http.HttpMessageProcessTemplate;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.HttpsMessageProcessTemplate;
import org.mule.util.StringUtils;

public class HttpsMessageReceiver
extends HttpMessageReceiver {
    public HttpsMessageReceiver(Connector connector, FlowConstruct flow, InboundEndpoint endpoint) throws CreateException {
        super(connector, flow, endpoint);
    }

    @Override
    protected void doConnect() throws ConnectException {
        this.checkKeyStore();
        super.doConnect();
    }

    protected void checkKeyStore() throws ConnectException {
        HttpsConnector httpsConnector = (HttpsConnector)this.connector;
        String keyStore = httpsConnector.getKeyStore();
        if (StringUtils.isBlank((String)keyStore)) {
            throw new ConnectException(CoreMessages.objectIsNull((String)"tls-key-store"), (Connectable)this);
        }
    }

    HttpMessageProcessTemplate createMessageContext(HttpServerConnection httpServerConnection) {
        return new HttpsMessageProcessTemplate(this, httpServerConnection, this.getWorkManager());
    }
}

