/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class MuleSecureProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLSocketFactory socketFactory;

    public MuleSecureProtocolSocketFactory(SSLSocketFactory factory) {
        this.socketFactory = factory;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        return this.createSocketWithTimeout(host, port, localAddress, localPort, timeout);
    }

    protected Socket createSocketWithTimeout(String host, int port, InetAddress localAddress, int localPort, int timeout) throws IOException {
        Socket socket = this.socketFactory.createSocket();
        InetSocketAddress local = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remote = new InetSocketAddress(host, port);
        socket.bind(local);
        socket.connect(remote, timeout);
        return socket;
    }
}

