/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class ProviderSqlSource
implements SqlSource {
    private final Configuration configuration;
    private final Class<?> providerType;
    private final LanguageDriver languageDriver;
    private Method providerMethod;
    private String[] providerMethodArgumentNames;
    private Class<?>[] providerMethodParameterTypes;
    private ProviderContext providerContext;
    private Integer providerContextIndex;

    @Deprecated
    public ProviderSqlSource(Configuration configuration, Object provider) {
        this(configuration, provider, null, null);
    }

    public ProviderSqlSource(Configuration configuration, Object provider, Class<?> mapperType, Method mapperMethod) {
        String providerMethodName;
        try {
            this.configuration = configuration;
            Lang lang = mapperMethod == null ? null : mapperMethod.getAnnotation(Lang.class);
            this.languageDriver = configuration.getLanguageDriver(lang == null ? null : lang.value());
            this.providerType = (Class)provider.getClass().getMethod("type", new Class[0]).invoke(provider, new Object[0]);
            providerMethodName = (String)provider.getClass().getMethod("method", new Class[0]).invoke(provider, new Object[0]);
            if (providerMethodName.length() == 0 && ProviderMethodResolver.class.isAssignableFrom(this.providerType)) {
                this.providerMethod = ((ProviderMethodResolver)this.providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).resolveMethod(new ProviderContext(mapperType, mapperMethod, configuration.getDatabaseId()));
            }
            if (this.providerMethod == null) {
                providerMethodName = providerMethodName.length() == 0 ? "provideSql" : providerMethodName;
                for (Method m : this.providerType.getMethods()) {
                    if (!providerMethodName.equals(m.getName()) || !CharSequence.class.isAssignableFrom(m.getReturnType())) continue;
                    if (this.providerMethod != null) {
                        throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + providerMethodName + "' is found multiple in SqlProvider '" + this.providerType.getName() + "'. Sql provider method can not overload.");
                    }
                    this.providerMethod = m;
                }
            }
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error creating SqlSource for SqlProvider.  Cause: " + e, e);
        }
        if (this.providerMethod == null) {
            throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + providerMethodName + "' not found in SqlProvider '" + this.providerType.getName() + "'.");
        }
        this.providerMethodArgumentNames = new ParamNameResolver(configuration, this.providerMethod).getNames();
        this.providerMethodParameterTypes = this.providerMethod.getParameterTypes();
        for (int i = 0; i < this.providerMethodParameterTypes.length; ++i) {
            Class<?> parameterType = this.providerMethodParameterTypes[i];
            if (parameterType != ProviderContext.class) continue;
            if (this.providerContext != null) {
                throw new BuilderException("Error creating SqlSource for SqlProvider. ProviderContext found multiple in SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). ProviderContext can not define multiple in SqlProvider method argument.");
            }
            this.providerContext = new ProviderContext(mapperType, mapperMethod, configuration.getDatabaseId());
            this.providerContextIndex = i;
        }
    }

    @Override
    public BoundSql getBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql;
            int bindParameterCount = this.providerMethodParameterTypes.length - (this.providerContext == null ? 0 : 1);
            if (this.providerMethodParameterTypes.length == 0) {
                sql = this.invokeProviderMethod(new Object[0]);
            } else if (bindParameterCount == 0) {
                sql = this.invokeProviderMethod(this.providerContext);
            } else if (bindParameterCount == 1 && (parameterObject == null || this.providerMethodParameterTypes[this.providerContextIndex == null || this.providerContextIndex == 1 ? 0 : 1].isAssignableFrom(parameterObject.getClass()))) {
                sql = this.invokeProviderMethod(this.extractProviderMethodArguments(parameterObject));
            } else if (parameterObject instanceof Map) {
                Map params = (Map)parameterObject;
                sql = this.invokeProviderMethod(this.extractProviderMethodArguments(params, this.providerMethodArgumentNames));
            } else {
                throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). Cannot invoke a method that holds " + (bindParameterCount == 1 ? "named argument(@Param)" : "multiple arguments") + " using a specifying parameterObject. In this case, please specify a 'java.util.Map' object.");
            }
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            return this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, e);
        }
    }

    private Object[] extractProviderMethodArguments(Object parameterObject) {
        if (this.providerContext != null) {
            Object[] args = new Object[2];
            args[this.providerContextIndex.intValue() == 0 ? 1 : 0] = parameterObject;
            args[this.providerContextIndex.intValue()] = this.providerContext;
            return args;
        }
        return new Object[]{parameterObject};
    }

    private Object[] extractProviderMethodArguments(Map<String, Object> params, String[] argumentNames) {
        Object[] args = new Object[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.providerContextIndex != null && this.providerContextIndex == i ? this.providerContext : params.get(argumentNames[i]);
        }
        return args;
    }

    private String invokeProviderMethod(Object ... args) throws Exception {
        CharSequence sql;
        Object targetObject = null;
        if (!Modifier.isStatic(this.providerMethod.getModifiers())) {
            targetObject = this.providerType.newInstance();
        }
        return (sql = (CharSequence)this.providerMethod.invoke(targetObject, args)) != null ? sql.toString() : null;
    }
}

