/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;

public class ConnectionFactory {
    protected ConnectionFactory() {
    }

    public static Connection getConnection(String string) throws IllegalArgumentException {
        CVSRoot cVSRoot = CVSRoot.parse(string);
        return ConnectionFactory.getConnection(cVSRoot);
    }

    public static Connection getConnection(CVSRoot cVSRoot) throws IllegalArgumentException {
        if (cVSRoot.isLocal()) {
            LocalConnection localConnection = new LocalConnection();
            localConnection.setRepository(cVSRoot.getRepository());
            return localConnection;
        }
        String string = cVSRoot.getMethod();
        if ("pserver" == string) {
            PServerConnection pServerConnection = new PServerConnection(cVSRoot);
            return pServerConnection;
        }
        throw new IllegalArgumentException("Unrecognized CVS Root: " + cVSRoot);
    }
}

