/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.List;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ListOperator
extends ComponentOperator
implements Outputable {
    public static final String ITEM_PREFIX_DPROP = "Item";
    public static final String SELECTED_ITEM_PREFIX_DPROP = "SelectedItem";
    private TestOut output;
    private MultiSelListDriver driver = DriverManager.getMultiSelListDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$List;

    public ListOperator(List b) {
        super(b);
    }

    public ListOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((List)cont.waitSubComponent(new ListFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ListOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ListOperator(ContainerOperator cont, String text, int itemIndex, int index) {
        this((List)ListOperator.waitComponent(cont, (ComponentChooser)new ListByItemFinder(text, itemIndex, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public ListOperator(ContainerOperator cont, String text, int index) {
        this(cont, text, -1, index);
    }

    public ListOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public ListOperator(ContainerOperator cont, int index) {
        this((List)ListOperator.waitComponent(cont, (ComponentChooser)new ListFinder(), index));
        this.copyEnvironment(cont);
    }

    public ListOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static List findList(Container cont, ComponentChooser chooser, int index) {
        return (List)ListOperator.findComponent(cont, new ListFinder(chooser), index);
    }

    public static List findList(Container cont, ComponentChooser chooser) {
        return ListOperator.findList(cont, chooser, 0);
    }

    public void setOutput(TestOut output) {
        super.setOutput(output.createErrorOutput());
        this.output = output;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (MultiSelListDriver)DriverManager.getDriver("drivers.multisellist", this.getClass(), anotherOperator.getProperties());
    }

    private int findItemIndex(String item, Operator.StringComparator comparator, int index) {
        int count = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!comparator.equals(this.getItem(i), item)) continue;
            if (count == index) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public int findItemIndex(String item, int index) {
        return this.findItemIndex(item, this.getComparator(), index);
    }

    public int findItemIndex(String item) {
        return this.findItemIndex(item, 0);
    }

    private void selectItem(String item, Operator.StringComparator comparator, int index) {
        this.selectItem(this.findItemIndex(item, comparator, index));
    }

    public void selectItem(String item, int index) {
        this.selectItem(item, this.getComparator(), index);
    }

    public void selectItem(String item) {
        this.selectItem(item, 0);
    }

    public void selectItem(int index) {
        this.output.printLine("Select " + Integer.toString(index) + "`th item in list\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(index) + "`th item in list");
        this.driver.selectItem(this, index);
        if (this.getVerification()) {
            this.waitItemSelection(index, true);
        }
    }

    public void selectItems(int from, int to) {
        this.output.printLine("Select items from " + Integer.toString(from) + "`th to " + Integer.toString(from) + "'th in list\n    : " + this.toStringSource());
        this.output.printGolden("Select items from " + Integer.toString(from) + "`th to " + Integer.toString(from) + "'th");
        this.driver.selectItems(this, new int[]{from, to});
        if (this.getVerification()) {
            this.waitItemsSelection(from, to, true);
        }
    }

    public void waitItemsSelection(final int from, final int to, final boolean selected) {
        this.getOutput().printLine("Wait items to be " + (selected ? "" : "un") + "selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait items to be " + (selected ? "" : "un") + "selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                int[] indices = ListOperator.this.getSelectedIndexes();
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] >= from && indices[i] <= to) continue;
                    return false;
                }
                return true;
            }

            public String getDescription() {
                return "Items has been " + (selected ? "" : "un") + "selected";
            }
        });
    }

    public void waitItemSelection(int itemIndex, boolean selected) {
        this.waitItemsSelection(itemIndex, itemIndex, selected);
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        this.addToDump(result, ITEM_PREFIX_DPROP, ((List)this.getSource()).getItems());
        this.addToDump(result, SELECTED_ITEM_PREFIX_DPROP, ((List)this.getSource()).getSelectedItems());
        return result;
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void deselect(final int i) {
        this.runMapping(new Operator.MapVoidAction("deselect"){

            public void map() {
                ((List)ListOperator.this.getSource()).deselect(i);
            }
        });
    }

    public String getItem(final int i) {
        return (String)this.runMapping(new Operator.MapAction("getItem"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getItem(i);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getItemCount();
            }
        });
    }

    public String[] getItems() {
        return (String[])this.runMapping(new Operator.MapAction("getItems"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getItems();
            }
        });
    }

    public Dimension getMinimumSize(final int i) {
        return (Dimension)this.runMapping(new Operator.MapAction("getMinimumSize"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getMinimumSize(i);
            }
        });
    }

    public Dimension getPreferredSize(final int i) {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredSize"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getPreferredSize(i);
            }
        });
    }

    public int getRows() {
        return this.runMapping(new Operator.MapIntegerAction("getRows"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getRows();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public int[] getSelectedIndexes() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedIndexes"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedIndexes();
            }
        });
    }

    public String getSelectedItem() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedItem"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public String[] getSelectedItems() {
        return (String[])this.runMapping(new Operator.MapAction("getSelectedItems"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedItems();
            }
        });
    }

    public Object[] getSelectedObjects() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedObjects"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedObjects();
            }
        });
    }

    public int getVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleIndex"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getVisibleIndex();
            }
        });
    }

    public boolean isIndexSelected(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isIndexSelected"){

            public boolean map() {
                return ((List)ListOperator.this.getSource()).isIndexSelected(i);
            }
        });
    }

    public boolean isMultipleMode() {
        return this.runMapping(new Operator.MapBooleanAction("isMultipleMode"){

            public boolean map() {
                return ((List)ListOperator.this.getSource()).isMultipleMode();
            }
        });
    }

    public void makeVisible(final int i) {
        this.runMapping(new Operator.MapVoidAction("makeVisible"){

            public void map() {
                ((List)ListOperator.this.getSource()).makeVisible(i);
            }
        });
    }

    public void remove(final int i) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((List)ListOperator.this.getSource()).remove(i);
            }
        });
    }

    public void remove(final String string) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((List)ListOperator.this.getSource()).remove(string);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void removeAll() {
        this.runMapping(new Operator.MapVoidAction("removeAll"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeAll();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void replaceItem(final String string, final int i) {
        this.runMapping(new Operator.MapVoidAction("replaceItem"){

            public void map() {
                ((List)ListOperator.this.getSource()).replaceItem(string, i);
            }
        });
    }

    public void select(final int i) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((List)ListOperator.this.getSource()).select(i);
            }
        });
    }

    public void setMultipleMode(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setMultipleMode"){

            public void map() {
                ((List)ListOperator.this.getSource()).setMultipleMode(b);
            }
        });
    }

    public static class ListFinder
    extends Operator.Finder {
        public ListFinder(ComponentChooser sf) {
            super(class$java$awt$List == null ? (class$java$awt$List = ListOperator.class$("java.awt.List")) : class$java$awt$List, sf);
        }

        public ListFinder() {
            super(class$java$awt$List == null ? (class$java$awt$List = ListOperator.class$("java.awt.List")) : class$java$awt$List);
        }
    }

    public static class ListByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public ListByItemFinder(String lb, int ii, Operator.StringComparator comparator) {
            this.label = lb;
            this.itemIndex = ii;
            this.comparator = comparator;
        }

        public ListByItemFinder(String lb, int ii) {
            this(lb, ii, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof List) {
                if (this.label == null) {
                    return true;
                }
                if (((List)comp).getItemCount() > this.itemIndex) {
                    int ii = this.itemIndex;
                    if (ii == -1 && (ii = ((List)comp).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((List)comp).getItem(ii), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "List with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }
}

