/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openapitools.codegen.utils.JsonCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonCacheImpl
implements JsonCache.Root {
    protected static final JsonPointer EMPTY_PTR = JsonPointer.compile((String)"/");
    private static final Pattern INTEGER = Pattern.compile("^\\d+$");
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonCacheImpl.class);
    protected boolean isDirty;
    protected boolean isLoaded;
    protected ObjectMapper mapper;
    protected JsonCache.Root.MergePolicy mergePolicy = JsonCache.Root.MergePolicy.MERGE_RECURSIVE;
    protected ContainerNode<?> root;
    private boolean shutdownHookRegistered;

    protected JsonCacheImpl() {
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public JsonCache add(JsonPointer ptr, BigDecimal value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, BigInteger value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, boolean value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, double value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, float value) {
        return this.add(ptr, this.nodeFor(Float.valueOf(value)));
    }

    @Override
    public JsonCache add(JsonPointer ptr, int value) {
        return this.add(ptr, this.nodeFor(value));
    }

    protected JsonCache add(JsonPointer ptr, JsonNode node) {
        String lastProperty = ptr.last().getMatchingProperty();
        boolean isIndexed = this.isInteger(lastProperty);
        ContainerNode<?> container = this.ensureContainerExists(ptr, !isIndexed);
        switch (container.getNodeType()) {
            case ARRAY: {
                int index;
                ArrayNode array = (ArrayNode)container;
                int n = index = isIndexed ? Integer.parseInt(lastProperty) : array.size();
                if (index < array.size()) {
                    array.insert(index, node);
                    break;
                }
                for (int i = array.size(); i < index; ++i) {
                    array.add((JsonNode)array.nullNode());
                }
                array.add(node);
                break;
            }
            default: {
                throw new IllegalArgumentException(ptr + " does not identify an array");
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public JsonCache add(JsonPointer ptr, long value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, Object value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(JsonPointer ptr, short value) {
        return this.add(ptr, this.nodeFor(value));
    }

    @Override
    public JsonCache add(String path, BigDecimal value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, BigInteger value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, boolean value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, double value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, float value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, int value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, long value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, Object value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache add(String path, short value) {
        return this.add(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache child(JsonPointer basePtr) {
        return new ChildCacheImpl(this, basePtr);
    }

    @Override
    public JsonCache child(String path) {
        return this.child(JsonPointer.compile((String)path));
    }

    @Override
    public void delete(JsonPointer ptr) {
        JsonPointer head = ptr.head();
        if (head == null) {
            this.root = null;
        } else if (this.root != null) {
            JsonNode parent = this.root.at(head);
            if (parent.isArray()) {
                ((ArrayNode)parent).remove(Integer.parseInt(ptr.last().getMatchingProperty()));
            } else if (parent.isObject()) {
                ((ObjectNode)parent).remove(ptr.last().getMatchingProperty());
            } else {
                throw new IllegalArgumentException(ptr + " does not identify a deletable node");
            }
        }
        this.setDirty();
    }

    @Override
    public void delete(String path) {
        this.delete(JsonPointer.compile((String)path));
    }

    protected ContainerNode<?> ensureContainerExists(JsonPointer ptr) {
        return this.ensureContainerExists(ptr, false);
    }

    protected ContainerNode<?> ensureContainerExists(JsonPointer ptr, boolean forceArray) {
        if (this.root == null) {
            this.root = this.isInteger(ptr.getMatchingProperty()) ? JsonNodeFactory.instance.arrayNode() : JsonNodeFactory.instance.objectNode();
        }
        String lastProperty = ptr.last().getMatchingProperty();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        JsonPointer ancestorPtr = forceArray && !this.isInteger(lastProperty) ? ptr : ptr.head();
        JsonNode ancestor = this.root.at(ancestorPtr);
        while (ancestor.isMissingNode()) {
            stack.push(ancestorPtr.last().getMatchingProperty());
            ancestorPtr = ancestorPtr.head();
            ancestor = this.root.at(ancestorPtr);
        }
        if (!ancestor.isContainerNode()) {
            throw new IllegalArgumentException(ancestorPtr + " does not identify a container node");
        }
        while (!stack.isEmpty()) {
            block13: {
                String ancestorProperty;
                block12: {
                    String childProperty;
                    ancestorProperty = (String)stack.pop();
                    String string = stack.isEmpty() ? (forceArray && !this.isInteger(lastProperty) ? "0" : lastProperty) : (childProperty = (String)stack.peek());
                    if (!this.isInteger(childProperty)) break block12;
                    switch (ancestor.getNodeType()) {
                        case ARRAY: {
                            ancestor = ((ArrayNode)ancestor).insertArray(Integer.parseInt(ancestorProperty));
                            break block13;
                        }
                        case OBJECT: {
                            ancestor = ((ObjectNode)ancestor).putArray(ancestorProperty);
                            break block13;
                        }
                        default: {
                            throw new IllegalArgumentException(ancestorProperty + " does not identify an array node");
                        }
                    }
                }
                switch (ancestor.getNodeType()) {
                    case ARRAY: {
                        ancestor = ((ArrayNode)ancestor).insertObject(Integer.parseInt(ancestorProperty));
                        break;
                    }
                    case OBJECT: {
                        ancestor = ((ObjectNode)ancestor).putObject(ancestorProperty);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ancestorProperty + " does not identify an array node");
                    }
                }
            }
            this.setDirty();
        }
        return (ContainerNode)ancestor;
    }

    @Override
    public boolean exists(JsonPointer ptr) {
        return this.root != null && !this.root.at(ptr).isMissingNode();
    }

    @Override
    public boolean exists(String path) {
        return this.exists(JsonPointer.compile((String)path));
    }

    @Override
    public JsonCache.Root flush(File file) throws JsonCache.CacheException {
        if (this.isDirty) {
            this.save(file);
        }
        return this;
    }

    @Override
    public JsonCache.Root flush(OutputStream out) throws JsonCache.CacheException {
        if (this.isDirty) {
            this.save(out);
        }
        return this;
    }

    @Override
    public JsonCache.Root flushOnShutdown(final File file) {
        if (!this.shutdownHookRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        JsonCacheImpl.this.flush(file);
                    }
                    catch (JsonCache.CacheException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.shutdownHookRegistered = true;
        }
        return this;
    }

    @Override
    public JsonCache.Root flushOnShutdown(final OutputStream out) {
        if (!this.shutdownHookRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        JsonCacheImpl.this.flush(out);
                    }
                    catch (JsonCache.CacheException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.shutdownHookRegistered = true;
        }
        return this;
    }

    @Override
    public Object get(JsonPointer ptr) throws JsonCache.CacheException {
        Object result;
        if (this.root == null) {
            result = null;
        } else {
            try {
                JsonNode node = this.root.at(ptr);
                switch (node.getNodeType()) {
                    case ARRAY: 
                    case OBJECT: {
                        result = node;
                        break;
                    }
                    case BINARY: {
                        result = node.binaryValue();
                        break;
                    }
                    case BOOLEAN: {
                        result = node.booleanValue();
                        break;
                    }
                    case NUMBER: {
                        result = node.numberValue();
                        break;
                    }
                    case POJO: {
                        result = ((POJONode)node).getPojo();
                        break;
                    }
                    case STRING: {
                        result = node.textValue();
                        break;
                    }
                    default: {
                        result = null;
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new JsonCache.CacheException(e);
            }
        }
        return result;
    }

    @Override
    public Object get(JsonPointer ptr, Object defaultValue) throws JsonCache.CacheException {
        Object result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.get(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Object get(String path) throws JsonCache.CacheException {
        return this.get(JsonPointer.compile((String)path));
    }

    @Override
    public Object get(String path, Object defaultValue) throws JsonCache.CacheException {
        return this.get(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(JsonPointer ptr) {
        return this.root == null ? null : this.root.at(ptr).decimalValue();
    }

    @Override
    public BigDecimal getBigDecimal(JsonPointer ptr, BigDecimal defaultValue) throws JsonCache.CacheException {
        BigDecimal result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getBigDecimal(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String path) {
        return this.getBigDecimal(JsonPointer.compile((String)path));
    }

    @Override
    public BigDecimal getBigDecimal(String path, BigDecimal defaultValue) throws JsonCache.CacheException {
        return this.getBigDecimal(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public BigInteger getBigInteger(JsonPointer ptr) {
        return this.root == null ? null : this.root.at(ptr).bigIntegerValue();
    }

    @Override
    public BigInteger getBigInteger(JsonPointer ptr, BigInteger defaultValue) throws JsonCache.CacheException {
        BigInteger result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getBigInteger(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public BigInteger getBigInteger(String path) {
        return this.getBigInteger(JsonPointer.compile((String)path));
    }

    @Override
    public BigInteger getBigInteger(String path, BigInteger defaultValue) throws JsonCache.CacheException {
        return this.getBigInteger(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public byte[] getBinary(JsonPointer ptr) throws JsonCache.CacheException {
        try {
            return this.root == null ? null : this.root.at(ptr).binaryValue();
        }
        catch (IOException e) {
            throw new JsonCache.CacheException(e);
        }
    }

    @Override
    public byte[] getBinary(JsonPointer ptr, byte[] defaultValue) throws JsonCache.CacheException {
        byte[] result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getBinary(ptr);
        } else {
            this.set(ptr, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public byte[] getBinary(String path) throws JsonCache.CacheException {
        return this.getBinary(JsonPointer.compile((String)path));
    }

    @Override
    public byte[] getBinary(String path, byte[] defaultValue) throws JsonCache.CacheException {
        return this.getBinary(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public boolean getBoolean(JsonPointer ptr) {
        return this.root != null && this.root.at(ptr).booleanValue();
    }

    @Override
    public boolean getBoolean(JsonPointer ptr, boolean defaultValue) throws JsonCache.CacheException {
        boolean result;
        if (this.exists(ptr)) {
            result = this.getBoolean(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean getBoolean(String path) {
        return this.getBoolean(JsonPointer.compile((String)path));
    }

    @Override
    public boolean getBoolean(String path, boolean defaultValue) throws JsonCache.CacheException {
        return this.getBoolean(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public double getDouble(JsonPointer ptr) {
        return this.root == null ? 0.0 : this.root.at(ptr).doubleValue();
    }

    @Override
    public double getDouble(JsonPointer ptr, double defaultValue) throws JsonCache.CacheException {
        double result;
        Objects.requireNonNull(Double.valueOf(defaultValue), "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getDouble(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public double getDouble(String path) {
        return this.getDouble(JsonPointer.compile((String)path));
    }

    @Override
    public double getDouble(String path, double defaultValue) throws JsonCache.CacheException {
        return this.getDouble(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public float getFloat(JsonPointer ptr) {
        return this.root == null ? 0.0f : this.root.at(ptr).floatValue();
    }

    @Override
    public float getFloat(JsonPointer ptr, float defaultValue) throws JsonCache.CacheException {
        float result;
        if (this.exists(ptr)) {
            result = this.getFloat(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public float getFloat(String path) {
        return this.getFloat(JsonPointer.compile((String)path));
    }

    @Override
    public float getFloat(String path, float defaultValue) throws JsonCache.CacheException {
        return this.getFloat(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public int getInt(JsonPointer ptr) {
        return this.root == null ? 0 : this.root.at(ptr).intValue();
    }

    @Override
    public int getInt(JsonPointer ptr, int defaultValue) throws JsonCache.CacheException {
        int result;
        if (this.exists(ptr)) {
            result = this.getInt(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public int getInt(String path) {
        return this.getInt(JsonPointer.compile((String)path));
    }

    @Override
    public int getInt(String path, int defaultValue) throws JsonCache.CacheException {
        return this.getInt(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public long getLong(JsonPointer ptr) {
        return this.root == null ? 0L : this.root.at(ptr).longValue();
    }

    @Override
    public long getLong(JsonPointer ptr, long defaultValue) throws JsonCache.CacheException {
        long result;
        if (this.exists(ptr)) {
            result = this.getLong(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public long getLong(String path) {
        return this.getLong(JsonPointer.compile((String)path));
    }

    @Override
    public long getLong(String path, long defaultValue) throws JsonCache.CacheException {
        return this.getLong(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public JsonCache.Root.MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    @Override
    public JsonNodeType getNodeType(JsonPointer ptr) {
        return this.root.at(ptr).getNodeType();
    }

    @Override
    public JsonNodeType getNodeType(String path) {
        return this.getNodeType(JsonPointer.compile((String)path));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public Number getNumber(JsonPointer ptr) {
        return this.root == null ? (Number)null : (Number)this.root.at(ptr).numberValue();
    }

    @Override
    public Number getNumber(JsonPointer ptr, Number defaultValue) throws JsonCache.CacheException {
        Number result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getNumber(ptr);
        } else {
            this.set(ptr, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Number getNumber(String path) {
        return this.getNumber(JsonPointer.compile((String)path));
    }

    @Override
    public Number getNumber(String path, Number defaultValue) throws JsonCache.CacheException {
        return this.getNumber(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public <T> T getObject(JsonPointer ptr, Class<T> type) throws JsonCache.CacheException {
        Object result;
        if (this.root == null) {
            result = null;
        } else {
            JsonNode node = this.root.at(ptr);
            JsonNode value = node.isPojo() && !JsonNode.class.isAssignableFrom(type) ? ((POJONode)node).getPojo() : node;
            result = value != null && value.getClass() == type ? value : this.mapper.convertValue((Object)value, type);
        }
        return (T)result;
    }

    @Override
    public <T> T getObject(JsonPointer ptr, T defaultValue) throws JsonCache.CacheException {
        Class<Object> result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getObject(ptr, (T)defaultValue.getClass());
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return (T)result;
    }

    @Override
    public <T> T getObject(String path, Class<T> type) throws JsonCache.CacheException {
        return (T)this.getObject(JsonPointer.compile((String)path), (T)type);
    }

    @Override
    public <T> T getObject(String path, T defaultValue) throws JsonCache.CacheException {
        return this.getObject(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public <T> List<T> getObjects(JsonPointer ptr, Class<T> type) throws JsonCache.CacheException {
        List result;
        if (this.root == null) {
            result = null;
        } else {
            JsonNode node = this.root.at(ptr);
            switch (node.getNodeType()) {
                case ARRAY: 
                case OBJECT: {
                    result = new ArrayList(node.size());
                    Iterator elements = node.elements();
                    while (elements.hasNext()) {
                        result.add(this.mapper.convertValue(elements.next(), type));
                    }
                    break;
                }
                default: {
                    result = Collections.emptyList();
                }
            }
        }
        return result;
    }

    @Override
    public <T> List<T> getObjects(JsonPointer ptr, Class<T> type, List<T> defaultValue) throws JsonCache.CacheException {
        List<T> result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getObjects(ptr, type);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public <T> List<T> getObjects(String path, Class<T> type) throws JsonCache.CacheException {
        return this.getObjects(JsonPointer.compile((String)path), type);
    }

    @Override
    public <T> List<T> getObjects(String path, Class<T> type, List<T> defaultValue) throws JsonCache.CacheException {
        return this.getObjects(JsonPointer.compile((String)path), type, defaultValue);
    }

    @Override
    public short getShort(JsonPointer ptr) {
        return this.root == null ? (short)0 : this.root.at(ptr).shortValue();
    }

    @Override
    public short getShort(JsonPointer ptr, short defaultValue) {
        short result;
        if (this.exists(ptr)) {
            result = this.getShort(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public short getShort(String path) {
        return this.getShort(JsonPointer.compile((String)path));
    }

    @Override
    public short getShort(String path, short defaultValue) {
        return this.getShort(JsonPointer.compile((String)path), defaultValue);
    }

    @Override
    public String getString(JsonPointer ptr) {
        return this.root == null ? null : this.root.at(ptr).textValue();
    }

    @Override
    public String getString(JsonPointer ptr, String defaultValue) {
        String result;
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        if (this.exists(ptr)) {
            result = this.getString(ptr);
        } else {
            this.set(ptr, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    @Override
    public String getString(String path) {
        return this.getString(JsonPointer.compile((String)path));
    }

    @Override
    public String getString(String path, String defaultValue) {
        return this.getString(JsonPointer.compile((String)path), defaultValue);
    }

    protected void insertNumber(ArrayNode array, int index, Number value) {
        if (value instanceof Short) {
            array.insert(index, (int)((Short)value).shortValue());
        } else if (value instanceof Integer) {
            array.insert(index, (Integer)value);
        } else if (value instanceof Long) {
            array.insert(index, (Long)value);
        } else if (value instanceof Float) {
            array.insert(index, (Float)value);
        } else if (value instanceof Double) {
            array.insert(index, (Double)value);
        } else if (value instanceof BigInteger) {
            array.insert(index, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            array.insert(index, (BigDecimal)value);
        } else {
            throw new IllegalArgumentException("unsupported numeric value: " + value + " (" + value.getClass().getSimpleName() + ')');
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    protected boolean isInteger(String s) {
        return INTEGER.matcher(s).matches();
    }

    @Override
    public JsonCache.Root load(File file) throws JsonCache.CacheException {
        Objects.requireNonNull(file, "file is required");
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                this.load(in);
            }
            catch (IOException e) {
                throw new JsonCache.CacheException(e);
            }
        }
        return this;
    }

    @Override
    public JsonCache.Root load(InputStream in) throws JsonCache.CacheException {
        Objects.requireNonNull(in, "in is required");
        try (InputStream is = in;){
            if (this.isLoaded) {
                if (this.mergePolicy != JsonCache.Root.MergePolicy.NO_MERGE) {
                    ContainerNode tree = (ContainerNode)this.mapper.readTree(in);
                    this.merge(this.root, tree);
                }
            } else {
                this.root = (ContainerNode)this.mapper.readTree(in);
                this.isDirty = false;
                this.isLoaded = true;
            }
        }
        catch (IOException e) {
            throw new JsonCache.CacheException(e);
        }
        return this;
    }

    @Override
    public JsonCache.Root mapper(ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper is required");
        this.mapper = mapper;
        return this;
    }

    protected void merge(ContainerNode<?> dest, ContainerNode<?> src) {
        if (dest.getNodeType() == src.getNodeType()) {
            if (dest.isArray()) {
                ArrayNode destArray = (ArrayNode)dest;
                ArrayNode srcArray = (ArrayNode)src;
                block5: for (int i = 0; i < srcArray.size(); ++i) {
                    JsonNode srcElem = srcArray.get(i);
                    for (int j = 0; j < destArray.size(); ++j) {
                        if (destArray.get(j).equals((Object)srcElem)) continue block5;
                    }
                    destArray.add(srcElem);
                }
            } else if (dest.isObject()) {
                ObjectNode destObject = (ObjectNode)dest;
                ObjectNode srcObject = (ObjectNode)src;
                Iterator fields = srcObject.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    String fieldName = (String)field.getKey();
                    JsonNode srcChild = (JsonNode)field.getValue();
                    if (destObject.has(fieldName)) {
                        JsonNode destChild = destObject.get(fieldName);
                        switch (this.mergePolicy) {
                            case OVERWRITE_EXISTING: {
                                destObject.set(fieldName, srcChild);
                                this.isDirty = true;
                                LOGGER.info("Existing root property '" + fieldName + "' has been overwritten by incoming data");
                                break;
                            }
                            case MERGE_RECURSIVE: {
                                if (!destChild.isContainerNode() || !srcChild.isContainerNode()) break;
                                this.merge((ContainerNode)destChild, (ContainerNode)srcChild);
                                break;
                            }
                            case KEEP_EXISTING: {
                                LOGGER.info("Existing root property '" + fieldName + "' will not be overwritten by incoming data");
                            }
                        }
                        continue;
                    }
                    destObject.set(fieldName, srcChild);
                    LOGGER.info("New property '" + fieldName + "' has been added from incoming data");
                    this.isDirty = true;
                }
            }
        } else {
            LOGGER.warn("Cannot merge containers of differing types");
        }
    }

    @Override
    public JsonCache.Root mergePolicy(JsonCache.Root.MergePolicy policy) {
        Objects.requireNonNull(policy, "policy is required");
        this.mergePolicy = policy;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonNode nodeFor(Object value) {
        void var2_18;
        if (value == null) {
            NullNode nullNode = this.root.nullNode();
            return var2_18;
        } else if (value instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)value;
            return var2_18;
        } else if (value instanceof Boolean) {
            BooleanNode booleanNode = this.root.booleanNode(((Boolean)value).booleanValue());
            return var2_18;
        } else if (value instanceof List) {
            ArrayNode arrayNode = this.root.arrayNode();
            for (Object element : (List)value) {
                arrayNode.add(this.nodeFor(element));
            }
            return var2_18;
        } else if (value instanceof Map) {
            ObjectNode objectNode = this.root.objectNode();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                objectNode.set((String)entry.getKey(), this.nodeFor(entry.getValue()));
            }
            return var2_18;
        } else if (value instanceof Number) {
            if (value instanceof Byte) {
                ValueNode valueNode = this.root.numberNode((Byte)value);
                return var2_18;
            } else if (value instanceof Short) {
                ValueNode valueNode = this.root.numberNode((Short)value);
                return var2_18;
            } else if (value instanceof Integer) {
                ValueNode valueNode = this.root.numberNode((Integer)value);
                return var2_18;
            } else if (value instanceof Long) {
                ValueNode valueNode = this.root.numberNode((Long)value);
                return var2_18;
            } else if (value instanceof Float) {
                ValueNode valueNode = this.root.numberNode((Float)value);
                return var2_18;
            } else if (value instanceof Double) {
                ValueNode valueNode = this.root.numberNode((Double)value);
                return var2_18;
            } else if (value instanceof BigInteger) {
                ValueNode valueNode = this.root.numberNode((BigInteger)value);
                return var2_18;
            } else {
                if (!(value instanceof BigDecimal)) throw new IllegalArgumentException("unsupported number type: " + value.getClass().getSimpleName());
                ValueNode valueNode = this.root.numberNode((BigDecimal)value);
            }
            return var2_18;
        } else if (value instanceof String) {
            TextNode textNode = this.root.textNode((String)value);
            return var2_18;
        } else if (value instanceof byte[]) {
            BinaryNode binaryNode = this.root.binaryNode((byte[])value);
            return var2_18;
        } else {
            ValueNode valueNode = this.root.pojoNode(value);
        }
        return var2_18;
    }

    protected JsonNodeType nodeTypeFor(Object value) {
        JsonNodeType type = value == null ? JsonNodeType.NULL : (value instanceof Boolean ? JsonNodeType.BOOLEAN : (value instanceof Number ? JsonNodeType.NUMBER : (value instanceof String ? JsonNodeType.STRING : (value instanceof ArrayNode || value instanceof List ? JsonNodeType.ARRAY : (value instanceof byte[] ? JsonNodeType.BINARY : (value instanceof ObjectNode || value instanceof Map ? JsonNodeType.OBJECT : JsonNodeType.POJO))))));
        return type;
    }

    @Override
    public JsonCache parent() {
        return null;
    }

    protected void putNumber(ObjectNode object, String property, Number value) {
        if (value instanceof Short) {
            object.put(property, (Short)value);
        } else if (value instanceof Integer) {
            object.put(property, (Integer)value);
        } else if (value instanceof Long) {
            object.put(property, (Long)value);
        } else if (value instanceof Float) {
            object.put(property, (Float)value);
        } else if (value instanceof Double) {
            object.put(property, (Double)value);
        } else if (value instanceof BigInteger) {
            object.put(property, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            object.put(property, (BigDecimal)value);
        } else {
            throw new IllegalArgumentException("unsupported numeric value: " + value + " (" + value.getClass().getSimpleName() + ')');
        }
    }

    @Override
    public JsonCache.Root root() {
        return this;
    }

    @Override
    public JsonCache.Root save(File file) throws JsonCache.CacheException {
        Objects.requireNonNull(file, "file is required");
        file.getParentFile().mkdirs();
        try {
            this.save(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new JsonCache.CacheException(e);
        }
        return this;
    }

    @Override
    public JsonCache.Root save(OutputStream out) throws JsonCache.CacheException {
        if (this.root == null || this.root.isMissingNode()) {
            throw new JsonCache.CacheException("null or missing root node");
        }
        Objects.requireNonNull(out, "out is required");
        try (OutputStream o = out;){
            this.mapper.writeValue(o, this.root);
        }
        catch (IOException e) {
            throw new JsonCache.CacheException(e);
        }
        this.isDirty = false;
        return this;
    }

    @Override
    public JsonCache set(JsonPointer ptr, BigDecimal value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, BigInteger value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, boolean value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, double value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, float value) {
        return this.set(ptr, (Object)Float.valueOf(value));
    }

    @Override
    public JsonCache set(JsonPointer ptr, int value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, List<?> values) throws JsonCache.CacheException {
        ArrayNode array;
        ContainerNode<?> container = this.ensureContainerExists(ptr);
        JsonNode target = container.at(ptr.last());
        if (target.isArray()) {
            array = (ArrayNode)target;
        } else {
            String property = ptr.last().getMatchingProperty();
            array = container.arrayNode();
            switch (container.getNodeType()) {
                case ARRAY: {
                    int index = Integer.parseInt(property);
                    ((ArrayNode)container).set(index, (JsonNode)array);
                    break;
                }
                case OBJECT: {
                    ((ObjectNode)container).set(property, (JsonNode)array);
                    break;
                }
                default: {
                    throw new JsonCache.CacheException(ptr + " does not identify an array");
                }
            }
        }
        array.removeAll();
        for (Object value : values) {
            JsonNode node = this.nodeFor(value);
            array.add(node);
        }
        this.setDirty();
        return this;
    }

    @Override
    public JsonCache set(JsonPointer ptr, long value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, Object value) {
        String property = ptr.last().getMatchingProperty();
        ContainerNode<?> container = this.ensureContainerExists(ptr);
        JsonNode node = this.nodeFor(value);
        switch (container.getNodeType()) {
            case ARRAY: {
                ArrayNode array = (ArrayNode)container;
                int index = Integer.parseInt(property);
                if (index < array.size()) {
                    array.set(index, node);
                    break;
                }
                for (int i = array.size(); i < index; ++i) {
                    array.add((JsonNode)array.nullNode());
                }
                array.add(node);
                break;
            }
            case OBJECT: {
                ((ObjectNode)container).set(property, node);
                break;
            }
            default: {
                throw new IllegalArgumentException(ptr + " does not identify a settable container");
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public JsonCache set(JsonPointer ptr, short value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(JsonPointer ptr, String value) {
        return this.set(ptr, (Object)value);
    }

    @Override
    public JsonCache set(String path, BigDecimal value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, BigInteger value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, boolean value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, double value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, float value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, int value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, List<?> values) throws JsonCache.CacheException {
        return this.set(JsonPointer.compile((String)path), values);
    }

    @Override
    public JsonCache set(String path, long value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, Object value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, short value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    @Override
    public JsonCache set(String path, String value) {
        return this.set(JsonPointer.compile((String)path), value);
    }

    protected void setDirty() {
        this.isDirty = true;
        this.isLoaded = true;
    }

    @Override
    public int size(JsonPointer ptr) {
        return this.root == null ? 0 : this.root.at(ptr).size();
    }

    @Override
    public int size(String path) {
        return this.size(JsonPointer.compile((String)path));
    }

    public String toString() {
        return "JsonCacheImpl [root=" + this.root + ']';
    }

    @Override
    public JsonCache.Root unload() {
        this.isLoaded = false;
        this.isDirty = false;
        this.root = null;
        return this;
    }

    static class FactoryImpl
    implements JsonCache.Factory {
        static final JsonCache.Factory instance = new FactoryImpl();
        private final Map<String, JsonCacheImpl> instances = new HashMap<String, JsonCacheImpl>();

        FactoryImpl() {
        }

        @Override
        public JsonCache.Root create() {
            return new JsonCacheImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JsonCache.Root get(String key) {
            Map<String, JsonCacheImpl> map = this.instances;
            synchronized (map) {
                JsonCacheImpl instance = this.instances.get(key);
                if (instance == null) {
                    instance = new JsonCacheImpl();
                    this.instances.put(key, instance);
                }
                return instance;
            }
        }
    }

    private static class ChildCacheImpl
    implements JsonCache {
        private final JsonPointer basePtr;
        private final JsonCache parent;

        private ChildCacheImpl(JsonCache parent, JsonPointer basePtr) {
            this.parent = parent;
            this.basePtr = basePtr;
        }

        @Override
        public JsonCache add(JsonPointer ptr, BigDecimal value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, BigInteger value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, boolean value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, double value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, float value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, int value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, long value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, Object value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(JsonPointer ptr, short value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache add(String path, BigDecimal value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, BigInteger value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, boolean value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, double value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, float value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, int value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, long value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, Object value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache add(String path, short value) throws JsonCache.CacheException {
            this.parent.add(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache child(JsonPointer basePtr) {
            return new ChildCacheImpl(this, basePtr);
        }

        @Override
        public JsonCache child(String path) {
            return this.child(JsonPointer.compile((String)path));
        }

        @Override
        public void delete(JsonPointer ptr) throws JsonCache.CacheException {
            this.parent.delete(this.basePtr.append(ptr));
        }

        @Override
        public void delete(String path) throws JsonCache.CacheException {
            this.parent.delete(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public boolean exists(JsonPointer ptr) {
            return this.parent.exists(this.basePtr.append(ptr));
        }

        @Override
        public boolean exists(String path) {
            return this.parent.exists(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public Object get(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.get(this.basePtr.append(ptr));
        }

        @Override
        public Object get(JsonPointer ptr, Object defaultValue) throws JsonCache.CacheException {
            return this.parent.get(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public Object get(String path) throws JsonCache.CacheException {
            return this.parent.get(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public Object get(String path, Object defaultValue) throws JsonCache.CacheException {
            return this.parent.get(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public BigDecimal getBigDecimal(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getBigDecimal(this.basePtr.append(ptr));
        }

        @Override
        public BigDecimal getBigDecimal(JsonPointer ptr, BigDecimal defaultValue) throws JsonCache.CacheException {
            return this.parent.getBigDecimal(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public BigDecimal getBigDecimal(String path) throws JsonCache.CacheException {
            return this.parent.getBigDecimal(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public BigDecimal getBigDecimal(String path, BigDecimal defaultValue) throws JsonCache.CacheException {
            return this.parent.getBigDecimal(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public BigInteger getBigInteger(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getBigInteger(this.basePtr.append(ptr));
        }

        @Override
        public BigInteger getBigInteger(JsonPointer ptr, BigInteger defaultValue) throws JsonCache.CacheException {
            return this.parent.getBigInteger(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public BigInteger getBigInteger(String path) throws JsonCache.CacheException {
            return this.parent.getBigInteger(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public BigInteger getBigInteger(String path, BigInteger defaultValue) throws JsonCache.CacheException {
            return this.parent.getBigInteger(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public byte[] getBinary(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getBinary(this.basePtr.append(ptr));
        }

        @Override
        public byte[] getBinary(JsonPointer ptr, byte[] defaultValue) throws JsonCache.CacheException {
            return this.parent.getBinary(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public byte[] getBinary(String path) throws JsonCache.CacheException {
            return this.parent.getBinary(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public byte[] getBinary(String path, byte[] defaultValue) throws JsonCache.CacheException {
            return this.parent.getBinary(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public boolean getBoolean(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getBoolean(this.basePtr.append(ptr));
        }

        @Override
        public boolean getBoolean(JsonPointer ptr, boolean defaultValue) throws JsonCache.CacheException {
            return this.parent.getBoolean(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public boolean getBoolean(String path) throws JsonCache.CacheException {
            return this.parent.getBoolean(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public boolean getBoolean(String path, boolean defaultValue) throws JsonCache.CacheException {
            return this.parent.getBoolean(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public double getDouble(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getDouble(this.basePtr.append(ptr));
        }

        @Override
        public double getDouble(JsonPointer ptr, double defaultValue) throws JsonCache.CacheException {
            return this.parent.getDouble(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public double getDouble(String path) throws JsonCache.CacheException {
            return this.parent.getDouble(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public double getDouble(String path, double defaultValue) throws JsonCache.CacheException {
            return this.parent.getDouble(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public float getFloat(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getFloat(this.basePtr.append(ptr));
        }

        @Override
        public float getFloat(JsonPointer ptr, float defaultValue) throws JsonCache.CacheException {
            return this.parent.getFloat(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public float getFloat(String path) throws JsonCache.CacheException {
            return this.parent.getFloat(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public float getFloat(String path, float defaultValue) throws JsonCache.CacheException {
            return this.parent.getFloat(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public int getInt(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getInt(this.basePtr.append(ptr));
        }

        @Override
        public int getInt(JsonPointer ptr, int defaultValue) throws JsonCache.CacheException {
            return this.parent.getInt(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public int getInt(String path) throws JsonCache.CacheException {
            return this.parent.getInt(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public int getInt(String path, int defaultValue) throws JsonCache.CacheException {
            return this.parent.getInt(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public long getLong(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getLong(this.basePtr.append(ptr));
        }

        @Override
        public long getLong(JsonPointer ptr, long defaultValue) throws JsonCache.CacheException {
            return this.parent.getLong(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public long getLong(String path) throws JsonCache.CacheException {
            return this.parent.getLong(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public long getLong(String path, long defaultValue) throws JsonCache.CacheException {
            return this.parent.getLong(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public JsonNodeType getNodeType(JsonPointer ptr) {
            return this.parent.getNodeType(this.basePtr.append(ptr));
        }

        @Override
        public JsonNodeType getNodeType(String path) {
            return this.parent.getNodeType(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public Number getNumber(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getNumber(this.basePtr.append(ptr));
        }

        @Override
        public Number getNumber(JsonPointer ptr, Number defaultValue) throws JsonCache.CacheException {
            return this.parent.getNumber(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public Number getNumber(String path) throws JsonCache.CacheException {
            return this.parent.getNumber(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public Number getNumber(String path, Number defaultValue) throws JsonCache.CacheException {
            return this.parent.getNumber(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public <T> T getObject(JsonPointer ptr, Class<T> type) throws JsonCache.CacheException {
            return (T)this.parent.getObject(this.basePtr.append(ptr), type);
        }

        @Override
        public <T> T getObject(JsonPointer ptr, T defaultValue) throws JsonCache.CacheException {
            return this.parent.getObject(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public <T> T getObject(String path, Class<T> type) throws JsonCache.CacheException {
            return (T)this.parent.getObject(this.basePtr.append(JsonPointer.compile((String)path)), type);
        }

        @Override
        public <T> T getObject(String path, T defaultValue) throws JsonCache.CacheException {
            return this.parent.getObject(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public <T> List<T> getObjects(JsonPointer ptr, Class<T> type) throws JsonCache.CacheException {
            return this.parent.getObjects(this.basePtr.append(ptr), type);
        }

        @Override
        public <T> List<T> getObjects(JsonPointer ptr, Class<T> type, List<T> defaultValue) throws JsonCache.CacheException {
            return this.parent.getObjects(this.basePtr.append(ptr), type, defaultValue);
        }

        @Override
        public <T> List<T> getObjects(String path, Class<T> type) throws JsonCache.CacheException {
            return this.parent.getObjects(this.basePtr.append(JsonPointer.compile((String)path)), type);
        }

        @Override
        public <T> List<T> getObjects(String path, Class<T> type, List<T> defaultValue) throws JsonCache.CacheException {
            return this.parent.getObjects(this.basePtr.append(JsonPointer.compile((String)path)), type, defaultValue);
        }

        @Override
        public short getShort(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getShort(this.basePtr.append(ptr));
        }

        @Override
        public short getShort(JsonPointer ptr, short defaultValue) throws JsonCache.CacheException {
            return this.parent.getShort(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public short getShort(String path) throws JsonCache.CacheException {
            return this.parent.getShort(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public short getShort(String path, short defaultValue) throws JsonCache.CacheException {
            return this.parent.getShort(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public String getString(JsonPointer ptr) throws JsonCache.CacheException {
            return this.parent.getString(this.basePtr.append(ptr));
        }

        @Override
        public String getString(JsonPointer ptr, String defaultValue) throws JsonCache.CacheException {
            return this.parent.getString(this.basePtr.append(ptr), defaultValue);
        }

        @Override
        public String getString(String path) throws JsonCache.CacheException {
            return this.parent.getString(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        @Override
        public String getString(String path, String defaultValue) throws JsonCache.CacheException {
            return this.parent.getString(this.basePtr.append(JsonPointer.compile((String)path)), defaultValue);
        }

        @Override
        public JsonCache parent() {
            return this.parent;
        }

        @Override
        public JsonCache.Root root() {
            return this.parent.root();
        }

        @Override
        public JsonCache set(JsonPointer ptr, BigDecimal value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, BigInteger value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, boolean value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, double value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, float value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, int value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, List<?> values) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), values);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, long value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, Object value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, short value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(JsonPointer ptr, String value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(ptr), value);
            return this;
        }

        @Override
        public JsonCache set(String path, BigDecimal value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, BigInteger value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, boolean value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, double value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, float value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, int value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, List<?> values) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), values);
            return this;
        }

        @Override
        public JsonCache set(String path, long value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, Object value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, short value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public JsonCache set(String path, String value) throws JsonCache.CacheException {
            this.parent.set(this.basePtr.append(JsonPointer.compile((String)path)), value);
            return this;
        }

        @Override
        public int size(JsonPointer ptr) {
            return this.parent.size(this.basePtr.append(ptr));
        }

        @Override
        public int size(String path) {
            return this.parent.size(this.basePtr.append(JsonPointer.compile((String)path)));
        }

        public String toString() {
            JsonNode node;
            try {
                node = (JsonNode)this.getObject(EMPTY_PTR, (Object)JsonNode.class);
            }
            catch (JsonCache.CacheException e) {
                LOGGER.error("", (Throwable)e);
                node = null;
            }
            return "ChildCacheImpl [basePtr=" + this.basePtr + ", node=" + node + ']';
        }
    }
}

