/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRustCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractRustCodegen.class);
    protected List<String> charactersToAllow = Collections.singletonList("_");
    protected Set<String> keywordsThatDoNotSupportRawIdentifiers = new HashSet<String>(Arrays.asList("super", "self", "Self", "extern", "crate"));
    protected String enumSuffix = "";

    public AbstractRustCodegen() {
        this.reservedWords = new HashSet<String>(Arrays.asList("as", "break", "const", "continue", "crate", "else", "enum", "extern", "false", "fn", "for", "if", "impl", "in", "let", "loop", "match", "mod", "move", "mut", "pub", "ref", "return", "self", "Self", "static", "struct", "super", "trait", "true", "type", "unsafe", "use", "where", "while", "async", "await", "dyn", "abstract", "become", "box", "do", "final", "macro", "override", "priv", "typeof", "unsized", "virtual", "yield", "try"));
    }

    @Override
    public boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    public String sanitizeIdentifier(String name, CasingType casingType, String escapePrefix, String type, boolean allowRawIdentifiers) {
        Function<String, String> casingFunction;
        String originalName = name;
        switch (casingType) {
            case CAMEL_CASE: {
                casingFunction = input -> org.openapitools.codegen.utils.StringUtils.camelize(org.openapitools.codegen.utils.StringUtils.underscore(input));
                break;
            }
            case SNAKE_CASE: {
                casingFunction = org.openapitools.codegen.utils.StringUtils::underscore;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CasingType");
            }
        }
        name = name.replaceAll("-", "_");
        if (!Strings.isNullOrEmpty((String)name)) {
            boolean endedWithUnderscore = name.endsWith("_");
            name = org.openapitools.codegen.utils.StringUtils.escape(name, this.specialCharReplacements, this.charactersToAllow, "_");
            if (!endedWithUnderscore && name.endsWith("_")) {
                name = StringUtils.chop((String)name);
            }
        }
        boolean nameWasModified = !originalName.equals(name = this.sanitizeName(name));
        if ((name = casingFunction.apply(name)).matches("^\\d.*")) {
            nameWasModified = true;
            name = casingFunction.apply(escapePrefix + '_' + name);
        }
        if (this.isReservedWord(name)) {
            nameWasModified = true;
            name = this.keywordsThatDoNotSupportRawIdentifiers.contains(name) || !allowRawIdentifiers ? casingFunction.apply(escapePrefix + '_' + name) : "r#" + name;
        }
        if (nameWasModified) {
            this.LOGGER.warn("{} cannot be used as a {} name. Renamed to {}", new Object[]{casingFunction.apply(originalName), type, name});
        }
        return name;
    }

    @Override
    public String toVarName(String name) {
        return this.sanitizeIdentifier(name, CasingType.SNAKE_CASE, "param", "field/variable", true);
    }

    @Override
    public String toParamName(String name) {
        return this.sanitizeIdentifier(name, CasingType.SNAKE_CASE, "param", "parameter", true);
    }

    @Override
    public String toOperationId(String operationId) {
        return this.sanitizeIdentifier(operationId, CasingType.SNAKE_CASE, "call", "method", true);
    }

    protected String addModelNamePrefixAndSuffix(String name) {
        if (!Strings.isNullOrEmpty((String)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!Strings.isNullOrEmpty((String)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        return this.sanitizeIdentifier(this.addModelNamePrefixAndSuffix(name), CasingType.CAMEL_CASE, "model", "model", false);
    }

    @Override
    public String toModelFilename(String name) {
        return this.sanitizeIdentifier(this.addModelNamePrefixAndSuffix(name), CasingType.SNAKE_CASE, "model", "model file", false);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (Strings.isNullOrEmpty((String)name)) {
            return "Empty";
        }
        return this.sanitizeIdentifier(name, CasingType.CAMEL_CASE, "variant", "enum variant", true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String name = property.name;
        if (!Strings.isNullOrEmpty((String)this.enumSuffix)) {
            name = name + "_" + this.enumSuffix;
        }
        return this.sanitizeIdentifier(name, CasingType.CAMEL_CASE, "enum", "enum", false);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return this.toEnumVarName(value, datatype);
    }

    protected String addApiNamePrefixAndSuffix(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = "default";
        }
        if (!Strings.isNullOrEmpty((String)this.apiNamePrefix)) {
            name = this.apiNamePrefix + "_" + name;
        }
        if (!Strings.isNullOrEmpty((String)this.apiNameSuffix)) {
            name = name + "_" + this.apiNameSuffix;
        }
        return name;
    }

    @Override
    public String toApiName(String name) {
        return this.sanitizeIdentifier(this.addApiNamePrefixAndSuffix(name), CasingType.CAMEL_CASE, "api", "API", false);
    }

    @Override
    public String toApiFilename(String name) {
        return this.sanitizeIdentifier(this.addApiNamePrefixAndSuffix(name), CasingType.SNAKE_CASE, "api", "API file", false);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    public static enum CasingType {
        CAMEL_CASE,
        SNAKE_CASE;

    }
}

