/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinServerCodegen
extends AbstractKotlinCodegen
implements BeanValidationFeatures {
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String USE_COROUTINES = "useCoroutines";
    public static final String RETURN_RESPONSE = "returnResponse";
    public static final String DEFAULT_LIBRARY = "ktor";
    private final Logger LOGGER = LoggerFactory.getLogger(KotlinServerCodegen.class);
    private Boolean autoHeadFeatureEnabled = true;
    private Boolean conditionalHeadersFeatureEnabled = false;
    private Boolean hstsFeatureEnabled = true;
    private Boolean corsFeatureEnabled = false;
    private Boolean compressionFeatureEnabled = true;
    private Boolean locationsFeatureEnabled = true;
    private Boolean metricsFeatureEnabled = true;
    private boolean interfaceOnly = false;
    private boolean useBeanValidation = false;
    private boolean useCoroutines = false;
    private boolean returnResponse = false;
    private Map<String, List<String>> optionsSupportedPerFramework = new ImmutableMap.Builder().put((Object)"ktor", Arrays.asList("featureAutoHead", "featureConditionalHeaders", "featureHSTS", "featureCORS", "featureCompression", "featureLocations", "featureMetrics")).build();

    public KotlinServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.artifactId = "kotlin-server";
        this.packageName = "org.openapitools.server";
        this.typeMapping.put("array", "kotlin.collections.List");
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-server";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.templateDir = "kotlin-server";
        this.embeddedTemplateDir = "kotlin-server";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ktor framework");
        this.supportedLibraries.put("jaxrs-spec", "JAX-RS spec only");
        CliOption library = new CliOption("library", "library template (sub-template)");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
        this.addSwitch("featureAutoHead", "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.", this.getAutoHeadFeatureEnabled());
        this.addSwitch("featureConditionalHeaders", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getConditionalHeadersFeatureEnabled());
        this.addSwitch("featureHSTS", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getHstsFeatureEnabled());
        this.addSwitch("featureCORS", "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.", this.getCorsFeatureEnabled());
        this.addSwitch("featureCompression", "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.", this.getCompressionFeatureEnabled());
        this.addSwitch("featureLocations", "Generates routes in a typed way, for both: constructing URLs and reading the parameters.", this.getLocationsFeatureEnabled());
        this.addSwitch("featureMetrics", "Enables metrics feature.", this.getMetricsFeatureEnabled());
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files. This option is currently supported only when using jaxrs-spec library.").defaultValue(String.valueOf(this.interfaceOnly)));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations. This option is currently supported only when using jaxrs-spec library.", this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean(USE_COROUTINES, "Whether to use the Coroutines. This option is currently supported only when using jaxrs-spec library."));
        this.cliOptions.add(CliOption.newBoolean(RETURN_RESPONSE, "Whether generate API interface should return javax.ws.rs.core.Response instead of a deserialized entity. Only useful if interfaceOnly is true. This option is currently supported only when using jaxrs-spec library.").defaultValue(String.valueOf(this.returnResponse)));
    }

    public Boolean getAutoHeadFeatureEnabled() {
        return this.autoHeadFeatureEnabled;
    }

    public void setAutoHeadFeatureEnabled(Boolean autoHeadFeatureEnabled) {
        this.autoHeadFeatureEnabled = autoHeadFeatureEnabled;
    }

    public Boolean getCompressionFeatureEnabled() {
        return this.compressionFeatureEnabled;
    }

    public void setCompressionFeatureEnabled(Boolean compressionFeatureEnabled) {
        this.compressionFeatureEnabled = compressionFeatureEnabled;
    }

    public Boolean getConditionalHeadersFeatureEnabled() {
        return this.conditionalHeadersFeatureEnabled;
    }

    public void setConditionalHeadersFeatureEnabled(Boolean conditionalHeadersFeatureEnabled) {
        this.conditionalHeadersFeatureEnabled = conditionalHeadersFeatureEnabled;
    }

    public Boolean getCorsFeatureEnabled() {
        return this.corsFeatureEnabled;
    }

    public void setCorsFeatureEnabled(Boolean corsFeatureEnabled) {
        this.corsFeatureEnabled = corsFeatureEnabled;
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin server.";
    }

    public Boolean getHstsFeatureEnabled() {
        return this.hstsFeatureEnabled;
    }

    public void setHstsFeatureEnabled(Boolean hstsFeatureEnabled) {
        this.hstsFeatureEnabled = hstsFeatureEnabled;
    }

    public Boolean getLocationsFeatureEnabled() {
        return this.locationsFeatureEnabled;
    }

    public void setLocationsFeatureEnabled(Boolean locationsFeatureEnabled) {
        this.locationsFeatureEnabled = locationsFeatureEnabled;
    }

    public Boolean getMetricsFeatureEnabled() {
        return this.metricsFeatureEnabled;
    }

    public void setMetricsFeatureEnabled(Boolean metricsEnabled) {
        this.metricsFeatureEnabled = metricsEnabled;
    }

    @Override
    public String getName() {
        return "kotlin-server";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.isModelMutable()) {
            this.typeMapping.put("array", "kotlin.collections.MutableList");
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.interfaceOnly = Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString());
            if (!this.interfaceOnly) {
                this.additionalProperties.remove(INTERFACE_ONLY);
            }
        }
        if (this.additionalProperties.containsKey(USE_COROUTINES)) {
            this.useCoroutines = Boolean.parseBoolean(this.additionalProperties.get(USE_COROUTINES).toString());
            if (!this.useCoroutines) {
                this.additionalProperties.remove(USE_COROUTINES);
            }
        }
        if (this.additionalProperties.containsKey(RETURN_RESPONSE)) {
            this.returnResponse = Boolean.parseBoolean(this.additionalProperties.get(RETURN_RESPONSE).toString());
            if (!this.returnResponse) {
                this.additionalProperties.remove(RETURN_RESPONSE);
            }
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary(DEFAULT_LIBRARY);
            this.additionalProperties.put("library", DEFAULT_LIBRARY);
            this.LOGGER.info("`library` option is empty. Default to {}", (Object)DEFAULT_LIBRARY);
        }
        if (this.additionalProperties.containsKey("featureAutoHead")) {
            this.setAutoHeadFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureAutoHead"));
        } else {
            this.additionalProperties.put("featureAutoHead", this.getAutoHeadFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureConditionalHeaders")) {
            this.setConditionalHeadersFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureConditionalHeaders"));
        } else {
            this.additionalProperties.put("featureConditionalHeaders", this.getConditionalHeadersFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureHSTS")) {
            this.setHstsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureHSTS"));
        } else {
            this.additionalProperties.put("featureHSTS", this.getHstsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setCorsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.getCorsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCompression")) {
            this.setCompressionFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCompression"));
        } else {
            this.additionalProperties.put("featureCompression", this.getCompressionFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureLocations")) {
            this.setLocationsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureLocations"));
        } else {
            this.additionalProperties.put("featureLocations", this.getLocationsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureMetrics")) {
            this.setMetricsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureMetrics"));
        } else {
            this.additionalProperties.put("featureMetrics", this.getMetricsFeatureEnabled());
        }
        boolean generateApis = this.additionalProperties.containsKey("generateApis") && (Boolean)this.additionalProperties.get("generateApis") != false;
        String packageFolder = (this.sourceFolder + File.separator + this.packageName).replace(".", File.separator);
        String resourcesFolder = "src/main/resources";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.library.equals(DEFAULT_LIBRARY)) {
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        }
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("gradle.properties", "", "gradle.properties"));
        if (this.library.equals(DEFAULT_LIBRARY)) {
            this.supportingFiles.add(new SupportingFile("AppMain.kt.mustache", packageFolder, "AppMain.kt"));
            this.supportingFiles.add(new SupportingFile("Configuration.kt.mustache", packageFolder, "Configuration.kt"));
            if (generateApis && this.locationsFeatureEnabled.booleanValue()) {
                this.supportingFiles.add(new SupportingFile("Paths.kt.mustache", packageFolder, "Paths.kt"));
            }
            this.supportingFiles.add(new SupportingFile("application.conf.mustache", resourcesFolder, "application.conf"));
            this.supportingFiles.add(new SupportingFile("logback.xml", resourcesFolder, "logback.xml"));
            String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", File.separator);
            this.supportingFiles.add(new SupportingFile("ApiKeyAuth.kt.mustache", infrastructureFolder, "ApiKeyAuth.kt"));
        }
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f     #");
        System.out.println("################################################################################");
    }

    public static class Constants {
        public static final String KTOR = "ktor";
        public static final String JAXRS_SPEC = "jaxrs-spec";
        public static final String AUTOMATIC_HEAD_REQUESTS = "featureAutoHead";
        public static final String AUTOMATIC_HEAD_REQUESTS_DESC = "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.";
        public static final String CONDITIONAL_HEADERS = "featureConditionalHeaders";
        public static final String CONDITIONAL_HEADERS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String HSTS = "featureHSTS";
        public static final String HSTS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String CORS = "featureCORS";
        public static final String CORS_DESC = "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.";
        public static final String COMPRESSION = "featureCompression";
        public static final String COMPRESSION_DESC = "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.";
        public static final String LOCATIONS = "featureLocations";
        public static final String LOCATIONS_DESC = "Generates routes in a typed way, for both: constructing URLs and reading the parameters.";
        public static final String METRICS = "featureMetrics";
        public static final String METRICS_DESC = "Enables metrics feature.";
    }
}

