/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.mifmif.common.regex.Generex;
import io.swagger.v3.oas.models.media.Schema;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.JavaCXFServerCodegen;
import org.openapitools.codegen.languages.features.CXFExtServerFeatures;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.JsonCache;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCXFExtServerCodegen
extends JavaCXFServerCodegen
implements CXFExtServerFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(JavaCXFExtServerCodegen.class);
    private static final String INDENT = "        ";
    private static final ThreadLocal<SimpleDateFormat> ISO8601_DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    });
    private static final ThreadLocal<SimpleDateFormat> ISO8601_DATETIME_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.getDefault());
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    });
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long MIN_DATE;
    private static final long MAX_DATE;
    private static final String NL;
    private static final Collection<String> DATE_TYPES;
    private final Map<String, Generex> REGEX_GENERATORS = new HashMap<String, Generex>();
    protected boolean generateOperationBody = false;
    protected boolean loadTestDataFromFile = false;
    protected boolean supportMultipleSpringServices = false;
    protected JsonCache testDataCache = null;
    protected JsonCache testDataControlCache = null;
    protected File testDataFile = null;
    protected File testDataControlFile = null;

    public JavaCXFExtServerCodegen() {
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "cxf-ext";
        this.cliOptions.add(CliOption.newBoolean("supportMultipleSpringServices", "Support generation of Spring services from multiple specifications"));
        this.cliOptions.add(CliOption.newBoolean("generateOperationBody", "Generate fully functional operation bodies"));
        this.cliOptions.add(CliOption.newBoolean("loadTestDataFromFile", "Load test data from a generated JSON file"));
        this.cliOptions.add(CliOption.newString("testDataFile", "JSON file to contain generated test data"));
        this.cliOptions.add(CliOption.newString("testDataControlFile", "JSON file to control test data generation"));
    }

    private void appendArrayValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        if (var.dataType.equals("byte[]")) {
            this.appendByteArrayValue(buffer, indent, op, var, localVar, localVars, models);
        } else {
            boolean isPrimitiveType = var.isPrimitiveType && !"Object".equals(var.items.dataType);
            int itemCount = Math.max(var.itemCount, var.minItems == null ? 1 : Math.max(1, var.minItems));
            if (!this.loadTestDataFromFile) {
                buffer.append("new ").append(var.getComponentType());
                if (isPrimitiveType) {
                    buffer.append("[] {");
                } else {
                    buffer.append('[').append(itemCount).append("];");
                }
            }
            for (int i = var.index = var.size(); i < itemCount; ++i) {
                if (isPrimitiveType) {
                    this.appendValue(buffer, indent, op, var.items, localVar, localVars, models);
                    if (i < itemCount - 1 && !this.loadTestDataFromFile) {
                        buffer.append(", ");
                    }
                } else {
                    String itemVar = this.appendLocalVariable(buffer, indent, op, var.items, localVars, models);
                    if (!this.loadTestDataFromFile) {
                        buffer.append(NL).append(indent).append(localVar).append('[').append(i).append("] = ").append(itemVar).append(';');
                    }
                }
                ++var.index;
            }
            var.index = 0;
            if (isPrimitiveType && !this.loadTestDataFromFile) {
                buffer.append("};");
            }
        }
    }

    private void appendByteArrayValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        if (!this.loadTestDataFromFile) {
            buffer.append('\"');
        }
        int min = (short)(var == null || var.minimum == null ? -128 : (short)Byte.parseByte(var.minimum));
        int max = (short)(var == null || var.maximum == null ? 127 : (short)Byte.parseByte(var.maximum));
        short exclusiveMin = (short)(var != null && var.exclusiveMinimum ? 1 : 0);
        short inclusiveMax = (short)(var == null || !var.exclusiveMaximum ? 1 : 0);
        int itemCount = 0;
        if (var != null) {
            itemCount = Math.max(var.itemCount, var.minItems == null ? 1 : Math.max(1, var.minItems));
        }
        byte[] randomBytes = new byte[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            randomBytes[i] = (byte)((double)(min + exclusiveMin) + (double)(max + inclusiveMax - min - exclusiveMin) * Math.random());
        }
        String randomBytesBase64 = Base64.getEncoder().encodeToString(randomBytes);
        if (this.loadTestDataFromFile && var != null) {
            var.addTestData(randomBytesBase64);
        } else {
            buffer.append('\"');
        }
    }

    private void appendListValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        op.imports.add("List");
        if (!this.loadTestDataFromFile) {
            op.imports.add("ArrayList");
            buffer.append("new ArrayList<");
            if (this.supportJava6) {
                buffer.append(var.dataType);
            }
            buffer.append(">();");
        }
        var.index = var.size();
        int itemCount = Math.max(var.itemCount, var.minItems == null ? 1 : Math.max(1, var.minItems));
        for (int i = var.index; i < itemCount; ++i) {
            if (var.isPrimitiveType && !"Object".equals(var.items.dataType)) {
                if (!this.loadTestDataFromFile) {
                    buffer.append(NL).append(indent).append(localVar).append(".add(");
                }
                this.appendValue(buffer, indent, op, var.items, localVar, localVars, models);
            } else {
                String itemVar = this.appendLocalVariable(buffer, indent, op, var.items, localVars, models);
                if (!this.loadTestDataFromFile) {
                    buffer.append(NL).append(indent).append(localVar).append(".add(").append(itemVar);
                }
            }
            if (!this.loadTestDataFromFile) {
                buffer.append(");");
            }
            ++var.index;
        }
        var.index = 0;
    }

    private String appendLocalVariable(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, Collection<String> localVars, Map<String, CodegenModel> models) {
        Object localVar = var.name;
        int i = 2;
        while (localVars.contains(localVar)) {
            localVar = var.name + i;
            ++i;
        }
        localVars.add((String)localVar);
        if (!this.loadTestDataFromFile) {
            buffer.append(NL).append(indent).append(var.dataType).append(' ').append((String)localVar).append(" = ");
        }
        this.appendValue(buffer, indent, op, var, (String)localVar, localVars, models);
        if (!this.loadTestDataFromFile) {
            this.appendSemicolon(buffer);
        }
        return localVar;
    }

    private void appendMapValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        op.imports.add("Map");
        if (!this.loadTestDataFromFile) {
            op.imports.add("HashMap");
            buffer.append("new HashMap<");
            if (this.supportJava6) {
                buffer.append("String, ").append(var.dataType);
            }
            buffer.append(">();");
        }
        var.index = var.size();
        int itemCount = Math.max(var.itemCount, var.minItems == null ? 1 : Math.max(1, var.minItems));
        for (int i = var.index; i < itemCount; ++i) {
            var.items.name = this.generateRandomString(null);
            if (var.isPrimitiveType) {
                if (!this.loadTestDataFromFile) {
                    buffer.append(NL).append(indent).append(localVar).append(".put(").append(var.items.name).append(", ");
                }
                this.appendValue(buffer, indent, op, var.items, localVar, localVars, models);
            } else {
                String itemVar = this.appendLocalVariable(buffer, indent, op, var.items, localVars, models);
                if (!this.loadTestDataFromFile) {
                    buffer.append(localVar).append(".put(\"").append(var.items.name).append("\", ").append(itemVar);
                }
            }
            if (!this.loadTestDataFromFile) {
                buffer.append(");");
            }
            ++var.index;
        }
    }

    private void appendObjectValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        if ("Object".equals(var.dataType)) {
            if (this.loadTestDataFromFile) {
                var.addTestData(JsonNodeFactory.instance.objectNode());
            } else {
                buffer.append("JsonNodeFactory.instance.objectNode();");
            }
        } else {
            if (this.needToImport(var.dataType)) {
                op.imports.add(var.dataType);
            }
            if (!this.loadTestDataFromFile) {
                buffer.append("new ").append(var.dataType).append("();");
            }
            this.appendPropertyAssignments(buffer, indent, op, var, localVar, localVars, models);
        }
    }

    private void appendPropertyAssignments(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable parent, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        CodegenModel cm = models.get(parent.dataType);
        if (cm != null) {
            for (CodegenProperty cp : cm.allVars) {
                CodegenVariable var = new CodegenVariable(parent, cp, null, models);
                if (var.isContainer || !var.isPrimitiveType) {
                    String containerVar = this.appendLocalVariable(buffer, indent, op, var, localVars, models);
                    if (!this.loadTestDataFromFile) {
                        buffer.append(NL).append(indent).append(localVar).append('.').append(var.setter).append('(').append(containerVar);
                    }
                } else {
                    if (!this.loadTestDataFromFile) {
                        buffer.append(NL).append(indent).append(localVar).append('.').append(var.setter).append('(');
                    }
                    this.appendValue(buffer, indent, op, var, localVar, localVars, models);
                }
                if (this.loadTestDataFromFile) continue;
                buffer.append(");");
            }
        }
    }

    private void appendRandomBoolean(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        boolean randomBoolean;
        boolean bl = randomBoolean = Math.random() > 0.5;
        if (this.loadTestDataFromFile) {
            var.addTestData(randomBoolean);
        } else {
            buffer.append(randomBoolean);
        }
    }

    private void appendRandomByte(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            int min = (short)(var == null || var.minimum == null ? -128 : (short)Byte.parseByte(var.minimum));
            int max = (short)(var == null || var.maximum == null ? 127 : (short)Byte.parseByte(var.maximum));
            short exclusiveMin = (short)(var != null && var.exclusiveMinimum ? 1 : 0);
            short inclusiveMax = (short)(var == null || !var.exclusiveMaximum ? 1 : 0);
            byte randomByte = (byte)((double)(min + exclusiveMin) + (double)(max + inclusiveMax - min - exclusiveMin) * Math.random());
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomByte);
                }
            } else {
                buffer.append(String.format(Locale.getDefault(), "(byte)%0#2x", randomByte));
            }
        }
    }

    private void appendRandomChar(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            int min = var == null || var.minimum == null ? 97 : (int)var.minimum.charAt(0);
            int max = var == null || var.maximum == null ? 122 : (int)var.maximum.charAt(0);
            char exclusiveMin = (char)(var != null && var.exclusiveMinimum ? 1 : 0);
            char inclusiveMax = (char)(var == null || !var.exclusiveMaximum ? 1 : 0);
            char randomChar = (char)((double)(min + exclusiveMin) + (double)(max + inclusiveMax - min - exclusiveMin) * Math.random());
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(Character.valueOf(randomChar));
                }
            } else {
                buffer.append(String.format(Locale.getDefault(), "'%c'", Character.valueOf(randomChar)));
            }
        }
    }

    private void appendRandomDate(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            long minDate = MIN_DATE;
            long maxDate = MAX_DATE;
            if (var != null) {
                String isoFormat;
                DateFormat df = var.dataFormat.equals("date-time") ? (DateFormat)ISO8601_DATETIME_FORMAT.get() : (DateFormat)ISO8601_DATE_FORMAT.get();
                String string = isoFormat = var.dataFormat.equals("date-time") ? "date-time" : "full-date";
                if (var.minimum != null) {
                    try {
                        minDate = df.parse(var.minimum).getTime();
                    }
                    catch (ParseException e) {
                        this.LOGGER.warn("Could not parse minimum {} value for '{}/{}' as an ISO-8601 {}: {}", new Object[]{var.dataFormat, op.operationId, var.name, isoFormat, var.minimum});
                    }
                }
                if (var.maximum != null) {
                    try {
                        maxDate = df.parse(var.maximum).getTime();
                    }
                    catch (ParseException e) {
                        this.LOGGER.warn("Could not parse maximum {} value for '{}/{}' as an ISO-8601 {}: {}", new Object[]{var.dataFormat, op.operationId, var.name, isoFormat, var.minimum});
                    }
                }
            }
            BigDecimal minLong = new BigDecimal(minDate);
            BigDecimal maxLong = new BigDecimal(maxDate);
            BigDecimal exclusiveMinLong = new BigDecimal(var != null && var.exclusiveMinimum ? 1 : 0);
            BigDecimal inclusiveMaxLong = new BigDecimal(var == null || !var.exclusiveMaximum ? 1 : 0);
            long randomDateLong = minLong.add(exclusiveMinLong).add(maxLong.add(inclusiveMaxLong).subtract(minLong).subtract(exclusiveMinLong).multiply(BigDecimal.valueOf(Math.random()))).longValue();
            if (var != null && "date".equals(var.dataFormat)) {
                randomDateLong = randomDateLong % 86400000L * 86400000L;
            }
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    Date randomDate = new Date(randomDateLong);
                    switch (var.dataFormat) {
                        case "date": {
                            var.addTestData(ISO8601_DATE_FORMAT.get().format(randomDate));
                            break;
                        }
                        case "date-time": {
                            var.addTestData(ISO8601_DATETIME_FORMAT.get().format(randomDate));
                        }
                    }
                }
            } else {
                buffer.append("new Date(").append(randomDateLong).append(')');
            }
        }
    }

    private void appendRandomDouble(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            BigDecimal min = BigDecimal.valueOf(var == null || var.minimum == null ? -9.223372036854776E18 : Double.parseDouble(var.minimum));
            BigDecimal max = BigDecimal.valueOf(var == null || var.maximum == null ? 9.223372036854776E18 : Double.parseDouble(var.maximum));
            BigDecimal exclusiveMin = new BigDecimal(var != null && var.exclusiveMinimum ? 1 : 0);
            BigDecimal inclusiveMax = new BigDecimal(var == null || !var.exclusiveMaximum ? 1 : 0);
            BigDecimal randomBigDecimal = min.add(exclusiveMin).add(max.add(inclusiveMax).subtract(min).subtract(exclusiveMin).multiply(new BigDecimal(String.valueOf(Math.random()))));
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomBigDecimal);
                }
            } else {
                buffer.append(randomBigDecimal).append('D');
            }
        }
    }

    private boolean appendRandomEnum(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (var != null && var.allowableValues != null) {
            List enumVars;
            List values = (List)var.allowableValues.get("values");
            int i = (int)((double)values.size() * Math.random());
            Object randomEnum = values.get(i);
            boolean usingEnumLiteral = false;
            String definingClass = (String)var.varVendorExtensions.get("x-defining-class");
            if (definingClass != null && (enumVars = (List)var.allowableValues.get("enumVars")) != null) {
                if (!this.loadTestDataFromFile) {
                    Map randomEnumVar = (Map)enumVars.get(i);
                    buffer.append(definingClass).append('.').append(var.enumName).append('.').append(randomEnumVar.get("name"));
                    op.imports.add(definingClass);
                }
                usingEnumLiteral = true;
            }
            if (this.loadTestDataFromFile) {
                var.addTestData(randomEnum);
            } else if (!usingEnumLiteral) {
                String quoteString = randomEnum instanceof String ? "\"" : "";
                buffer.append(quoteString).append(randomEnum).append(quoteString);
            }
            return true;
        }
        return false;
    }

    private void appendRandomFile(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        String randomString = this.generateRandomString(var);
        if (this.loadTestDataFromFile) {
            var.addTestData(randomString);
        } else {
            buffer.append('\"').append(randomString).append('\"');
        }
    }

    private void appendRandomFloat(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            double min = var == null || var.minimum == null ? -3.4028234663852886E38 : (double)Float.parseFloat(var.minimum);
            double max = var == null || var.maximum == null ? 3.4028234663852886E38 : (double)Float.parseFloat(var.maximum);
            double exclusiveMin = var != null && var.exclusiveMinimum ? 1.0 : 0.0;
            double inclusiveMax = var == null || !var.exclusiveMaximum ? 1.0 : 0.0;
            float randomFloat = (float)(min + exclusiveMin + (max + inclusiveMax - min - exclusiveMin) * Math.random());
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(Float.valueOf(randomFloat));
                }
            } else {
                buffer.append(String.format(Locale.getDefault(), "%g", Float.valueOf(randomFloat))).append('F');
            }
        }
    }

    private void appendRandomInt(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            long min = var == null || var.minimum == null ? Integer.MIN_VALUE : (long)Integer.parseInt(var.minimum);
            long max = var == null || var.maximum == null ? Integer.MAX_VALUE : (long)Integer.parseInt(var.maximum);
            long exclusiveMin = var != null && var.exclusiveMinimum ? 1L : 0L;
            long inclusiveMax = var == null || !var.exclusiveMaximum ? 1L : 0L;
            int randomInt = (int)((double)(min + exclusiveMin) + (double)(max + inclusiveMax - min - exclusiveMin) * Math.random());
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomInt);
                }
            } else {
                buffer.append(randomInt);
            }
        }
    }

    private void appendRandomLong(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            BigDecimal min = new BigDecimal(var == null || var.minimum == null ? Long.MIN_VALUE : Long.parseLong(var.minimum));
            BigDecimal max = new BigDecimal(var == null || var.maximum == null ? Long.MAX_VALUE : Long.parseLong(var.maximum));
            BigDecimal exclusiveMin = new BigDecimal(var != null && var.exclusiveMinimum ? 1 : 0);
            BigDecimal inclusiveMax = new BigDecimal(var == null || !var.exclusiveMaximum ? 1 : 0);
            long randomLong = min.add(exclusiveMin).add(max.add(inclusiveMax).subtract(min).subtract(exclusiveMin).multiply(BigDecimal.valueOf(Math.random()))).longValue();
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomLong);
                }
            } else {
                buffer.append(randomLong).append('L');
            }
        }
    }

    private void appendRandomShort(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            int min = var == null || var.minimum == null ? Short.MIN_VALUE : (int)Short.parseShort(var.minimum);
            int max = var == null || var.maximum == null ? Short.MAX_VALUE : (int)Short.parseShort(var.maximum);
            int exclusiveMin = var != null && var.exclusiveMinimum ? 1 : 0;
            int inclusiveMax = var == null || !var.exclusiveMaximum ? 1 : 0;
            short randomShort = (short)((double)(min + exclusiveMin) + (double)(max + inclusiveMax - min - exclusiveMin) * Math.random());
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomShort);
                }
            } else {
                buffer.append(String.format(Locale.getDefault(), "(short)%d", randomShort));
            }
        }
    }

    private void appendRandomString(StringBuilder buffer, CodegenOperation op, CodegenVariable var) {
        if (!this.appendRandomEnum(buffer, op, var)) {
            String randomString = this.generateRandomString(var);
            if (this.loadTestDataFromFile) {
                if (var != null) {
                    var.addTestData(randomString);
                }
            } else {
                buffer.append('\"').append(randomString).append('\"');
            }
        }
    }

    private void appendScalarValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        if (!var.isPrimitiveType && !DATE_TYPES.contains(var.dataType) || var.dataType.equals("Object")) {
            this.appendObjectValue(buffer, indent, op, var, localVar, localVars, models);
        } else {
            this.openValueBuffer(buffer, var);
            int itemCount = Math.max(var.itemCount, var.minItems == null ? 1 : Math.max(1, var.minItems));
            for (int i = 0; i < itemCount; ++i) {
                switch (var.getComponentType()) {
                    case "byte": 
                    case "Byte": {
                        this.appendRandomByte(buffer, op, var);
                        break;
                    }
                    case "boolean": 
                    case "Boolean": {
                        this.appendRandomBoolean(buffer, op, var);
                        break;
                    }
                    case "char": 
                    case "Char": {
                        this.appendRandomChar(buffer, op, var);
                        break;
                    }
                    case "double": 
                    case "Double": {
                        this.appendRandomDouble(buffer, op, var);
                        break;
                    }
                    case "float": 
                    case "Float": {
                        this.appendRandomFloat(buffer, op, var);
                        break;
                    }
                    case "short": 
                    case "Short": {
                        this.appendRandomShort(buffer, op, var);
                        break;
                    }
                    case "int": 
                    case "Integer": {
                        this.appendRandomInt(buffer, op, var);
                        break;
                    }
                    case "long": 
                    case "Long": {
                        this.appendRandomLong(buffer, op, var);
                        break;
                    }
                    case "String": {
                        this.appendRandomString(buffer, op, var);
                        break;
                    }
                    case "Date": {
                        this.appendRandomDate(buffer, op, var);
                        break;
                    }
                    case "File": {
                        this.appendRandomFile(buffer, op, var);
                        break;
                    }
                    default: {
                        this.LOGGER.warn("Unrecognized component type '{}' in '{}' property for '{}'operation", new Object[]{var.getComponentType(), var.name, op.operationId});
                    }
                }
                if (this.loadTestDataFromFile || i >= itemCount - 1) continue;
                buffer.append(", ");
            }
            this.closeValueBuffer(buffer, var);
        }
    }

    private void appendSemicolon(StringBuilder buffer) {
        if (buffer.charAt(buffer.length() - 1) != ';') {
            buffer.append(';');
        }
    }

    private StringBuilder appendValue(StringBuilder buffer, String indent, CodegenOperation op, CodegenVariable var, String localVar, Collection<String> localVars, Map<String, CodegenModel> models) {
        if (var.isListContainer) {
            this.appendListValue(buffer, indent, op, var, localVar, localVars, models);
        } else if (var.isMap) {
            this.appendMapValue(buffer, indent, op, var, localVar, localVars, models);
        } else if (var.isArray) {
            this.appendArrayValue(buffer, indent, op, var, localVar, localVars, models);
        } else {
            this.appendScalarValue(buffer, indent, op, var, localVar, localVars, models);
        }
        return buffer;
    }

    private void applyDefaultContentTypes(CodegenOperation op) {
        if (op.bodyParam != null && !op.hasConsumes) {
            CodegenParameter bodyParam = op.bodyParam;
            String mediaType = bodyParam.isContainer || bodyParam.isModel || bodyParam.isFreeFormObject ? "application/json" : (bodyParam.isBinary || bodyParam.isFile ? "application/octet-stream" : "text/plain");
            HashMap<String, String> contentType = new HashMap<String, String>();
            contentType.put("mediaType", mediaType);
            if (op.consumes == null) {
                op.consumes = new ArrayList<Map<String, String>>();
            }
            op.consumes.add(contentType);
            op.hasConsumes = true;
        }
        if (!"void".equals(op.returnType) && !op.hasProduces) {
            String mediaType = op.returnContainer != null || !op.returnTypeIsPrimitive ? "application/json" : "text/plain";
            HashMap<String, String> contentType = new HashMap<String, String>();
            contentType.put("mediaType", mediaType);
            if (op.produces == null) {
                op.produces = new ArrayList<Map<String, String>>();
            }
            op.produces.add(contentType);
            op.hasProduces = true;
        }
    }

    private void closeValueBuffer(StringBuilder buffer, CodegenVariable var) {
        if (var.isArray && !this.loadTestDataFromFile) {
            buffer.append('}');
        }
    }

    private String generateRandomString(CodegenVariable var) {
        String pattern = this.patternFor(var);
        Generex generex = this.REGEX_GENERATORS.get(pattern);
        if (generex == null) {
            generex = new Generex(pattern);
            this.REGEX_GENERATORS.put(pattern, generex);
        }
        return generex.random();
    }

    private String getCacheMethod(CodegenVariable var) {
        String method;
        switch (var.dataType) {
            case "boolean": 
            case "Boolean": {
                method = "getBoolean";
                break;
            }
            case "BigDecimal": {
                method = "getBigDecimal";
                break;
            }
            case "BigInteger": {
                method = "getBigInteger";
                break;
            }
            case "byte[]": {
                method = "getBinary";
                break;
            }
            case "double": 
            case "Double": {
                method = "getDouble";
                break;
            }
            case "float": 
            case "Float": {
                method = "getFloat";
                break;
            }
            case "long": 
            case "Long": {
                method = "getLong";
                break;
            }
            case "int": 
            case "Integer": {
                method = "getInt";
                break;
            }
            case "String": {
                method = "getString";
                break;
            }
            default: {
                method = var.isListContainer ? "getObjects" : "getObject";
            }
        }
        return method;
    }

    @Override
    public String getName() {
        return "jaxrs-cxf-extended";
    }

    @Override
    public String getHelp() {
        return "Extends jaxrs-cxf with options to generate a functional mock server.";
    }

    private boolean hasCacheMethod(CodegenVariable var) {
        boolean hasCacheMethod;
        switch (var.dataType) {
            case "boolean": 
            case "Boolean": 
            case "BigDecimal": 
            case "BigInteger": 
            case "byte[]": 
            case "double": 
            case "Double": 
            case "float": 
            case "Float": 
            case "long": 
            case "Long": 
            case "int": 
            case "Integer": 
            case "String": {
                hasCacheMethod = true;
                break;
            }
            default: {
                hasCacheMethod = false;
            }
        }
        return hasCacheMethod;
    }

    private void openValueBuffer(StringBuilder buffer, CodegenVariable var) {
        if (var.isArray && !this.loadTestDataFromFile) {
            buffer.append("new ").append(var.dataType).append(" {");
        }
    }

    private String patternFor(CodegenVariable var) {
        Object pattern = null;
        if (var != null) {
            if (var.pattern != null) {
                pattern = StringEscapeUtils.unescapeJava((String)var.pattern);
            } else if (var.dataFormat != null) {
                switch (var.dataFormat) {
                    case "binary": {
                        pattern = "[0-9A-F]{2}{4,24}";
                        break;
                    }
                    case "byte": {
                        pattern = "[A-Za-z0-9+/]{4}{4,24}";
                        break;
                    }
                    case "date": {
                        pattern = "20\\d{2}-(?:(?:01|03|05|07|08|10|12)-(?:0[1-9]|[1-2][0-9]|3[0-1])|(?:04|06|09|11)-(?:0[1-9]|[1-2][0-9]|30)|02-(?:0[1-9]|1[0-9]|2[0-8]))";
                        break;
                    }
                    case "date-time": {
                        pattern = "20\\d{2}-(?:(?:01|03|05|07|08|10|12)-(?:0[1-9]|[1-2][0-9]|3[0-1])|(?:04|06|09|11)-(?:0[1-9]|[1-2][0-9]|30)|02-(?:0[1-9]|1[0-9]|2[0-8]))T(?:[0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](?:Z|(?:-0[1-9]|-1[0-2]|\\+0[0-9]|\\+1[0-4]):(?:00|30|45))";
                        break;
                    }
                    case "email": {
                        pattern = "[a-z][a-z0-9_.-]{1,8}@[a-z][a-z0-9-.]{2,12}\\.[a-z]{2,4}";
                        break;
                    }
                    case "hostname": {
                        pattern = "[a-z][a-z0-9-.]{2,12}\\.[a-z]{2,4}";
                        break;
                    }
                    case "ipv4": {
                        pattern = "(?:(?:25[0-5]|2[0-4][0-9]|[1-9][0-9]|[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|[1-9][0-9]|[0-9])";
                        break;
                    }
                    case "ipv6": {
                        pattern = "(?:(?:[0-9A-F]{1,4}:){7}(?:[0-9A-F]{1,4}|:))|(?:(?:[0-9A-F]{1,4}:){6}(?::[0-9A-F]{1,4}|(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(?:(?:[0-9A-F]{1,4}:){5}(?:(?:(?::[0-9A-F]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(?:(?:[0-9A-F]{1,4}:){4}(?:(?:(?::[0-9A-F]{1,4}){1,3})|(?:(?::[0-9A-F]{1,4})?:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(?:(?:[0-9A-F]{1,4}:){3}(?:(?:(?::[0-9A-F]{1,4}){1,4})|(?:(?::[0-9A-F]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(?:(?:[0-9A-F]{1,4}:){2}(?:(?:(?::[0-9A-F]{1,4}){1,5})|(?:(?::[0-9A-F]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(?:(?:[0-9A-F]{1,4}:){1}(?:(?:(?::[0-9A-F]{1,4}){1,6})|(?:(?::[0-9A-F]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(?::(?:(?:(?::[0-9A-F]{1,4}){1,7})|(?:(?::[0-9A-F]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))";
                        break;
                    }
                    case "uri": {
                        pattern = "(?:(?:http[s]?|ftp):)?(?://[a-z][a-z.]{4,12})?(?:/[a-z]{1,8}){0,4}(?:\\?[a-z]{1,8}=[a-z0-9]{1,8}(?:&[a-z]{1,8}=[a-z0-9]{1,8}){0,3})?(?:#[a-z0-9_]{1,16})?";
                        break;
                    }
                    case "uuid": {
                        pattern = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
                        break;
                    }
                }
            }
        }
        if (pattern == null) {
            int minLength = var == null || var.minLength == null ? 4 : var.minLength;
            int maxLength = var == null || var.maxLength == null ? 16 : var.maxLength;
            pattern = "[a-zA-Z][a-zA-Z0-9]{" + minLength + "," + maxLength + "}";
        }
        return pattern;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        if (this.generateOperationBody) {
            for (ModelsMap value : objs.values()) {
                for (ModelMap mo : value.getModels()) {
                    this.postProcessModel(mo.getModel());
                }
            }
        }
        return objs;
    }

    private void postProcessModel(CodegenModel cm) {
        for (CodegenProperty var : cm.vars) {
            var.vendorExtensions.put("x-defining-class", cm.classname);
        }
        if (this.supportsInheritance) {
            if (cm.allVars != cm.vars) {
                for (CodegenProperty var : cm.allVars) {
                    String definingClass = cm.classname;
                    if (cm.vars.stream().noneMatch(v -> v.name.equals(var.name))) {
                        CodegenModel ancestor = cm;
                        while ((ancestor = ancestor.parentModel) != null) {
                            if (!ancestor.vars.stream().anyMatch(v -> v.name.equals(var.name))) continue;
                            definingClass = ancestor.classname;
                            break;
                        }
                    }
                    var.vendorExtensions.put("x-defining-class", definingClass);
                }
            }
            if (cm.parentModel != null) {
                this.postProcessModel(cm.parentModel);
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations;
        OperationsMap result = super.postProcessOperationsWithModels(objs, allModels);
        if (this.generateOperationBody && (operations = result.getOperations()) != null) {
            String classname = operations.getClassname();
            HashMap<String, CodegenModel> models = new HashMap<String, CodegenModel>();
            for (ModelMap model : allModels) {
                CodegenModel cgModel = model.getModel();
                models.put(cgModel.classname, cgModel);
            }
            StringBuilder buffer = new StringBuilder();
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation codegenOperation : ops) {
                this.applyDefaultContentTypes(codegenOperation);
                String testDataPath = "/" + classname + "/" + codegenOperation.operationId;
                boolean first = true;
                for (CodegenParameter cp : codegenOperation.allParams) {
                    buffer.setLength(0);
                    CodegenVariable var = new CodegenVariable(null, cp, testDataPath, models);
                    String localVar = this.appendLocalVariable(buffer, INDENT, codegenOperation, var, new ArrayList<String>(), models);
                    if (this.loadTestDataFromFile) {
                        buffer.append(NL).append(INDENT).append(var.dataType).append(' ').append(localVar).append(" = cache.").append(this.getCacheMethod(var)).append("(\"/").append(codegenOperation.operationId).append('/').append(var.name).append('\"');
                        if (var.isListContainer) {
                            buffer.append(", ").append(var.getComponentType()).append(".class");
                        } else if (var.isMap) {
                            buffer.append(", Map.class");
                        } else if (!this.hasCacheMethod(var)) {
                            buffer.append(", ").append(var.dataType).append(".class");
                        }
                        buffer.append(");");
                    }
                    if (first && buffer.indexOf(NL) == 0) {
                        buffer.delete(0, NL.length());
                        first = false;
                    }
                    cp.vendorExtensions.put("x-java-param-decl", buffer.toString());
                }
                if (((Boolean)codegenOperation.vendorExtensions.getOrDefault("x-java-is-response-void", false)).booleanValue()) continue;
                CodegenVariable var = new CodegenVariable(null, codegenOperation, testDataPath, models);
                buffer.setLength(0);
                String localVar = this.appendLocalVariable(buffer, INDENT, codegenOperation, var, new ArrayList<String>(), models);
                if (this.loadTestDataFromFile) {
                    buffer.append(NL).append(INDENT).append("try {").append(NL).append(INDENT).append("    ").append(var.dataType).append(' ').append(localVar).append(" = cache.").append(this.getCacheMethod(var)).append("(\"/").append(codegenOperation.operationId).append('/').append(var.name).append('\"');
                    if (var.isListContainer) {
                        buffer.append(", ").append(var.getComponentType()).append(".class");
                    } else if (var.isMap) {
                        buffer.append(", Map.class");
                    } else if (!this.hasCacheMethod(var)) {
                        buffer.append(", ").append(var.dataType).append(".class");
                    }
                    buffer.append(");").append(NL).append(INDENT).append("    return ").append(localVar).append(';').append(NL).append(INDENT).append("} catch (CacheException e) {").append(NL).append(INDENT).append("    throw new RuntimeException(e);").append(NL).append(INDENT).append("}");
                } else {
                    buffer.append(NL).append(INDENT).append("return ").append(localVar).append(';');
                }
                if (buffer.indexOf(NL) == 0) {
                    buffer.delete(0, NL.length());
                }
                codegenOperation.vendorExtensions.put("x-java-operation-body", buffer.toString());
            }
            TreeSet<String> allImports = new TreeSet<String>();
            for (CodegenOperation op : ops) {
                allImports.addAll(op.imports);
            }
            allImports.add("List");
            allImports.add("Map");
            ArrayList arrayList = new ArrayList();
            for (String nextImport : allImports) {
                LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
                String mapping = this.importMapping().get(nextImport);
                if (mapping == null) {
                    mapping = this.toModelImport(nextImport);
                }
                if (mapping == null) continue;
                im.put("import", mapping);
                if (arrayList.contains(im)) continue;
                arrayList.add(im);
            }
            objs.put("imports", arrayList);
            if (arrayList.size() > 0) {
                objs.put("hasImport", true);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs = super.postProcessSupportingFileData(objs);
        if (this.loadTestDataFromFile) {
            ByteArrayOutputStream out;
            try {
                if (this.testDataCache.root().isDirty()) {
                    out = new ByteArrayOutputStream();
                    this.testDataCache.root().flush(out);
                    String testDataJson = out.toString("UTF-8");
                    objs.put("test-data.json", testDataJson);
                    this.supportingFiles.add(new SupportingFile("testData.mustache", this.testDataFile.getAbsolutePath()));
                }
            }
            catch (UnsupportedEncodingException | JsonCache.CacheException e) {
                this.LOGGER.error("Error writing JSON test data file " + this.testDataFile, (Throwable)e);
            }
            try {
                if (this.testDataControlCache.root().isDirty()) {
                    out = new ByteArrayOutputStream();
                    this.testDataControlCache.root().flush(out);
                    String testDataControlJson = out.toString("UTF-8");
                    objs.put("test-data-control.json", testDataControlJson);
                    this.supportingFiles.add(new SupportingFile("testDataControl.mustache", this.testDataControlFile.getAbsolutePath()));
                }
            }
            catch (UnsupportedEncodingException | JsonCache.CacheException e) {
                this.LOGGER.error("Error writing JSON test data control file " + this.testDataControlFile, (Throwable)e);
            }
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("generateSpringApplication")) {
            this.setSupportMultipleSpringServices(this.convertPropertyToBooleanAndWriteBack("supportMultipleSpringServices"));
        }
        if (this.additionalProperties.containsKey("generateOperationBody")) {
            boolean generateOperationBody = this.convertPropertyToBooleanAndWriteBack("generateOperationBody");
            this.setGenerateOperationBody(generateOperationBody);
            boolean loadTestDataFromFile = this.convertPropertyToBooleanAndWriteBack("loadTestDataFromFile");
            this.setLoadTestDataFromFile(loadTestDataFromFile);
            if (loadTestDataFromFile) {
                Object testDataFileStr = this.additionalProperties.containsKey("testDataFile") ? (String)this.additionalProperties.get("testDataFile") : this.outputFolder() + "/src/main/resources/test-data.json";
                testDataFileStr = ((String)testDataFileStr).replace('/', File.separatorChar);
                try {
                    File testDataFile = new File((String)testDataFileStr).getCanonicalFile();
                    testDataFileStr = testDataFile.getPath();
                    this.additionalProperties.put("testDataFile", ((String)testDataFileStr).replaceAll("\\\\", "\\\\\\\\"));
                    this.setTestDataFile(testDataFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to canonicalize file " + (String)testDataFileStr, e);
                }
                this.testDataCache = JsonCache.Factory.instance.get("test-data").mergePolicy(JsonCache.Root.MergePolicy.KEEP_EXISTING).child("/" + this.invokerPackage);
                if (this.testDataFile.exists()) {
                    try {
                        this.testDataCache.root().load(this.testDataFile);
                    }
                    catch (JsonCache.CacheException e) {
                        this.LOGGER.error("Unable to load test data file " + (String)testDataFileStr, (Throwable)e);
                    }
                }
                Object testDataControlFileStr = this.additionalProperties.containsKey("testDataControlFile") ? (String)this.additionalProperties.get("testDataControlFile") : this.outputFolder() + "/test-data-control.json";
                testDataControlFileStr = ((String)testDataControlFileStr).replace('/', File.separatorChar);
                try {
                    File testDataControlFile = new File((String)testDataControlFileStr).getCanonicalFile();
                    testDataControlFileStr = testDataControlFile.getPath();
                    this.additionalProperties.put("testDataControlFile", ((String)testDataControlFileStr).replaceAll("\\\\", "\\\\\\\\"));
                    this.setTestDataControlFile(testDataControlFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to canonicalize file " + (String)testDataControlFileStr, e);
                }
                this.testDataControlCache = JsonCache.Factory.instance.get("test-data-control").mergePolicy(JsonCache.Root.MergePolicy.KEEP_EXISTING).child("/" + this.invokerPackage);
                if (this.testDataControlFile.exists()) {
                    try {
                        this.testDataControlCache.root().load(this.testDataControlFile);
                    }
                    catch (JsonCache.CacheException e) {
                        this.LOGGER.error("Unable to load test data control file " + (String)testDataControlFileStr, (Throwable)e);
                    }
                }
            }
        }
        if (this.generateSpringApplication && this.supportMultipleSpringServices) {
            SupportingFile supportingFile = null;
            for (SupportingFile sf : this.supportingFiles) {
                if (!"server/ApplicationContext.xml.mustache".equals(sf.getTemplateFile())) continue;
                supportingFile = sf;
                break;
            }
            if (supportingFile != null) {
                this.supportingFiles.remove((Object)supportingFile);
                SupportingFile updated = new SupportingFile(supportingFile.getTemplateFile(), supportingFile.getFolder(), "ApplicationContext-" + this.invokerPackage + ".xml");
                this.supportingFiles.add(updated);
            }
        }
    }

    @Override
    public void setGenerateOperationBody(boolean generateOperationBody) {
        this.generateOperationBody = generateOperationBody;
    }

    @Override
    public void setLoadTestDataFromFile(boolean loadTestDataFromFile) {
        this.loadTestDataFromFile = loadTestDataFromFile;
    }

    public void setSupportMultipleSpringServices(boolean supportMultipleSpringServices) {
        this.supportMultipleSpringServices = supportMultipleSpringServices;
    }

    @Override
    public void setTestDataControlFile(File testDataControlFile) {
        this.testDataControlFile = testDataControlFile;
    }

    @Override
    public void setTestDataFile(File testDataFile) {
        this.testDataFile = testDataFile;
    }

    @Override
    public String toDefaultValue(Schema p) {
        Schema ref;
        if (ModelUtils.isGenerateAliasAsModel(p) && StringUtils.isNotEmpty((CharSequence)p.get$ref()) && (ModelUtils.isArraySchema(ref = ModelUtils.getReferencedSchema(this.openAPI, p)) || ModelUtils.isMapSchema(ref))) {
            String typeDeclaration = this.getTypeDeclaration(p);
            return String.format(Locale.ROOT, "new %s()", typeDeclaration);
        }
        return super.toDefaultValue(p);
    }

    static {
        NL = System.lineSeparator();
        DATE_TYPES = Arrays.asList("Date", "DateTime", "OffsetDateTime", "LocalDateTime", "LocalDate");
        long minDate = 0L;
        long maxDate = 0L;
        try {
            minDate = ISO8601_DATETIME_FORMAT.get().parse("1970-01-01T00:00:00Z").getTime();
            maxDate = ISO8601_DATETIME_FORMAT.get().parse("2099-12-31T23:59:59Z").getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        MIN_DATE = minDate;
        MAX_DATE = maxDate;
    }

    class CodegenVariable {
        CodegenVariable parent;
        String name;
        String dataFormat;
        String dataType;
        String enumName;
        Map<String, Object> allowableValues;
        boolean isArray;
        boolean isContainer;
        boolean isListContainer;
        boolean isMap;
        boolean isPrimitiveType;
        CodegenVariable items;
        Integer minItems;
        int itemCount = 1;
        String minimum;
        String maximum;
        boolean exclusiveMinimum;
        boolean exclusiveMaximum;
        Integer minLength;
        Integer maxLength;
        String pattern;
        String setter;
        String testDataPath;
        int index;
        Map<String, Object> varVendorExtensions;

        private CodegenVariable() {
            this.varVendorExtensions = new HashMap<String, Object>();
        }

        private CodegenVariable(CodegenVariable parent, CodegenOperation op, String testDataPath, Map<String, CodegenModel> models) {
            this.name = "response";
            this.dataFormat = null;
            this.dataType = op.returnType;
            this.enumName = null;
            this.allowableValues = null;
            this.isContainer = op.isArray || op.isMap;
            this.isListContainer = op.isArray;
            this.isMap = op.isMap;
            this.isPrimitiveType = op.returnTypeIsPrimitive;
            this.minItems = null;
            this.minimum = null;
            this.maximum = null;
            this.exclusiveMinimum = false;
            this.exclusiveMaximum = false;
            this.minLength = null;
            this.maxLength = null;
            this.pattern = null;
            this.setter = null;
            this.varVendorExtensions = op.vendorExtensions;
            this.init(parent, testDataPath, models);
            if (op.isArray || op.isMap) {
                this.items = new CodegenVariable();
                this.items.dataType = op.returnBaseType;
                this.items.isPrimitiveType = op.returnTypeIsPrimitive;
                this.items.name = "item";
                this.items.init(this, testDataPath, models);
            }
        }

        private CodegenVariable(CodegenVariable parent, CodegenParameter param, String testDataPath, Map<String, CodegenModel> models) {
            this.name = param.paramName;
            this.dataFormat = param.dataFormat;
            this.dataType = param.dataType;
            this.enumName = param.enumName;
            this.allowableValues = param.allowableValues;
            this.isContainer = param.isContainer;
            this.isListContainer = param.isArray;
            this.isMap = param.isMap;
            this.isPrimitiveType = param.isPrimitiveType;
            this.minItems = param.minItems;
            this.minimum = param.minimum;
            this.maximum = param.maximum;
            this.exclusiveMinimum = param.exclusiveMinimum;
            this.exclusiveMaximum = param.exclusiveMaximum;
            this.minLength = param.minLength;
            this.maxLength = param.maxLength;
            this.pattern = param.pattern;
            this.setter = null;
            this.varVendorExtensions = param.vendorExtensions;
            this.init(parent, testDataPath, models);
            this.items = param.items == null ? null : new CodegenVariable(this, param.items, null, models);
        }

        private CodegenVariable(CodegenVariable parent, CodegenProperty prop, String testDataPath, Map<String, CodegenModel> models) {
            this.name = prop.name;
            this.dataFormat = prop.dataFormat;
            this.dataType = prop.dataType;
            this.enumName = prop.enumName;
            this.allowableValues = prop.allowableValues;
            this.isContainer = prop.isContainer;
            this.isListContainer = prop.isArray;
            this.isMap = prop.isMap;
            this.isPrimitiveType = prop.isPrimitiveType;
            this.minItems = prop.minItems;
            this.minimum = prop.minimum;
            this.maximum = prop.maximum;
            this.exclusiveMinimum = prop.exclusiveMinimum;
            this.exclusiveMaximum = prop.exclusiveMaximum;
            this.minLength = prop.minLength;
            this.maxLength = prop.maxLength;
            this.pattern = prop.pattern;
            this.setter = prop.getSetter();
            this.varVendorExtensions = prop.vendorExtensions;
            this.init(parent, testDataPath, models);
            this.items = prop.items == null ? null : new CodegenVariable(this, prop.items, null, models);
        }

        void addTestData(Object value) {
            JsonPointer ptr = this.getPointer(null, true, true);
            if (!JavaCXFExtServerCodegen.this.testDataCache.exists(ptr)) {
                try {
                    JavaCXFExtServerCodegen.this.testDataCache.set(ptr, value);
                }
                catch (JsonCache.CacheException e) {
                    JavaCXFExtServerCodegen.this.LOGGER.error("Unable to update test data cache for " + ptr, (Throwable)e);
                }
            }
        }

        private void appendPath(StringBuilder path, boolean includeIndexes) {
            if (this.parent == null) {
                path.append(this.testDataPath);
            } else {
                this.parent.appendPath(path, includeIndexes);
            }
            if (!this.isListItem()) {
                path.append('/').append(this.name);
            }
            if (includeIndexes && this.isIndexed()) {
                path.append('/').append(this.index);
            }
        }

        String getComponentType() {
            return this.isArray ? this.dataType.substring(0, this.dataType.length() - 2) : (this.isContainer ? this.items : this).dataType;
        }

        private JsonPointer getPointer(String suffix, boolean includeIndexes, boolean includeLastIndex) {
            StringBuilder path = new StringBuilder();
            this.appendPath(path, includeIndexes);
            if (includeIndexes && !includeLastIndex && this.isIndexed()) {
                path.setLength(path.lastIndexOf("/"));
            }
            if (suffix != null) {
                path.append('/').append(suffix);
            }
            return JsonPointer.compile((String)path.toString());
        }

        private void init(CodegenVariable parent, String testDataPath, Map<String, CodegenModel> models) {
            this.parent = parent;
            this.isArray = this.dataType.endsWith("[]");
            this.testDataPath = testDataPath;
            CodegenModel cm = models.get(this.dataType);
            if (cm != null && (cm.isArray || cm.isMap)) {
                this.isContainer = true;
                this.isListContainer = cm.isArray;
                this.isMap = cm.isMap;
                this.items = new CodegenVariable();
                this.items.name = "item";
                this.items.dataType = cm.additionalPropertiesType;
                this.items.init(this, testDataPath, models);
            }
            try {
                if ((this.isArray || this.isContainer) && JavaCXFExtServerCodegen.this.testDataControlCache != null) {
                    this.itemCount = JavaCXFExtServerCodegen.this.testDataControlCache.getInt(this.getPointer("testItemCount", false, false), 1);
                }
            }
            catch (JsonCache.CacheException e) {
                JavaCXFExtServerCodegen.this.LOGGER.error("Error accessing test data control cache", (Throwable)e);
            }
        }

        private boolean isIndexed() {
            return this.isListContainer || this.isArray && !this.dataType.equals("byte[]");
        }

        private boolean isListItem() {
            return this.parent != null && this.parent.isListContainer;
        }

        int size() {
            return JavaCXFExtServerCodegen.this.loadTestDataFromFile ? JavaCXFExtServerCodegen.this.testDataCache.size(this.getPointer(null, true, false)) : 0;
        }

        public String toString() {
            return "CodegenVariable [name=" + this.name + ", dataType=" + this.dataType + ", dataFormat=" + this.dataFormat + ", isArray=" + this.isArray + ", isContainer=" + this.isContainer + ", isListContainer=" + this.isListContainer + ", isMap=" + this.isMap + ", isPrimitiveType=" + this.isPrimitiveType + ", testDataPath=" + this.testDataPath + ", enumName=" + this.enumName + ", allowableValues=" + this.allowableValues + ", minItems=" + this.minItems + ", itemCount=" + this.itemCount + ", minimum=" + this.minimum + ", maximum=" + this.maximum + ", exclusiveMinimum=" + this.exclusiveMinimum + ", exclusiveMaximum=" + this.exclusiveMaximum + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", pattern=" + this.pattern + ", setter=" + this.setter + ", vendorExtensions=" + this.varVendorExtensions + "]";
        }
    }
}

