/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.meta;

import java.util.HashMap;
import java.util.Map;
import org.openapitools.codegen.meta.FeatureSet;
import org.openapitools.codegen.meta.Stability;

public class GeneratorMetadata {
    private Stability stability;
    private Map<String, FeatureSet> libraryFeatures;
    private FeatureSet featureSet;
    private String generationMessage;

    private GeneratorMetadata(Builder builder) {
        if (builder != null) {
            this.stability = builder.stability;
            this.generationMessage = builder.generationMessage;
            this.libraryFeatures = builder.libraryFeatures;
            this.featureSet = builder.featureSet;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GeneratorMetadata copy) {
        Builder builder = new Builder();
        if (copy != null) {
            builder.stability = copy.getStability();
            builder.generationMessage = copy.getGenerationMessage();
            builder.libraryFeatures = copy.getLibraryFeatures();
            builder.featureSet = copy.getFeatureSet();
        }
        return builder;
    }

    public String getGenerationMessage() {
        return this.generationMessage;
    }

    public Stability getStability() {
        return this.stability;
    }

    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public Map<String, FeatureSet> getLibraryFeatures() {
        return this.libraryFeatures;
    }

    public static final class Builder {
        private Stability stability;
        private String generationMessage;
        private FeatureSet featureSet = FeatureSet.UNSPECIFIED;
        private Map<String, FeatureSet> libraryFeatures = new HashMap<String, FeatureSet>();

        private Builder() {
        }

        public Builder stability(Stability stability) {
            this.stability = stability;
            return this;
        }

        public Builder featureSet(FeatureSet featureSet) {
            this.featureSet = featureSet != null ? featureSet : FeatureSet.UNSPECIFIED;
            return this;
        }

        public Builder libraryFeatures(Map<String, FeatureSet> libraryFeatures) {
            this.libraryFeatures = libraryFeatures;
            return this;
        }

        public Builder generationMessage(String generationMessage) {
            this.generationMessage = generationMessage;
            return this;
        }

        public GeneratorMetadata build() {
            return new GeneratorMetadata(this);
        }
    }
}

