/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloningUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

final class DeepCloningFieldCloner {
    private final AtomicReference<Metadata> valueDeepCloneDecision = new AtomicReference();
    private final AtomicInteger fieldDeepCloneDecision = new AtomicInteger(-1);
    private final Field field;

    public DeepCloningFieldCloner(Field field) {
        this.field = Objects.requireNonNull(field);
    }

    public Field getField() {
        return this.field;
    }

    public <C> Object clone(SolutionDescriptor<?> solutionDescriptor, C original, C clone) {
        Object originalValue = FieldCloningUtils.getObjectFieldValue(original, this.field);
        if (this.deepClone(solutionDescriptor, original.getClass(), originalValue)) {
            return originalValue;
        }
        FieldCloningUtils.setObjectFieldValue(clone, this.field, originalValue);
        return null;
    }

    private boolean deepClone(SolutionDescriptor<?> solutionDescriptor, Class<?> fieldTypeClass, Object originalValue) {
        if (originalValue == null) {
            return false;
        }
        boolean isValueDeepCloned = this.valueDeepCloneDecision.updateAndGet((UnaryOperator<Metadata>)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deepClone$0(java.lang.Object org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor org.optaplanner.core.impl.domain.solution.cloner.DeepCloningFieldCloner$Metadata ), (Lorg/optaplanner/core/impl/domain/solution/cloner/DeepCloningFieldCloner$Metadata;)Lorg/optaplanner/core/impl/domain/solution/cloner/DeepCloningFieldCloner$Metadata;)((Object)originalValue, solutionDescriptor)).decision;
        if (isValueDeepCloned) {
            return true;
        }
        if (this.fieldDeepCloneDecision.get() < 0) {
            this.fieldDeepCloneDecision.set(DeepCloningUtils.isFieldDeepCloned(solutionDescriptor, this.field, fieldTypeClass) ? 1 : 0);
        }
        return this.fieldDeepCloneDecision.get() == 1;
    }

    private static /* synthetic */ Metadata lambda$deepClone$0(Object originalValue, SolutionDescriptor solutionDescriptor, Metadata old) {
        Class<?> originalClass = originalValue.getClass();
        if (old == null || old.clz != originalClass) {
            return new Metadata(originalClass, DeepCloningUtils.isClassDeepCloned(solutionDescriptor, originalClass));
        }
        return old;
    }

    private static final class Metadata {
        private final Class<?> clz;
        private final boolean decision;

        public Metadata(Class<?> clz, boolean decision) {
            this.clz = clz;
            this.decision = decision;
        }
    }
}

