/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner.gizmo;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.util.MutableReference;

public class GizmoSolutionClonerImplementor {
    private static final MethodDescriptor EQUALS_METHOD = MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor GET_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    public static final boolean DEBUG = false;

    public static Comparator<Class<?>> getInstanceOfComparator(Set<Class<?>> deepClonedClassSet) {
        HashMap classToSubclassLevel = new HashMap();
        deepClonedClassSet.forEach(clazz -> {
            if (deepClonedClassSet.stream().allMatch(otherClazz -> clazz.isAssignableFrom((Class<?>)otherClazz) || !otherClazz.isAssignableFrom((Class<?>)clazz))) {
                classToSubclassLevel.put((Class<?>)clazz, 0);
            }
        });
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Class<?> clazz2 : deepClonedClassSet) {
                Optional<Integer> maxParentSubclassLevel = classToSubclassLevel.keySet().stream().filter(otherClazz -> otherClazz != clazz2 && otherClazz.isAssignableFrom(clazz2)).map(classToSubclassLevel::get).max(Integer::compare);
                if (!maxParentSubclassLevel.isPresent()) continue;
                Integer oldVal = classToSubclassLevel.getOrDefault(clazz2, -1);
                Integer newVal = maxParentSubclassLevel.get() + 1;
                if (newVal.compareTo(oldVal) <= 0) continue;
                isChanged = true;
                classToSubclassLevel.put(clazz2, newVal);
            }
        }
        return Comparator.comparing(classToSubclassLevel::get).thenComparing(Class::getName).reversed();
    }

    public static void defineClonerFor(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        Set deepCloneClassesThatAreNotSolutionSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).collect(Collectors.toSet());
        Comparator<Class<?>> instanceOfComparator = GizmoSolutionClonerImplementor.getInstanceOfComparator(deepClonedClassSet);
        TreeSet deepCloneClassesThatAreNotSolutionSortedSet = new TreeSet(instanceOfComparator);
        deepCloneClassesThatAreNotSolutionSortedSet.addAll(deepCloneClassesThatAreNotSolutionSet);
        GizmoSolutionClonerImplementor.createConstructor(classCreator);
        GizmoSolutionClonerImplementor.createCloneSolution(classCreator, solutionDescriptor);
        GizmoSolutionClonerImplementor.createCloneSolutionRun(classCreator, solutionDescriptor, solutionClassSet, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet, instanceOfComparator);
        for (Class clazz2 : deepCloneClassesThatAreNotSolutionSortedSet) {
            GizmoSolutionClonerImplementor.createDeepCloneHelperMethod(classCreator, clazz2, solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet);
        }
        Set abstractDeepCloneClassSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(clazz -> clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())).collect(Collectors.toSet());
        for (Class abstractDeepClonedClass : abstractDeepCloneClassSet) {
            GizmoSolutionClonerImplementor.createAbstractDeepCloneHelperMethod(classCreator, abstractDeepClonedClass, solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet);
        }
    }

    public static ClassOutput createClassOutputWithDebuggingCapability(MutableReference<byte[]> classBytecodeHolder) {
        return (path, byteCode) -> classBytecodeHolder.setValue(byteCode);
    }

    public static <T> SolutionCloner<T> createClonerFor(SolutionDescriptor<T> solutionDescriptor, GizmoClassLoader gizmoClassLoader) {
        String className = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return GizmoSolutionClonerImplementor.createInstance(className, gizmoClassLoader);
        }
        MutableReference<Object> classBytecodeHolder = new MutableReference<Object>(null);
        ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{SolutionCloner.class}).superClass(Object.class).classOutput(GizmoSolutionClonerImplementor.createClassOutputWithDebuggingCapability(classBytecodeHolder)).setFinal(true).build();
        Set<Class<?>> deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses(solutionDescriptor, Collections.emptyList());
        GizmoSolutionClonerImplementor.defineClonerFor(classCreator, solutionDescriptor, Collections.singleton(solutionDescriptor.getSolutionClass()), new HashMap(), deepClonedClassSet);
        classCreator.close();
        byte[] classBytecode = classBytecodeHolder.getValue();
        gizmoClassLoader.storeBytecode(className, classBytecode);
        return GizmoSolutionClonerImplementor.createInstance(className, gizmoClassLoader);
    }

    private static <T> SolutionCloner<T> createInstance(String className, ClassLoader gizmoClassLoader) {
        try {
            return (SolutionCloner)gizmoClassLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConstructor(ClassCreator classCreator) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        methodCreator.returnValue(thisObj);
    }

    private static void createCloneSolution(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor) {
        Class<?> solutionClass = solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(SolutionCloner.class, (String)"cloneSolution", Object.class, (Class[])new Class[]{Object.class}));
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        ResultHandle clone = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor), (String)"cloneSolutionRun", solutionClass, (Object[])new Object[]{solutionClass, Map.class}), new ResultHandle[]{thisObj, methodCreator.newInstance(MethodDescriptor.ofConstructor(IdentityHashMap.class, (Class[])new Class[0]), new ResultHandle[0])});
        methodCreator.returnValue(clone);
    }

    private static void createCloneSolutionRun(ClassCreator classCreator, SolutionDescriptor solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet, Comparator<Class<?>> instanceOfComparator) {
        Class solutionClass = solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = classCreator.getMethodCreator("cloneSolutionRun", solutionClass, new Class[]{solutionClass, Map.class});
        methodCreator.setModifiers(10);
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        BranchResult solutionNullBranchResult = methodCreator.ifNull(thisObj);
        BytecodeCreator solutionIsNullBranch = solutionNullBranchResult.trueBranch();
        solutionIsNullBranch.returnValue(thisObj);
        BytecodeCreator solutionIsNotNullBranch = solutionNullBranchResult.falseBranch();
        ResultHandle createdCloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = solutionIsNotNullBranch.invokeInterfaceMethod(GET_METHOD, createdCloneMap, new ResultHandle[]{thisObj});
        BranchResult hasCloneBranchResult = solutionIsNotNullBranch.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        ArrayList sortedSolutionClassList = new ArrayList(solutionClassSet);
        sortedSolutionClassList.sort(instanceOfComparator);
        BytecodeCreator currentBranch = noCloneBranch;
        ResultHandle thisObjClass = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"getClass", Class.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        for (Class clazz : sortedSolutionClassList) {
            ResultHandle solutionSubclassResultHandle = currentBranch.loadClass(clazz);
            ResultHandle isSubclass = currentBranch.invokeVirtualMethod(EQUALS_METHOD, solutionSubclassResultHandle, new ResultHandle[]{thisObjClass});
            BranchResult isSubclassBranchResult = currentBranch.ifTrue(isSubclass);
            BytecodeCreator isSubclassBranch = isSubclassBranchResult.trueBranch();
            GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor = memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(clazz, key -> new GizmoSolutionOrEntityDescriptor(solutionDescriptor, solutionSubclass));
            ResultHandle clone = isSubclassBranch.newInstance(MethodDescriptor.ofConstructor((Class)clazz, (Class[])new Class[0]), new ResultHandle[0]);
            isSubclassBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), createdCloneMap, new ResultHandle[]{thisObj, clone});
            for (GizmoMemberDescriptor shallowlyClonedField : solutionSubclassDescriptor.getShallowClonedMemberDescriptors()) {
                GizmoSolutionClonerImplementor.writeShallowCloneInstructions(solutionSubclassDescriptor, isSubclassBranch, shallowlyClonedField, thisObj, clone, createdCloneMap, deepClonedClassesSortedSet);
            }
            for (Field deeplyClonedField : solutionSubclassDescriptor.getDeepClonedFields()) {
                GizmoMemberDescriptor gizmoMemberDescriptor = solutionSubclassDescriptor.getMemberDescriptorForField(deeplyClonedField);
                ResultHandle fieldValue = gizmoMemberDescriptor.readMemberValue(isSubclassBranch, thisObj);
                AssignableResultHandle cloneValue = isSubclassBranch.createVariable(deeplyClonedField.getType());
                GizmoSolutionClonerImplementor.writeDeepCloneInstructions(isSubclassBranch, solutionSubclassDescriptor, deeplyClonedField, gizmoMemberDescriptor, fieldValue, cloneValue, createdCloneMap, deepClonedClassesSortedSet);
                if (gizmoMemberDescriptor.writeMemberValue(isSubclassBranch, clone, (ResultHandle)cloneValue)) continue;
                throw new IllegalStateException("The member (" + gizmoMemberDescriptor.getName() + ") of class (" + gizmoMemberDescriptor.getDeclaringClassName() + ") does not have a setter.");
            }
            isSubclassBranch.returnValue(clone);
            currentBranch = isSubclassBranchResult.falseBranch();
        }
        ResultHandle errorBuilder = currentBranch.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{currentBranch.load("Failed to create clone: encountered (")});
        MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class});
        currentBranch.invokeVirtualMethod(methodDescriptor, errorBuilder, new ResultHandle[]{thisObjClass});
        currentBranch.invokeVirtualMethod(methodDescriptor, errorBuilder, new ResultHandle[]{currentBranch.load(") which is not a known subclass of the solution class (" + solutionDescriptor.getSolutionClass() + "). The known subclasses are " + solutionClassSet.stream().map(Class::getName).collect(Collectors.joining(", ", "[", "]")) + ".\nMaybe use DomainAccessType.REFLECTION?")});
        ResultHandle errorMsg = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), errorBuilder, new ResultHandle[0]);
        ResultHandle error = currentBranch.newInstance(MethodDescriptor.ofConstructor(IllegalArgumentException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{errorMsg});
        currentBranch.throwException(error);
    }

    private static void writeShallowCloneInstructions(GizmoSolutionOrEntityDescriptor solutionInfo, BytecodeCreator methodCreator, GizmoMemberDescriptor shallowlyClonedField, ResultHandle thisObj, ResultHandle clone, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        try {
            boolean isArray = shallowlyClonedField.getTypeName().endsWith("[]");
            Class<?> type = null;
            if (shallowlyClonedField.getType() instanceof Class) {
                type = (Class<?>)shallowlyClonedField.getType();
            }
            List entitySubclasses = Collections.emptyList();
            if (type == null && !isArray) {
                type = Class.forName(shallowlyClonedField.getTypeName().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && !isArray) {
                entitySubclasses = deepClonedClassesSortedSet.stream().filter(type::isAssignableFrom).collect(Collectors.toList());
            }
            ResultHandle fieldValue = shallowlyClonedField.readMemberValue(methodCreator, thisObj);
            if (!entitySubclasses.isEmpty()) {
                AssignableResultHandle cloneResultHolder = methodCreator.createVariable(type);
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(methodCreator, solutionInfo, type, fieldValue, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, false);
                fieldValue = cloneResultHolder;
            }
            if (!shallowlyClonedField.writeMemberValue(methodCreator, clone, fieldValue)) {
                throw new IllegalStateException("Field (" + shallowlyClonedField.getName() + ") of class (" + shallowlyClonedField.getDeclaringClassName() + ") does not have a setter.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error creating Gizmo Solution Cloner", e);
        }
    }

    private static void writeDeepCloneInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Field deeplyClonedField, GizmoMemberDescriptor gizmoMemberDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        Class<?> deeplyClonedFieldClass = deeplyClonedField.getType();
        Type type = gizmoMemberDescriptor.getType();
        if (solutionDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(bytecodeCreator, solutionDescriptor, toClone, cloneResultHolder, createdCloneMap);
        } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (deeplyClonedFieldClass.isArray()) {
            GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else {
            boolean forceDeepClone = DeepCloningUtils.isFieldDeepCloned(solutionDescriptor.solutionDescriptor, deeplyClonedField, deeplyClonedField.getDeclaringClass());
            GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, forceDeepClone);
        }
    }

    private static void writeDeepCloneInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        if (solutionDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(bytecodeCreator, solutionDescriptor, toClone, cloneResultHolder, createdCloneMap);
        } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
            GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (deeplyClonedFieldClass.isArray()) {
            GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else {
            GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, false);
        }
    }

    private static void writeDeepCloneSolutionInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        ResultHandle clone = isNotNullBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)"cloneSolutionRun", solutionDescriptor.getSolutionDescriptor().getSolutionClass(), (Object[])new Object[]{solutionDescriptor.getSolutionDescriptor().getSolutionClass(), Map.class}), new ResultHandle[]{toClone, createdCloneMap});
        isNotNullBranch.assign(cloneResultHolder, clone);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeDeepCloneCollectionInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class elementClass;
        AssignableResultHandle cloneCollection = bytecodeCreator.createVariable(deeplyClonedFieldClass);
        ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        if (List.class.isAssignableFrom(deeplyClonedFieldClass)) {
            bytecodeCreator.assign(cloneCollection, bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        } else if (Set.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle isSortedSet = bytecodeCreator.instanceOf(toClone, SortedSet.class);
            BranchResult isSortedSetBranchResult = bytecodeCreator.ifTrue(isSortedSet);
            BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();
            ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
            BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();
            isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        } else {
            ResultHandle isSet = bytecodeCreator.instanceOf(toClone, Set.class);
            BranchResult isSetBranchResult = bytecodeCreator.ifTrue(isSet);
            BytecodeCreator isSetBranch = isSetBranchResult.trueBranch();
            ResultHandle isSortedSet = isSetBranch.instanceOf(toClone, SortedSet.class);
            BranchResult isSortedSetBranchResult = isSetBranch.ifTrue(isSortedSet);
            BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();
            ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
            BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();
            isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
            BytecodeCreator isNotSetBranch = isSetBranchResult.falseBranch();
            isNotSetBranch.assign(cloneCollection, isNotSetBranch.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        }
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();
        if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Collection type (" + type + ").");
        Type elementClassType = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (elementClassType instanceof Class) {
            elementClass = (Class)elementClassType;
        } else {
            if (!(elementClassType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type " + elementClassType + ".");
            elementClass = (Class)((ParameterizedType)elementClassType).getRawType();
        }
        ResultHandle next = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, elementClass, elementClassType, next, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), (ResultHandle)cloneCollection, new ResultHandle[]{clonedElement});
        bytecodeCreator.assign(cloneResultHolder, (ResultHandle)cloneCollection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeDeepCloneMapInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class keyClass;
        Class elementClass;
        ResultHandle cloneMap;
        Class<Object> holderClass = deeplyClonedFieldClass;
        try {
            holderClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            holderClass = LinkedHashMap.class.isAssignableFrom(holderClass) ? LinkedHashMap.class : (ConcurrentHashMap.class.isAssignableFrom(holderClass) ? ConcurrentHashMap.class : LinkedHashMap.class);
        }
        ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        ResultHandle entrySet = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"entrySet", Set.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), entrySet, new ResultHandle[0]);
        try {
            holderClass.getConstructor(Integer.TYPE);
            cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size});
        }
        catch (NoSuchMethodException e) {
            cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[0]), new ResultHandle[0]);
        }
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();
        if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Map type (" + type + ").");
        Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type elementClassType = ((ParameterizedType)type).getActualTypeArguments()[1];
        if (elementClassType instanceof Class) {
            elementClass = (Class)elementClassType;
        } else {
            if (!(elementClassType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type " + elementClassType + ".");
            elementClass = (Class)((ParameterizedType)elementClassType).getRawType();
        }
        if (keyType instanceof Class) {
            keyClass = (Class)keyType;
        } else {
            if (!(keyType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type " + keyType + ".");
            keyClass = (Class)((ParameterizedType)keyType).getRawType();
        }
        List entitySubclasses = deepClonedClassesSortedSet.stream().filter(keyClass::isAssignableFrom).collect(Collectors.toList());
        ResultHandle entry = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
        ResultHandle toCloneValue = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getValue", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, elementClass, elementClassType, toCloneValue, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        ResultHandle key = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getKey", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        if (!entitySubclasses.isEmpty()) {
            AssignableResultHandle keyCloneResultHolder = whileLoopBlock.createVariable(keyClass);
            GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(whileLoopBlock, solutionDescriptor, keyClass, key, keyCloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, false);
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{keyCloneResultHolder, clonedElement});
        } else {
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{key, clonedElement});
        }
        bytecodeCreator.assign(cloneResultHolder, cloneMap);
    }

    private static void writeDeepCloneArrayInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class<?> arrayComponent = deeplyClonedFieldClass.getComponentType();
        ResultHandle arrayLength = bytecodeCreator.arrayLength(toClone);
        ResultHandle arrayClone = bytecodeCreator.newArray(arrayComponent, arrayLength);
        AssignableResultHandle iterations = bytecodeCreator.createVariable(Integer.TYPE);
        bytecodeCreator.assign(iterations, bytecodeCreator.load(0));
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> conditionBytecode.ifIntegerLessThan((ResultHandle)iterations, arrayLength)).block();
        ResultHandle toCloneElement = whileLoopBlock.readArrayValue(toClone, (ResultHandle)iterations);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(arrayComponent);
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, arrayComponent, arrayComponent, toCloneElement, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        whileLoopBlock.writeArrayValue(arrayClone, (ResultHandle)iterations, (ResultHandle)clonedElement);
        whileLoopBlock.assign(iterations, whileLoopBlock.increment((ResultHandle)iterations));
        bytecodeCreator.assign(cloneResultHolder, arrayClone);
    }

    private static void writeDeepCloneEntityOrFactInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet, boolean forceDeepClone) {
        List deepClonedSubclasses = deepClonedClassesSortedSet.stream().filter(deeplyClonedFieldClass::isAssignableFrom).filter(type -> DeepCloningUtils.isClassDeepCloned(solutionDescriptor.getSolutionDescriptor(), type)).collect(Collectors.toList());
        BytecodeCreator currentBranch = bytecodeCreator;
        for (Class deepClonedSubclass : deepClonedSubclasses) {
            ResultHandle isInstance = currentBranch.instanceOf(toClone, deepClonedSubclass);
            BranchResult isInstanceBranchResult = currentBranch.ifTrue(isInstance);
            BytecodeCreator isInstanceBranch = isInstanceBranchResult.trueBranch();
            ResultHandle cloneObj = isInstanceBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deepClonedSubclass), (Object)deepClonedSubclass, (Object[])new Object[]{deepClonedSubclass, Map.class}), new ResultHandle[]{toClone, createdCloneMap});
            isInstanceBranch.assign(cloneResultHolder, cloneObj);
            currentBranch = isInstanceBranchResult.falseBranch();
        }
        if (forceDeepClone) {
            ResultHandle cloneObj = currentBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deeplyClonedFieldClass), deeplyClonedFieldClass, (Object[])new Object[]{deeplyClonedFieldClass, Map.class}), new ResultHandle[]{toClone, createdCloneMap});
            currentBranch.assign(cloneResultHolder, cloneObj);
        } else {
            currentBranch.assign(cloneResultHolder, toClone);
        }
    }

    private static String getEntityHelperMethodName(Class<?> entityClass) {
        return "$clone" + entityClass.getName().replace('.', '_');
    }

    private static void createDeepCloneHelperMethod(ClassCreator classCreator, Class<?> entityClass, SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        MethodCreator methodCreator = classCreator.getMethodCreator(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class});
        methodCreator.setModifiers(10);
        GizmoSolutionOrEntityDescriptor entityDescriptor = memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(entityClass, key -> new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass));
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        ResultHandle cloneObj = noCloneBranch.newInstance(MethodDescriptor.ofConstructor(entityClass, (Class[])new Class[0]), new ResultHandle[0]);
        noCloneBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), cloneMap, new ResultHandle[]{toClone, cloneObj});
        for (GizmoMemberDescriptor shallowlyClonedField : entityDescriptor.getShallowClonedMemberDescriptors()) {
            GizmoSolutionClonerImplementor.writeShallowCloneInstructions(entityDescriptor, noCloneBranch, shallowlyClonedField, toClone, cloneObj, cloneMap, deepClonedClassesSortedSet);
        }
        for (Field deeplyClonedField : entityDescriptor.getDeepClonedFields()) {
            GizmoMemberDescriptor gizmoMemberDescriptor = entityDescriptor.getMemberDescriptorForField(deeplyClonedField);
            ResultHandle subfieldValue = gizmoMemberDescriptor.readMemberValue(noCloneBranch, toClone);
            AssignableResultHandle cloneValue = noCloneBranch.createVariable(deeplyClonedField.getType());
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(noCloneBranch, entityDescriptor, deeplyClonedField, gizmoMemberDescriptor, subfieldValue, cloneValue, cloneMap, deepClonedClassesSortedSet);
            if (gizmoMemberDescriptor.writeMemberValue(noCloneBranch, cloneObj, (ResultHandle)cloneValue)) continue;
            throw new IllegalStateException("The member (" + gizmoMemberDescriptor.getName() + ") of class (" + gizmoMemberDescriptor.getDeclaringClassName() + ") does not have a setter.");
        }
        noCloneBranch.returnValue(cloneObj);
    }

    private static void createAbstractDeepCloneHelperMethod(ClassCreator classCreator, Class<?> entityClass, SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        MethodCreator methodCreator = classCreator.getMethodCreator(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class});
        methodCreator.setModifiers(10);
        GizmoSolutionOrEntityDescriptor entityDescriptor = memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(entityClass, key -> new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass));
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        AssignableResultHandle cloneResultHolder = noCloneBranch.createVariable(entityClass);
        GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(noCloneBranch, entityDescriptor, entityClass, toClone, cloneResultHolder, cloneMap, deepClonedClassesSortedSet, false);
        noCloneBranch.returnValue((ResultHandle)cloneResultHolder);
    }

    private GizmoSolutionClonerImplementor() {
    }
}

