/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractFromPropertyValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_> {
    protected final MemberAccessor memberAccessor;
    protected boolean collectionWrapping;
    protected boolean arrayWrapping;
    protected boolean countable;

    public AbstractFromPropertyValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, boolean addNullInValueRange, MemberAccessor memberAccessor) {
        super(variableDescriptor, addNullInValueRange);
        this.memberAccessor = memberAccessor;
        ValueRangeProvider valueRangeProviderAnnotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The member (" + memberAccessor + ") must have a valueRangeProviderAnnotation (" + valueRangeProviderAnnotation + ").");
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (addNullInValueRange && !this.countable) {
            throw new IllegalStateException("The valueRangeDescriptor (" + this + ") is nullable, but not countable (" + this.countable + ").\nMaybe the member (" + memberAccessor + ") should return " + CountableValueRange.class.getSimpleName() + ".");
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        Class<?> arrayElementClass;
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> type = this.memberAccessor.getType();
        this.collectionWrapping = Collection.class.isAssignableFrom(type);
        this.arrayWrapping = type.isArray();
        if (!(this.collectionWrapping || this.arrayWrapping || ValueRange.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that does not return a " + Collection.class.getSimpleName() + ", an array or a " + ValueRange.class.getSimpleName() + ".");
        }
        if (this.collectionWrapping) {
            Class<?> collectionElementClass = ConfigUtils.extractCollectionGenericTypeParameterStrictly("solutionClass or entityClass", this.memberAccessor.getDeclaringClass(), this.memberAccessor.getType(), this.memberAccessor.getGenericType(), ValueRangeProvider.class, this.memberAccessor.getName());
            if (!this.variableDescriptor.acceptsValueType(collectionElementClass)) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a " + Collection.class.getSimpleName() + " with elements of type (" + collectionElementClass + ") which cannot be assigned to the @" + PlanningVariable.class.getSimpleName() + "'s type (" + this.variableDescriptor.getVariablePropertyType() + ").");
            }
        } else if (this.arrayWrapping && !this.variableDescriptor.acceptsValueType(arrayElementClass = type.getComponentType())) {
            throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns an array with elements of type (" + arrayElementClass + ") which cannot be assigned to the @" + PlanningVariable.class.getSimpleName() + "'s type (" + this.variableDescriptor.getVariablePropertyType() + ").");
        }
        this.countable = this.collectionWrapping || this.arrayWrapping || CountableValueRange.class.isAssignableFrom(type);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected ValueRange<?> readValueRange(Object bean) {
        ValueRange valueRange;
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return a null valueRangeObject (" + valueRangeObject + ").");
        }
        if (this.collectionWrapping || this.arrayWrapping) {
            List<Object> list;
            List<Object> list2 = list = this.collectionWrapping ? this.transformCollectionToList((Collection)valueRangeObject) : ReflectionHelper.transformArrayToList(valueRangeObject);
            if (!(list.isEmpty() || list.get(0) != null && list.get(list.size() - 1) != null)) {
                throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return a " + (this.collectionWrapping ? Collection.class.getSimpleName() : "array") + "(" + list + ") with an element that is null.\nMaybe remove that null element from the dataset.\nMaybe use @" + PlanningVariable.class.getSimpleName() + "(nullable = true) instead.");
            }
            valueRange = new ListValueRange<Object>(list);
        } else {
            valueRange = (ValueRange)valueRangeObject;
        }
        valueRange = this.doNullInValueRangeWrapping(valueRange);
        if (valueRange.isEmpty()) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return an empty valueRange (" + valueRangeObject + ").\nMaybe apply overconstrained planning as described in the documentation.");
        }
        return valueRange;
    }

    private <T> List<T> transformCollectionToList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }
}

