/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list;

import java.util.Objects;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import org.optaplanner.core.config.heuristic.selector.list.DestinationSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandomFactory;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.list.nearby.NearSubListNearbyDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.nearby.NearValueNearbyDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public final class DestinationSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, DestinationSelectorConfig> {
    public static <Solution_> DestinationSelectorFactory<Solution_> create(DestinationSelectorConfig destinationSelectorConfig) {
        return new DestinationSelectorFactory<Solution_>(destinationSelectorConfig);
    }

    private DestinationSelectorFactory(DestinationSelectorConfig destinationSelectorConfig) {
        super(destinationSelectorConfig);
    }

    public DestinationSelector<Solution_> buildDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        ElementDestinationSelector<Solution_> baseDestinationSelector = this.buildBaseDestinationSelector(configPolicy, minimumCacheType, selectionOrder);
        return this.applyNearbySelection(configPolicy, minimumCacheType, selectionOrder, baseDestinationSelector);
    }

    private ElementDestinationSelector<Solution_> buildBaseDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder selectionOrder) {
        EntitySelector entitySelector = EntitySelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getEntitySelectorConfig())).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        EntityIndependentValueSelector<Solution_> valueSelector = this.buildEntityIndependentValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        return new ElementDestinationSelector(entitySelector, valueSelector, selectionOrder.toRandomSelectionBoolean());
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getValueSelectorConfig())).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ValueSelectorFactory.ListValueFilteringType.ACCEPT_ASSIGNED);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The destinationSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        return (EntityIndependentValueSelector)valueSelector;
    }

    private DestinationSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, ElementDestinationSelector<Solution_> destinationSelector) {
        NearbySelectionConfig nearbySelectionConfig = ((DestinationSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig == null) {
            return destinationSelector;
        }
        nearbySelectionConfig.validateNearby(minimumCacheType, resolvedSelectionOrder);
        boolean randomSelection = resolvedSelectionOrder.toRandomSelectionBoolean();
        NearbyDistanceMeter nearbyDistanceMeter = configPolicy.getClassInstanceCache().newInstance(nearbySelectionConfig, "nearbyDistanceMeterClass", nearbySelectionConfig.getNearbyDistanceMeterClass());
        NearbyRandom nearbyRandom = NearbyRandomFactory.create(nearbySelectionConfig).buildNearbyRandom(randomSelection);
        if (nearbySelectionConfig.getOriginValueSelectorConfig() != null) {
            ValueSelector originValueSelector = ValueSelectorFactory.create(nearbySelectionConfig.getOriginValueSelectorConfig()).buildValueSelector(configPolicy, destinationSelector.getEntityDescriptor(), minimumCacheType, resolvedSelectionOrder);
            return new NearValueNearbyDestinationSelector<Solution_>(destinationSelector, (EntityIndependentValueSelector)originValueSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
        }
        if (nearbySelectionConfig.getOriginSubListSelectorConfig() != null) {
            SubListSelector subListSelector = SubListSelectorFactory.create(nearbySelectionConfig.getOriginSubListSelectorConfig()).buildSubListSelector(configPolicy, null, minimumCacheType, resolvedSelectionOrder);
            return new NearSubListNearbyDestinationSelector<Solution_>(destinationSelector, subListSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
        }
        throw new IllegalArgumentException("The destinationSelector (" + this.config + ")'s nearbySelectionConfig (" + nearbySelectionConfig + ") requires an originSubListSelector or an originValueSelector.");
    }
}

