/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Collections;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListAssignMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;

public class OriginalListChangeIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final IndexVariableSupply indexVariableSupply;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final Iterator<Object> valueIterator;
    private final DestinationSelector<Solution_> destinationSelector;
    private Iterator<ElementRef> destinationIterator;
    private Object upcomingSourceEntity;
    private Integer upcomingSourceIndex;
    private Object upcomingValue;

    public OriginalListChangeIterator(SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, EntityIndependentValueSelector<Solution_> valueSelector, DestinationSelector<Solution_> destinationSelector) {
        this.inverseVariableSupply = inverseVariableSupply;
        this.indexVariableSupply = indexVariableSupply;
        this.listVariableDescriptor = (ListVariableDescriptor)valueSelector.getVariableDescriptor();
        this.valueIterator = valueSelector.iterator();
        this.destinationSelector = destinationSelector;
        this.destinationIterator = Collections.emptyIterator();
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        while (!this.destinationIterator.hasNext()) {
            if (!this.valueIterator.hasNext()) {
                return (Move)this.noUpcomingSelection();
            }
            this.upcomingValue = this.valueIterator.next();
            this.upcomingSourceEntity = this.inverseVariableSupply.getInverseSingleton(this.upcomingValue);
            this.upcomingSourceIndex = this.indexVariableSupply.getIndex(this.upcomingValue);
            this.destinationIterator = this.destinationSelector.iterator();
        }
        ElementRef destination = this.destinationIterator.next();
        if (this.upcomingSourceEntity == null && this.upcomingSourceIndex == null) {
            return new ListAssignMove<Solution_>(this.listVariableDescriptor, this.upcomingValue, destination.getEntity(), destination.getIndex());
        }
        return new ListChangeMove<Solution_>(this.listVariableDescriptor, this.upcomingSourceEntity, this.upcomingSourceIndex, destination.getEntity(), destination.getIndex());
    }
}

