/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javassist.Loader;
import org.powermock.core.WildcardMatcher;
import org.powermock.reflect.Whitebox;

public abstract class DeferSupportingClassLoader
extends Loader {
    private final ConcurrentMap<String, SoftReference<Class<?>>> classes;
    String[] deferPackages;
    ClassLoader deferTo;

    public void addIgnorePackage(String ... packagesToIgnore) {
        if (packagesToIgnore != null && packagesToIgnore.length > 0) {
            int previousLength = this.deferPackages.length;
            String[] newDeferPackages = new String[previousLength + packagesToIgnore.length];
            System.arraycopy(this.deferPackages, 0, newDeferPackages, 0, previousLength);
            System.arraycopy(packagesToIgnore, 0, newDeferPackages, previousLength, packagesToIgnore.length);
            this.deferPackages = newDeferPackages;
        }
    }

    DeferSupportingClassLoader(ClassLoader classloader, String[] deferPackages) {
        this.deferTo = classloader == null ? ClassLoader.getSystemClassLoader() : classloader;
        this.classes = new ConcurrentHashMap();
        this.deferPackages = deferPackages;
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass1(name);
        if (clazz == null) {
            clazz = this.loadClass1(name, resolve);
        }
        return clazz;
    }

    private Class<?> loadClass1(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.shouldDefer(this.deferPackages, name) ? this.deferTo.loadClass(name) : this.loadModifiedClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        this.classes.put(name, new SoftReference(clazz));
        return clazz;
    }

    private Class<?> findLoadedClass1(String name) {
        SoftReference reference = (SoftReference)this.classes.get(name);
        Class clazz = null;
        if (reference != null) {
            clazz = (Class)reference.get();
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        return clazz;
    }

    boolean shouldDefer(String[] packages, String name) {
        for (String packageToCheck : packages) {
            if (!this.deferConditionMatches(name, packageToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean deferConditionMatches(String name, String packageName) {
        boolean wildcardMatch = WildcardMatcher.matches(name, packageName);
        return wildcardMatch && !this.shouldLoadUnmodifiedClass(name) && !this.shouldModifyClass(name);
    }

    private boolean shouldIgnore(Iterable<String> packages, String name) {
        for (String ignore : packages) {
            if (!WildcardMatcher.matches(ignore, name)) continue;
            return true;
        }
        return false;
    }

    boolean shouldIgnore(String[] packages, String name) {
        for (String ignore : packages) {
            if (!WildcardMatcher.matches(name, ignore)) continue;
            return true;
        }
        return false;
    }

    protected URL findResource(String name) {
        try {
            return (URL)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResource", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        try {
            return (Enumeration)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResources", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URL getResource(String s) {
        return this.deferTo.getResource(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this.deferTo.getResourceAsStream(s);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.deferTo.equals(this.getParent())) {
            return this.deferTo.getResources(name);
        }
        return super.getResources(name);
    }

    protected boolean shouldModify(Iterable<String> packages, String name) {
        return !this.shouldIgnore(packages, name);
    }

    protected abstract Class<?> loadModifiedClass(String var1) throws ClassFormatError, ClassNotFoundException;

    protected abstract boolean shouldModifyClass(String var1);

    protected abstract boolean shouldLoadUnmodifiedClass(String var1);

    public void cache(Class<?> cls) {
        if (cls != null) {
            this.classes.put(cls.getName(), new SoftReference(cls));
        }
    }
}

