/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.TestClassTransformer;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.IgnorePackagesExtractor;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.TestSuiteChunker;
import org.powermock.tests.utils.impl.ArrayMergerImpl;
import org.powermock.tests.utils.impl.MockClassLoaderFactory;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;
import org.powermock.tests.utils.impl.TestCaseEntry;
import org.powermock.tests.utils.impl.TestChunkImpl;

public abstract class AbstractCommonTestSuiteChunkerImpl
implements TestSuiteChunker {
    protected static final int DEFAULT_TEST_LISTENERS_SIZE = 1;
    protected static final int NOT_INITIALIZED = -1;
    protected static final int INTERNAL_INDEX_NOT_FOUND = -1;
    private final List<TestCaseEntry> internalSuites = new LinkedList<TestCaseEntry>();
    private final TestClassesExtractor prepareForTestExtractor = new PrepareForTestExtractorImpl();
    private final TestClassesExtractor suppressionExtractor = new StaticConstructorSuppressExtractorImpl();
    protected final LinkedHashMap<Integer, List<Integer>> testAtDelegateMapper = new LinkedHashMap();
    protected final Class<?>[] testClasses;
    private final IgnorePackagesExtractor ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
    private final ArrayMerger arrayMerger = new ArrayMergerImpl();
    private int currentTestIndex = -1;

    protected AbstractCommonTestSuiteChunkerImpl(Class<?> testClass) throws Exception {
        this(new Class[]{testClass});
    }

    protected AbstractCommonTestSuiteChunkerImpl(Class<?> ... testClasses) throws Exception {
        this.testClasses = testClasses;
        for (Class<?> clazz : testClasses) {
            this.chunkClass(clazz);
        }
    }

    @Override
    public int getChunkSize() {
        return this.getTestChunks().size();
    }

    @Override
    public List<TestChunk> getTestChunks() {
        LinkedList<TestChunk> allChunks = new LinkedList<TestChunk>();
        for (TestCaseEntry entry : this.internalSuites) {
            for (TestChunk chunk : entry.getTestChunks()) {
                allChunks.add(chunk);
            }
        }
        return allChunks;
    }

    @Override
    public List<TestChunk> getTestChunksEntries(Class<?> testClass) {
        for (TestCaseEntry entry : this.internalSuites) {
            if (!entry.getTestClass().equals(testClass)) continue;
            return entry.getTestChunks();
        }
        return null;
    }

    @Override
    public TestChunk getTestChunk(Method method) {
        for (TestChunk testChunk : this.getTestChunks()) {
            if (!testChunk.isMethodToBeExecutedByThisClassloader(method)) continue;
            return testChunk;
        }
        return null;
    }

    protected void chunkClass(Class<?> testClass) throws Exception {
        ArrayList<Method> testMethodsForOtherClassLoaders = new ArrayList<Method>();
        MockTransformer[] extraMockTransformers = this.createDefaultExtraMockTransformers(testClass, testMethodsForOtherClassLoaders);
        String[] ignorePackages = this.ignorePackagesExtractor.getPackagesToIgnore(testClass);
        ClassLoader defaultMockLoader = this.createDefaultMockLoader(testClass, extraMockTransformers, ignorePackages);
        LinkedList<Method> currentClassloaderMethods = new LinkedList<Method>();
        TestChunkImpl defaultTestChunk = new TestChunkImpl(defaultMockLoader, currentClassloaderMethods);
        LinkedList<TestChunk> testChunks = new LinkedList<TestChunk>();
        testChunks.add(defaultTestChunk);
        this.internalSuites.add(new TestCaseEntry(testClass, testChunks));
        this.initEntries(this.internalSuites);
        if (!currentClassloaderMethods.isEmpty()) {
            List<TestChunk> allTestChunks = this.internalSuites.get(0).getTestChunks();
            for (TestChunk chunk : allTestChunks.subList(1, allTestChunks.size())) {
                for (Method m : chunk.getTestMethodsToBeExecutedByThisClassloader()) {
                    testMethodsForOtherClassLoaders.add(m);
                }
            }
        } else if (2 <= this.internalSuites.size() || 1 == this.internalSuites.size() && 2 <= this.internalSuites.get(0).getTestChunks().size()) {
            this.internalSuites.get(0).getTestChunks().remove(0);
        }
    }

    private ClassLoader createDefaultMockLoader(Class<?> testClass, MockTransformer[] extraMockTransformers, String[] ignorePackages) {
        ClassLoader defaultMockLoader;
        if (testClass.isAnnotationPresent(PrepareEverythingForTest.class)) {
            defaultMockLoader = this.createNewClassloader(testClass, new String[]{"*"}, ignorePackages, extraMockTransformers);
        } else {
            String[] prepareForTestClasses = this.prepareForTestExtractor.getTestClasses(testClass);
            String[] suppressStaticClasses = this.suppressionExtractor.getTestClasses(testClass);
            defaultMockLoader = this.createNewClassloader(testClass, this.arrayMerger.mergeArrays(String.class, prepareForTestClasses, suppressStaticClasses), ignorePackages, extraMockTransformers);
        }
        return defaultMockLoader;
    }

    private ClassLoader createNewClassloader(Class<?> testClass, String[] classesToLoadByMockClassloader, String[] packagesToIgnore, MockTransformer ... extraMockTransformers) {
        MockClassLoaderFactory classLoaderFactory = this.getMockClassLoaderFactory(testClass, classesToLoadByMockClassloader, packagesToIgnore, extraMockTransformers);
        return classLoaderFactory.create();
    }

    protected MockClassLoaderFactory getMockClassLoaderFactory(Class<?> testClass, String[] preliminaryClassesToLoadByMockClassloader, String[] packagesToIgnore, MockTransformer[] extraMockTransformers) {
        return new MockClassLoaderFactory(testClass, preliminaryClassesToLoadByMockClassloader, packagesToIgnore, extraMockTransformers);
    }

    private MockTransformer[] createDefaultExtraMockTransformers(Class<?> testClass, List<Method> testMethodsThatRunOnOtherClassLoaders) {
        if (null == this.testMethodAnnotation()) {
            return new MockTransformer[0];
        }
        return new MockTransformer[]{TestClassTransformer.forTestClass(testClass).removesTestMethodAnnotation(this.testMethodAnnotation()).fromMethods(testMethodsThatRunOnOtherClassLoaders)};
    }

    protected Class<? extends Annotation> testMethodAnnotation() {
        return null;
    }

    private void initEntries(List<TestCaseEntry> entries) {
        for (TestCaseEntry testCaseEntry : entries) {
            Class<?> testClass = testCaseEntry.getTestClass();
            this.findMethods(testCaseEntry, testClass);
        }
    }

    private void findMethods(TestCaseEntry testCaseEntry, Class<?> testClass) {
        Method[] allMethods;
        for (Method method : allMethods = testClass.getMethods()) {
            this.putMethodToChunk(testCaseEntry, testClass, method);
        }
        if (!Object.class.equals(testClass = testClass.getSuperclass())) {
            this.findMethods(testCaseEntry, testClass);
        }
    }

    private void putMethodToChunk(TestCaseEntry testCaseEntry, Class<?> testClass, Method method) {
        if (this.shouldExecuteTestForMethod(testClass, method)) {
            ++this.currentTestIndex;
            if (this.hasChunkAnnotation(method)) {
                MockTransformer[] mockTransformerArray;
                LinkedList<Method> methodsInThisChunk = new LinkedList<Method>();
                methodsInThisChunk.add(method);
                String[] staticSuppressionClasses = this.getStaticSuppressionClasses(testClass, method);
                if (null == this.testMethodAnnotation()) {
                    mockTransformerArray = new TestClassTransformer[]{};
                } else {
                    TestClassTransformer[] testClassTransformerArray = new TestClassTransformer[1];
                    mockTransformerArray = testClassTransformerArray;
                    testClassTransformerArray[0] = TestClassTransformer.forTestClass(testClass).removesTestMethodAnnotation(this.testMethodAnnotation()).fromAllMethodsExcept(method);
                }
                MockTransformer[] extraTransformers = mockTransformerArray;
                ClassLoader mockClassloader = method.isAnnotationPresent(PrepareEverythingForTest.class) ? this.createNewClassloader(testClass, new String[]{"*"}, this.ignorePackagesExtractor.getPackagesToIgnore(testClass), extraTransformers) : this.createNewClassloader(testClass, this.arrayMerger.mergeArrays(String.class, this.prepareForTestExtractor.getTestClasses(method), staticSuppressionClasses), this.ignorePackagesExtractor.getPackagesToIgnore(testClass), extraTransformers);
                TestChunkImpl chunk = new TestChunkImpl(mockClassloader, methodsInThisChunk);
                testCaseEntry.getTestChunks().add(chunk);
                this.updatedIndexes();
            } else {
                testCaseEntry.getTestChunks().get(0).getTestMethodsToBeExecutedByThisClassloader().add(method);
                int currentDelegateIndex = this.internalSuites.size() - 1;
                List<Integer> testList = this.testAtDelegateMapper.get(currentDelegateIndex);
                if (testList == null) {
                    testList = new LinkedList<Integer>();
                    this.testAtDelegateMapper.put(currentDelegateIndex, testList);
                }
                testList.add(this.currentTestIndex);
            }
        }
    }

    private boolean hasChunkAnnotation(Method method) {
        return method.isAnnotationPresent(PrepareForTest.class) || method.isAnnotationPresent(SuppressStaticInitializationFor.class) || method.isAnnotationPresent(PrepareOnlyThisForTest.class) || method.isAnnotationPresent(PrepareEverythingForTest.class);
    }

    private String[] getStaticSuppressionClasses(Class<?> testClass, Method method) {
        String[] testClasses = method.isAnnotationPresent(SuppressStaticInitializationFor.class) ? this.suppressionExtractor.getTestClasses(method) : this.suppressionExtractor.getTestClasses(testClass);
        return testClasses;
    }

    private void updatedIndexes() {
        LinkedList<Integer> testIndexesForThisClassloader = new LinkedList<Integer>();
        testIndexesForThisClassloader.add(this.currentTestIndex);
        this.testAtDelegateMapper.put(this.internalSuites.size(), testIndexesForThisClassloader);
    }
}

