/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.redisson.MapWriteBehindTask;
import org.redisson.MapWriterTask;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonSemaphore;
import org.redisson.WriteBehindService;
import org.redisson.api.MapOptions;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.iterator.RedissonMapIterator;
import org.redisson.mapreduce.RedissonMapReduce;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonMap<K, V>
extends RedissonExpirable
implements RMap<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final RedissonClient redisson;
    final MapOptions<K, V> options;
    final WriteBehindService writeBehindService;
    final MapWriteBehindTask writeBehindTask;

    public RedissonMap(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(commandExecutor, name);
        this.redisson = redisson;
        this.options = options;
        if (options != null && options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
            this.writeBehindService = writeBehindService;
            this.writeBehindTask = writeBehindService.start(name, options);
        } else {
            this.writeBehindService = null;
            this.writeBehindTask = null;
        }
    }

    public RedissonMap(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
        this.options = options;
        if (options != null && options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
            this.writeBehindService = writeBehindService;
            this.writeBehindTask = writeBehindService.start(name, options);
        } else {
            this.writeBehindService = null;
            this.writeBehindTask = null;
        }
    }

    @Override
    public <KOut, VOut> RMapReduce<K, V, KOut, VOut> mapReduce() {
        return new RedissonMapReduce(this, this.redisson, this.commandExecutor.getConnectionManager());
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(K key) {
        String lockName = this.getLockByMapKey(key, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RLock getFairLock(K key) {
        String lockName = this.getLockByMapKey(key, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(K key) {
        String lockName = this.getLockByMapKey(key, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(K key) {
        String lockName = this.getLockByMapKey(key, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        this.checkValue(value);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            V newValue = value;
            if (oldValue != null) {
                newValue = remappingFunction.apply(oldValue, value);
            }
            if (newValue == null) {
                this.fastRemove(key);
            } else {
                this.fastPut(key, newValue);
            }
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        this.checkValue(value);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        RedissonPromise result = new RedissonPromise();
        long threadId = Thread.currentThread().getId();
        lock.lockAsync(threadId).onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<Object> oldValueFuture = this.getAsync(key);
            oldValueFuture.onComplete((oldValue, ex) -> {
                if (ex != null) {
                    lock.unlockAsync(threadId);
                    result.tryFailure((Throwable)ex);
                    return;
                }
                RedissonPromise<Object> newValuePromise = new RedissonPromise<Object>();
                if (oldValue != null) {
                    this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                        Object newValue;
                        try {
                            newValue = remappingFunction.apply((Object)oldValue, (Object)value);
                        }
                        catch (Exception exception) {
                            lock.unlockAsync(threadId);
                            result.tryFailure(exception);
                            return;
                        }
                        newValuePromise.trySuccess(newValue);
                    });
                } else {
                    newValuePromise.trySuccess(value);
                }
                newValuePromise.onComplete((newValue, ee) -> {
                    RFuture<Comparable<Boolean>> future = newValue != null ? this.fastPutAsync(key, newValue) : this.fastRemoveAsync(key);
                    future.onComplete((res, exc) -> {
                        lock.unlockAsync(threadId);
                        if (exc != null) {
                            result.tryFailure((Throwable)exc);
                            return;
                        }
                        result.trySuccess(newValue);
                    });
                });
            });
        });
        return result;
    }

    @Override
    public RFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        RedissonPromise result = new RedissonPromise();
        long threadId = Thread.currentThread().getId();
        lock.lockAsync(threadId).onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<Object> oldValueFuture = this.getAsync(key);
            oldValueFuture.onComplete((oldValue, ex) -> {
                if (ex != null) {
                    lock.unlockAsync(threadId);
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = remappingFunction.apply((K)key, (V)oldValue);
                    }
                    catch (Exception exception) {
                        lock.unlockAsync(threadId);
                        result.tryFailure(exception);
                        return;
                    }
                    if (newValue == null) {
                        if (oldValue != null) {
                            this.fastRemoveAsync(key).onComplete((res, exc) -> {
                                lock.unlockAsync(threadId);
                                if (exc != null) {
                                    result.tryFailure((Throwable)exc);
                                    return;
                                }
                                result.trySuccess(newValue);
                            });
                            return;
                        }
                    } else {
                        this.fastPutAsync(key, newValue).onComplete((res, exc) -> {
                            lock.unlockAsync(threadId);
                            if (exc != null) {
                                result.tryFailure((Throwable)exc);
                                return;
                            }
                            result.trySuccess(newValue);
                        });
                        return;
                    }
                    lock.unlockAsync(threadId);
                    result.trySuccess(newValue);
                });
            });
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (oldValue != null) {
                    this.fastRemove(key);
                }
            } else {
                this.fastPut(key, newValue);
            }
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        RLock lock = this.getLock(key);
        RedissonPromise result = new RedissonPromise();
        long threadId = Thread.currentThread().getId();
        lock.lockAsync(threadId).onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<Object> oldValueFuture = this.getAsync(key);
            oldValueFuture.onComplete((oldValue, ex) -> {
                if (ex != null) {
                    lock.unlockAsync(threadId);
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (oldValue != null) {
                    lock.unlockAsync(threadId);
                    result.trySuccess(oldValue);
                    return;
                }
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = mappingFunction.apply((K)key);
                    }
                    catch (Exception exception) {
                        lock.unlockAsync(threadId);
                        result.tryFailure(exception);
                        return;
                    }
                    if (newValue != null) {
                        this.fastPutAsync(key, newValue).onComplete((res, exc) -> {
                            lock.unlockAsync(threadId);
                            if (exc != null) {
                                result.tryFailure((Throwable)exc);
                                return;
                            }
                            result.trySuccess(newValue);
                        });
                        return;
                    }
                    lock.unlockAsync(threadId);
                    result.trySuccess(null);
                });
            });
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V value = this.get(key);
            if (value == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    this.fastPut(key, newValue);
                    V v = newValue;
                    return v;
                }
                V v = null;
                return v;
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        RedissonPromise result = new RedissonPromise();
        long threadId = Thread.currentThread().getId();
        lock.lockAsync(threadId).onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<Object> oldValueFuture = this.getAsync(key);
            oldValueFuture.onComplete((oldValue, ex) -> {
                if (ex != null) {
                    lock.unlockAsync(threadId);
                    result.tryFailure((Throwable)e);
                    return;
                }
                if (oldValue == null) {
                    lock.unlockAsync(threadId);
                    result.trySuccess(null);
                    return;
                }
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = remappingFunction.apply((K)key, (V)oldValue);
                    }
                    catch (Exception exception) {
                        lock.unlockAsync(threadId);
                        result.tryFailure(exception);
                        return;
                    }
                    if (newValue != null) {
                        RFuture<Boolean> replaceFuture = this.replaceAsync(key, oldValue, newValue);
                        replaceFuture.onComplete((re, ex1) -> {
                            lock.unlockAsync(threadId);
                            if (ex1 != null) {
                                result.tryFailure((Throwable)ex1);
                                return;
                            }
                            if (re.booleanValue()) {
                                result.trySuccess(newValue);
                            } else {
                                result.trySuccess(oldValue);
                            }
                        });
                    } else if (this.remove(key, oldValue)) {
                        RFuture<Boolean> removeFuture = this.removeAsync(key, oldValue);
                        removeFuture.onComplete((re, ex1) -> {
                            lock.unlockAsync(threadId);
                            if (ex1 != null) {
                                result.tryFailure((Throwable)ex1);
                                return;
                            }
                            if (re.booleanValue()) {
                                result.trySuccess(null);
                            } else {
                                result.trySuccess(oldValue);
                            }
                        });
                    }
                });
            });
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            if (oldValue == null) {
                V v = null;
                return v;
            }
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (this.replace(key, oldValue, newValue)) {
                    V v = newValue;
                    return v;
                }
            } else if (this.remove(key, oldValue)) {
                V v = null;
                return v;
            }
            V v = oldValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HLEN, this.getName());
    }

    @Override
    public int valueSize(K key) {
        return this.get(this.valueSizeAsync(key));
    }

    @Override
    public RFuture<Integer> valueSizeAsync(K key) {
        this.checkKey(key);
        String name = this.getName(key);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HSTRLEN, name, this.encodeMapKey(key));
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.containsKeyAsync(key));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkKey(key);
        String name = this.getName(key);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HEXISTS, name, this.encodeMapKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('hvals', KEYS[1]);for i = 1, #s, 1 do if ARGV[1] == s[i] then return 1 end end;return 0", Collections.singletonList(this.getName()), this.encodeMapValue(value));
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        return this.get(this.getAllAsync(keys));
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        if (keys.isEmpty()) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        RFuture<Map<K, Map>> future = this.getAllOperationAsync(keys);
        if (this.hasNoLoader()) {
            return future;
        }
        RedissonPromise result = new RedissonPromise();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (!res.keySet().containsAll(keys)) {
                HashSet newKeys = new HashSet(keys);
                newKeys.removeAll(res.keySet());
                this.loadAllAsync(newKeys, false, 1, (Map<K, V>)res).onComplete((r, ex) -> result.trySuccess((Map)res));
            } else {
                result.trySuccess((Map<K, V>)res);
            }
        });
        return result;
    }

    protected boolean hasNoLoader() {
        return this.options == null || this.options.getLoader() == null;
    }

    public RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 1);
        args.add(this.getName());
        this.encodeMapKeys(args, keys);
        RFuture<Map<K, V>> future = this.commandExecutor.readAsync(this.getName(), this.codec, new RedisCommand<Map<Object, Object>>("HMGET", new MapGetAllDecoder(new ArrayList<Object>(keys), 0), RedisCommand.ValueType.MAP_VALUE), args.toArray());
        return future;
    }

    @Override
    public V get(Object key) {
        return this.get(this.getAsync(key));
    }

    @Override
    public V put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.get(this.removeAsync(key));
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.get(this.putAllAsync(map));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, int batchSize) {
        this.get(this.putAllAsync(map, batchSize));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, int batchSize) {
        HashMap batch = new HashMap();
        AtomicInteger counter = new AtomicInteger();
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.putAllAsync(batch, iter, counter, batchSize, promise);
        return promise;
    }

    private void putAllAsync(Map<K, V> batch, Iterator<Map.Entry<K, V>> iter, AtomicInteger counter, int batchSize, RPromise<Void> promise) {
        batch.clear();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            batch.put(entry.getKey(), entry.getValue());
            counter.incrementAndGet();
            if (counter.get() % batchSize != 0) continue;
            RFuture<Void> future = this.putAllAsync(batch);
            future.onComplete((res, e) -> {
                if (e != null) {
                    promise.tryFailure((Throwable)e);
                    return;
                }
                this.putAllAsync(batch, iter, counter, batchSize, promise);
            });
            return;
        }
        if (batch.isEmpty()) {
            promise.trySuccess(null);
            return;
        }
        RFuture<Void> future = this.putAllAsync(batch);
        future.onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            promise.trySuccess(null);
        });
    }

    @Override
    public final RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RFuture<Void> future = this.putAllOperationAsync(map);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(map));
    }

    protected final <M> RFuture<M> mapWriterFuture(RFuture<M> future, MapWriterTask task) {
        return this.mapWriterFuture(future, task, r -> true);
    }

    protected final <M> RFuture<M> mapWriterFuture(RFuture<M> future, MapWriterTask task, Function<M, Boolean> condition) {
        if (this.options != null && this.options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
            future.onComplete((res, e) -> {
                if (e == null && ((Boolean)condition.apply(res)).booleanValue()) {
                    this.writeBehindTask.addTask(task);
                }
            });
            return future;
        }
        RedissonPromise promise = new RedissonPromise();
        future.onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            if (((Boolean)condition.apply(res)).booleanValue()) {
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    try {
                        if (task instanceof MapWriterTask.Add) {
                            this.options.getWriter().write(task.getMap());
                        } else {
                            this.options.getWriter().delete(task.getKeys());
                        }
                    }
                    catch (Exception ex) {
                        promise.tryFailure(ex);
                        return;
                    }
                    promise.trySuccess(res);
                });
            } else {
                promise.trySuccess(res);
            }
        });
        return promise;
    }

    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map) {
        ArrayList<String> params = new ArrayList<String>(map.size() * 2 + 1);
        params.add(this.getName());
        for (Map.Entry<K, V> t : map.entrySet()) {
            this.checkKey(t.getKey());
            this.checkValue(t.getValue());
            params.add((String)this.encodeMapKey(t.getKey()));
            params.add((String)this.encodeMapValue(t.getValue()));
        }
        RFuture<Void> future = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HMSET, params.toArray());
        return future;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(null);
    }

    @Override
    public Set<K> keySet(String pattern) {
        return this.keySet(pattern, 10);
    }

    @Override
    public Set<K> keySet(String pattern, int count) {
        return new KeySet(pattern, count);
    }

    @Override
    public Set<K> keySet(int count) {
        return this.keySet(null, count);
    }

    @Override
    public Collection<V> values() {
        return this.values(null);
    }

    @Override
    public Collection<V> values(String keyPattern, int count) {
        return new Values(keyPattern, count);
    }

    @Override
    public Collection<V> values(String keyPattern) {
        return this.values(keyPattern, 10);
    }

    @Override
    public Collection<V> values(int count) {
        return this.values(null, count);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(String keyPattern) {
        return this.entrySet(keyPattern, 10);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(String keyPattern, int count) {
        return new EntrySet(keyPattern, count);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(int count) {
        return this.entrySet(null, count);
    }

    @Override
    public Set<K> readAllKeySet() {
        return this.get(this.readAllKeySetAsync());
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HKEYS, this.getName());
    }

    @Override
    public Collection<V> readAllValues() {
        return this.get(this.readAllValuesAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HVALS, this.getName());
    }

    @Override
    public Set<Map.Entry<K, V>> readAllEntrySet() {
        return this.get(this.readAllEntrySetAsync());
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HGETALL_ENTRY, this.getName());
    }

    @Override
    public Map<K, V> readAllMap() {
        return this.get(this.readAllMapAsync());
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HGETALL, this.getName());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.get(this.putIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(key);
        RFuture<V> future = this.putIfAbsentOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r == null);
    }

    protected boolean hasNoWriter() {
        return this.options == null || this.options.getWriter() == null;
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hsetnx', KEYS[1], ARGV[1], ARGV[2]) == 1 then return nil else return redis.call('hget', KEYS[1], ARGV[1]) end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value) {
        return this.get(this.fastPutIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastPutIfAbsentOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.HSETNX, name, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.removeOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Remove listener = new MapWriterTask.Remove(key);
        return this.mapWriterFuture(future, listener, Function.identity());
    }

    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        String name = this.getName(key);
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
        return future;
    }

    protected void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.get(this.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.checkKey(key);
        if (oldValue == null) {
            throw new NullPointerException("map oldValue can't be null");
        }
        if (newValue == null) {
            throw new NullPointerException("map newValue can't be null");
        }
        RFuture<Boolean> future = this.replaceOperationAsync(key, oldValue, newValue);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, newValue);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); return 1; else return 0; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.get(this.replaceAsync(key, value));
    }

    @Override
    public RFuture<V> replaceAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.replaceOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r != null);
    }

    protected RFuture<V> replaceOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v; else return nil; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastReplace(K key, V value) {
        return this.get(this.fastReplaceAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastReplaceAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastReplaceOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastReplaceOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return 1; else return 0; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    public RFuture<V> getOperationAsync(K key) {
        String name = this.getName(key);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HGET, name, this.encodeMapKey(key));
    }

    @Override
    public RFuture<V> getAsync(K key) {
        this.checkKey(key);
        RFuture<Object> future = this.getOperationAsync(key);
        if (this.hasNoLoader()) {
            return future;
        }
        RedissonPromise result = new RedissonPromise();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res == null) {
                this.loadValue(key, result, false);
            } else {
                result.trySuccess(res);
            }
        });
        return result;
    }

    @Override
    public void loadAll(boolean replaceExistingValues, int parallelism) {
        this.get(this.loadAllAsync(replaceExistingValues, parallelism));
    }

    @Override
    public RFuture<Void> loadAllAsync(boolean replaceExistingValues, int parallelism) {
        Iterable<K> keys;
        try {
            keys = this.options.getLoader().loadAllKeys();
        }
        catch (Exception e) {
            this.log.error("Unable to load keys for map " + this.getName(), (Throwable)e);
            return RedissonPromise.newFailedFuture(e);
        }
        return this.loadAllAsync(keys, replaceExistingValues, parallelism, null);
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        this.get(this.loadAllAsync(keys, replaceExistingValues, parallelism));
    }

    @Override
    public RFuture<Void> loadAllAsync(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        return this.loadAllAsync(keys, replaceExistingValues, parallelism, null);
    }

    private RFuture<Void> loadAllAsync(Iterable<? extends K> keys, boolean replaceExistingValues, int parallelism, Map<K, V> loadedEntires) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("parallelism can't be lower than 1");
        }
        for (K key : keys) {
            this.checkKey(key);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        AtomicInteger counter = new AtomicInteger();
        try {
            Iterator<K> iter = keys.iterator();
            for (int i = 0; i < parallelism; ++i) {
                if (!iter.hasNext()) {
                    if (counter.get() == 0) {
                        result.trySuccess(null);
                    }
                    break;
                }
                counter.incrementAndGet();
                K key = iter.next();
                if (replaceExistingValues) {
                    this.loadValue(result, counter, iter, key, loadedEntires);
                    continue;
                }
                this.checkAndLoadValue(result, counter, iter, key, loadedEntires);
            }
        }
        catch (Exception e) {
            this.log.error("Unable to load keys for map " + this.getName(), (Throwable)e);
            return RedissonPromise.newFailedFuture(e);
        }
        return result;
    }

    private void checkAndLoadValue(RPromise<Void> result, AtomicInteger counter, Iterator<? extends K> iter, K key, Map<K, V> loadedEntires) {
        this.containsKeyAsync(key).onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (!res.booleanValue()) {
                RedissonPromise promise = new RedissonPromise();
                promise.onComplete((r, ex) -> {
                    if (ex != null) {
                        result.tryFailure((Throwable)ex);
                        return;
                    }
                    if (loadedEntires != null && r != null) {
                        loadedEntires.put(key, r);
                    }
                    this.checkAndLoadValue(result, counter, iter, loadedEntires);
                });
                this.loadValue(key, promise, false);
            } else {
                this.checkAndLoadValue(result, counter, iter, loadedEntires);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndLoadValue(RPromise<Void> result, AtomicInteger counter, Iterator<? extends K> iter, Map<K, V> loadedEntires) {
        K key = null;
        Iterator<K> iterator = iter;
        synchronized (iterator) {
            if (iter.hasNext()) {
                key = iter.next();
            }
        }
        if (key == null) {
            if (counter.decrementAndGet() == 0) {
                result.trySuccess(null);
            }
        } else if (!result.isDone()) {
            this.checkAndLoadValue(result, counter, iter, key, loadedEntires);
        }
    }

    private void loadValue(RPromise<Void> result, AtomicInteger counter, Iterator<? extends K> iter, K k, Map<K, V> loadedEntires) {
        RedissonPromise promise = new RedissonPromise();
        promise.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (loadedEntires != null && res != null) {
                loadedEntires.put(k, res);
            }
            K key = null;
            Iterator iterator = iter;
            synchronized (iterator) {
                if (iter.hasNext()) {
                    key = (K)iter.next();
                }
            }
            if (key == null) {
                if (counter.decrementAndGet() == 0) {
                    result.trySuccess(null);
                }
            } else if (!result.isDone()) {
                this.loadValue(result, counter, iter, key, loadedEntires);
            }
        });
        this.loadValue(k, promise, true);
    }

    @Override
    public RFuture<V> putAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.putOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<V> putOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public RFuture<V> removeAsync(K key) {
        this.checkKey(key);
        RFuture<V> future = this.removeOperationAsync(key);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Remove(key));
    }

    protected RFuture<V> removeOperationAsync(K key) {
        String name = this.getName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hdel', KEYS[1], ARGV[1]); return v", Collections.singletonList(name), this.encodeMapKey(key));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastPutOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        String name = this.getName(key);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.HSET, name, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPut(K key, V value) {
        return this.get(this.fastPutAsync(key, value));
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        if (keys.length == 0) {
            return RedissonPromise.newSucceededFuture(0L);
        }
        if (this.hasNoWriter()) {
            return this.fastRemoveOperationAsync(keys);
        }
        RFuture<List<Long>> future = this.fastRemoveOperationBatchAsync(keys);
        RedissonPromise<Long> result = new RedissonPromise<Long>();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.isEmpty()) {
                result.trySuccess(0L);
                return;
            }
            ArrayList<Object> deletedKeys = new ArrayList<Object>();
            for (int i = 0; i < res.size(); ++i) {
                if ((Long)res.get(i) != 1L) continue;
                deletedKeys.add(keys[i]);
            }
            if (this.options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
                result.trySuccess(Long.valueOf(deletedKeys.size()));
                MapWriterTask.Remove task = new MapWriterTask.Remove(deletedKeys);
                this.writeBehindTask.addTask(task);
            } else {
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    this.options.getWriter().delete(deletedKeys);
                    result.trySuccess(Long.valueOf(deletedKeys.size()));
                });
            }
        });
        return result;
    }

    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>(keys.length);
        for (K key : keys) {
            args.add(this.encodeMapKey(key));
        }
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getName()), args.toArray());
        return future;
    }

    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        ArrayList<String> args = new ArrayList<String>(keys.length + 1);
        args.add(this.getName());
        for (K key : keys) {
            args.add((String)this.encodeMapKey(key));
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HDEL, args.toArray());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    public MapScanResult<Object, Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        RFuture<MapScanResult<Object, Object>> f = this.scanIteratorAsync(name, client, startPos, pattern, count);
        return this.get(f);
    }

    public RFuture<MapScanResult<Object, Object>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern, int count) {
        if (pattern == null) {
            RFuture<MapScanResult<Object, Object>> f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos, "COUNT", count);
            return f;
        }
        RFuture<MapScanResult<Object, Object>> f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos, "MATCH", pattern, "COUNT", count);
        return f;
    }

    @Override
    public V addAndGet(K key, Number value) {
        return this.get(this.addAndGetAsync(key, value));
    }

    @Override
    public RFuture<V> addAndGetAsync(final K key, Number value) {
        this.checkKey(key);
        this.checkValue(value);
        final RFuture<V> future = this.addAndGetOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(){

            @Override
            public Map<K, V> getMap() {
                return Collections.singletonMap(key, future.getNow());
            }
        });
    }

    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String name = this.getName(key);
        RFuture future = this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("HINCRBYFLOAT", new NumberConvertor(value.getClass())), name, keyState, new BigDecimal(value.toString()).toPlainString());
        return future;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    protected Iterator<K> keyIterator(String pattern, int count) {
        return new RedissonMapIterator<K>(this, pattern, count){

            @Override
            protected K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        };
    }

    protected Iterator<V> valueIterator(String pattern, int count) {
        return new RedissonMapIterator<V>(this, pattern, count){

            @Override
            protected V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        };
    }

    protected Iterator<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new RedissonMapIterator<Map.Entry<K, V>>(this, pattern, count);
    }

    private void loadValue(K key, RPromise<V> result, boolean replaceValue) {
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        lock.lockAsync(threadId).onComplete((res, e) -> {
            if (e != null) {
                lock.unlockAsync(threadId);
                result.tryFailure((Throwable)e);
                return;
            }
            if (replaceValue) {
                this.loadValue(key, result, lock, threadId);
                return;
            }
            this.getOperationAsync(key).onComplete((r, ex) -> {
                if (ex != null) {
                    lock.unlockAsync(threadId);
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (r != null) {
                    this.unlock(result, lock, threadId, r);
                    return;
                }
                this.loadValue(key, result, lock, threadId);
            });
        });
    }

    private void loadValue(final K key, final RPromise<V> result, final RLock lock, final long threadId) {
        this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Object value;
                try {
                    value = RedissonMap.this.options.getLoader().load(key);
                    if (value == null) {
                        RedissonMap.this.unlock(result, lock, threadId, value);
                        return;
                    }
                }
                catch (Exception e2) {
                    RedissonMap.this.log.error("Unable to load value by key " + key + " for map " + RedissonMap.this.getName(), (Throwable)e2);
                    RedissonMap.this.unlock(result, lock, threadId, null);
                    return;
                }
                RedissonMap.this.putOperationAsync(key, value).onComplete((res, e) -> {
                    if (e != null) {
                        lock.unlockAsync(threadId);
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonMap.this.unlock(result, lock, threadId, value);
                });
            }
        });
    }

    private void unlock(RPromise<V> result, RLock lock, long threadId, V value) {
        lock.unlockAsync(threadId).onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            result.trySuccess(value);
        });
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final String keyPattern;
        private final int count;

        EntrySet(String keyPattern, int count) {
            this.keyPattern = keyPattern;
            this.count = count;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return RedissonMap.this.entryIterator(this.keyPattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = RedissonMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonMap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public int size() {
            if (this.keyPattern != null) {
                int size = 0;
                for (Map.Entry val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final String keyPattern;
        private final int count;

        Values(String keyPattern, int count) {
            this.keyPattern = keyPattern;
            this.count = count;
        }

        @Override
        public Iterator<V> iterator() {
            return RedissonMap.this.valueIterator(this.keyPattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsValue(o);
        }

        @Override
        public int size() {
            if (this.keyPattern != null) {
                int size = 0;
                for (Object val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private final String pattern;
        private final int count;

        KeySet(String pattern, int count) {
            this.pattern = pattern;
            this.count = count;
        }

        @Override
        public Iterator<K> iterator() {
            return RedissonMap.this.keyIterator(this.pattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonMap.this.fastRemove(o) == 1L;
        }

        @Override
        public int size() {
            if (this.pattern != null) {
                int size = 0;
                for (Object val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }
}

