/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.redisson.client.RedisConnection;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.pubsub.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionWatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<Entry> entries = new ConcurrentLinkedQueue<Entry>();
    private final ScheduledFuture<?> monitorFuture;

    public IdleConnectionWatcher(ConnectionManager manager, final MasterSlaveServersConfig config) {
        this.monitorFuture = manager.getGroup().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                long currTime = System.currentTimeMillis();
                for (Entry entry : IdleConnectionWatcher.this.entries) {
                    if (!IdleConnectionWatcher.this.validateAmount(entry)) continue;
                    for (final RedisConnection c : entry.connections) {
                        final long timeInPool = currTime - c.getLastUsageTime();
                        if (timeInPool <= (long)config.getIdleConnectionTimeout() || !IdleConnectionWatcher.this.validateAmount(entry) || !((Boolean)entry.deleteHandler.apply(c)).booleanValue()) continue;
                        ChannelFuture future = c.closeAsync();
                        future.addListener((GenericFutureListener)new FutureListener<Void>(){

                            public void operationComplete(Future<Void> future) throws Exception {
                                IdleConnectionWatcher.this.log.debug("Connection {} has been closed due to idle timeout. Not used for {} ms", (Object)c.getChannel(), (Object)timeInPool);
                            }
                        });
                    }
                }
            }
        }, (long)config.getIdleConnectionTimeout(), (long)config.getIdleConnectionTimeout(), TimeUnit.MILLISECONDS);
    }

    private boolean validateAmount(Entry entry) {
        return entry.maximumAmount - entry.freeConnectionsCounter.getCounter() + entry.connections.size() > entry.minimumAmount;
    }

    public void add(int minimumAmount, int maximumAmount, Collection<? extends RedisConnection> connections, AsyncSemaphore freeConnectionsCounter, Function<RedisConnection, Boolean> deleteHandler) {
        this.entries.add(new Entry(minimumAmount, maximumAmount, connections, freeConnectionsCounter, deleteHandler));
    }

    public void stop() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
    }

    public static class Entry {
        private final int minimumAmount;
        private final int maximumAmount;
        private final AsyncSemaphore freeConnectionsCounter;
        private final Collection<? extends RedisConnection> connections;
        private final Function<RedisConnection, Boolean> deleteHandler;

        public Entry(int minimumAmount, int maximumAmount, Collection<? extends RedisConnection> connections, AsyncSemaphore freeConnectionsCounter, Function<RedisConnection, Boolean> deleteHandler) {
            this.minimumAmount = minimumAmount;
            this.maximumAmount = maximumAmount;
            this.connections = connections;
            this.freeConnectionsCounter = freeConnectionsCounter;
            this.deleteHandler = deleteHandler;
        }
    }
}

