/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

public abstract class PublisherAdder<V> {
    public abstract RFuture<Boolean> add(Object var1);

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        final CompletableFuture promise = new CompletableFuture();
        c.subscribe((Subscriber)new BaseSubscriber<V>(){
            volatile boolean completed;
            AtomicLong values = new AtomicLong();
            Subscription s;
            Boolean lastSize = false;

            protected void hookOnSubscribe(Subscription s) {
                this.s = s;
                s.request(1L);
            }

            protected void hookOnNext(V o) {
                this.values.getAndIncrement();
                PublisherAdder.this.add(o).onComplete((res, e) -> {
                    if (e != null) {
                        promise.completeExceptionally((Throwable)e);
                        return;
                    }
                    if (res.booleanValue()) {
                        this.lastSize = true;
                    }
                    this.s.request(1L);
                    if (this.values.decrementAndGet() == 0L && this.completed) {
                        promise.complete(this.lastSize);
                    }
                });
            }

            protected void hookOnComplete() {
                this.completed = true;
                if (this.values.get() == 0L) {
                    promise.complete(this.lastSize);
                }
            }
        });
        return Mono.fromCompletionStage(promise);
    }
}

